/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import org.alfresco.repo.cache.InternalEhCacheManagerFactoryBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EhCacheTracerJob
implements Job {
    private static Log logger = LogFactory.getLog(EhCacheTracerJob.class);
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            this.execute();
        }
        catch (Throwable e) {
            logger.error((Object)"Exception during execution of job", e);
        }
    }

    private void execute() throws Exception {
        if (this.cacheManager == null) {
            this.cacheManager = InternalEhCacheManagerFactoryBean.getInstance();
        }
        long maxHeapSize = Runtime.getRuntime().maxMemory();
        long allCachesTotalSize = 0L;
        double estimatedMaxSize = 0.0;
        String[] cacheNames = this.cacheManager.getCacheNames();
        logger.debug((Object)"Dumping EHCache info:");
        boolean analyzeAll = true;
        for (String cacheName : cacheNames) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            Log cacheLogger = LogFactory.getLog((String)(this.getClass().getName() + "." + cacheName));
            if (cacheLogger.isDebugEnabled()) {
                CacheAnalysis analysis = new CacheAnalysis(cache);
                cacheLogger.debug((Object)analysis);
                allCachesTotalSize += analysis.getSize();
                double cacheEstimatedMaxSize = analysis.getEstimatedMaxSize();
                estimatedMaxSize += Double.isNaN(cacheEstimatedMaxSize) || Double.isInfinite(cacheEstimatedMaxSize) ? 0.0 : cacheEstimatedMaxSize;
                continue;
            }
            analyzeAll = false;
        }
        if (analyzeAll) {
            double sizePercentage = (double)allCachesTotalSize / (double)maxHeapSize * 100.0;
            double maxSizePercentage = estimatedMaxSize / (double)maxHeapSize * 100.0;
            String msg = String.format("EHCaches currently consume %5.2f MB or %3.2f percent of system VM size. \nThe estimated maximum size is %5.2f MB or %3.2f percent of system VM size.", (double)allCachesTotalSize / 1024.0 / 1024.0, sizePercentage, estimatedMaxSize / 1024.0 / 1024.0, maxSizePercentage);
            logger.debug((Object)msg);
        }
    }

    private static class CacheAnalysis {
        private Cache cache;
        private long size = 0L;
        double sizeMB;
        long maxSize;
        long currentSize;
        long hitCount;
        long missCount;
        double percentageFull;
        double estMaxSize;

        public CacheAnalysis(Cache cache) throws CacheException {
            this.cache = cache;
            if (this.cache.getStatus().equals(Status.STATUS_ALIVE)) {
                try {
                    this.calculateSize();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public synchronized long getSize() {
            return this.size;
        }

        public synchronized double getEstimatedMaxSize() {
            return this.estMaxSize;
        }

        private synchronized void calculateSize() throws CacheException {
            List keys = this.cache.getKeys();
            int count = 0;
            for (Serializable key : keys) {
                Element element = this.cache.get(key);
                this.size += this.getSize((Serializable)element);
                if (++count < 50) continue;
                break;
            }
            this.size = count > 0 ? (long)((double)this.size * ((double)keys.size() / (double)count)) : 0L;
            this.sizeMB = (double)this.size / 1024.0 / 1024.0;
            LiveCacheStatistics statistics = this.cache.getLiveCacheStatistics();
            this.maxSize = this.cache.getCacheConfiguration().getMaxElementsInMemory();
            this.currentSize = this.cache.getMemoryStoreSize();
            this.hitCount = statistics.getCacheHitCount();
            this.missCount = statistics.getCacheMissCount();
            this.percentageFull = (double)this.currentSize / (double)this.maxSize * 100.0;
            this.estMaxSize = (double)this.size / (double)this.currentSize * (double)this.maxSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long getSize(Serializable obj) {
            long l;
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = null;
            try {
                try {
                    oos = new ObjectOutputStream(bout);
                    oos.writeObject(obj);
                    l = bout.size();
                    Object var8_6 = null;
                }
                catch (IOException e) {
                    logger.warn((Object)("Deep size calculation failed for cache: \n" + this.cache));
                    long l2 = 0L;
                    Object var8_7 = null;
                    try {
                        oos.close();
                        return l2;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return l2;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {}
                catch (IOException e2) {
                    throw throwable;
                }
                oos.close();
                throw throwable;
            }
            try {}
            catch (IOException e2) {
                // empty catch block
                return l;
            }
            oos.close();
            return l;
        }

        public String toString() {
            double sizeMB = (double)this.getSize() / 1024.0 / 1024.0;
            LiveCacheStatistics statistics = this.cache.getLiveCacheStatistics();
            long maxSize = this.cache.getCacheConfiguration().getMaxElementsInMemory();
            long currentSize = this.cache.getMemoryStoreSize();
            long hitCount = statistics.getCacheHitCount();
            long totalMissCount = statistics.getCacheMissCount() + statistics.getCacheMissCountExpired();
            double hitRatio = (double)hitCount / (double)(totalMissCount + hitCount) * 100.0;
            double percentageFull = (double)currentSize / (double)maxSize * 100.0;
            double estMaxSize = sizeMB / (double)currentSize * (double)maxSize;
            StringBuilder sb = new StringBuilder(512);
            sb.append("\n").append("===>  EHCache: ").append(this.cache).append("\n").append("      Hit Ratio:              ").append(String.format("%10.2f percent  ", hitRatio)).append("   |         Hit Count:     ").append(String.format("%10d hits     ", hitCount)).append("   |         Miss Count:    ").append(String.format("%10d misses   ", totalMissCount)).append("\n").append("      Deep Size:              ").append(String.format("%10.2f MB     ", sizeMB)).append("     |         Current Count: ").append(String.format("%10d entries  ", currentSize)).append("\n").append("      Percentage used:        ").append(String.format("%10.2f percent", percentageFull)).append("     |         Max Count:     ").append(String.format("%10d entries  ", maxSize)).append("\n").append("      Estimated maximum size: ").append(String.format("%10.2f MB     ", estMaxSize));
            return sb.toString();
        }
    }
}

