/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache.lookup;

import java.io.Serializable;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityLookupCache<K extends Serializable, V, VK extends Serializable> {
    private static final Serializable VALUE_NULL = "@@VALUE_NULL@@";
    private static final Serializable VALUE_NOT_FOUND = "@@VALUE_NOT_FOUND@@";
    private static final String CACHE_REGION_DEFAULT = "DEFAULT";
    private final SimpleCache<Serializable, Object> cache;
    private final EntityLookupCallbackDAO<K, V, VK> entityLookup;
    private final String cacheRegion;

    public EntityLookupCache(EntityLookupCallbackDAO<K, V, VK> entityLookup) {
        this(null, CACHE_REGION_DEFAULT, entityLookup);
    }

    public EntityLookupCache(SimpleCache cache, EntityLookupCallbackDAO<K, V, VK> entityLookup) {
        this(cache, CACHE_REGION_DEFAULT, entityLookup);
    }

    public EntityLookupCache(SimpleCache cache, String cacheRegion, EntityLookupCallbackDAO<K, V, VK> entityLookup) {
        ParameterCheck.mandatory((String)"cacheRegion", (Object)cacheRegion);
        ParameterCheck.mandatory((String)"entityLookup", entityLookup);
        this.cache = cache;
        this.cacheRegion = cacheRegion;
        this.entityLookup = entityLookup;
    }

    public Pair<K, V> getByKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("An entity lookup key may not be null");
        }
        if (this.cache == null) {
            return this.entityLookup.findByKey(key);
        }
        CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, (Serializable)key);
        Object value = this.cache.get((Serializable)keyCacheKey);
        if (value != null) {
            if (value.equals(VALUE_NOT_FOUND)) {
                return null;
            }
            if (value.equals(VALUE_NULL)) {
                return new Pair(key, null);
            }
            return new Pair(key, value);
        }
        Pair<K, V> entityPair = this.entityLookup.findByKey(key);
        if (entityPair == null) {
            this.cache.put((Serializable)keyCacheKey, (Object)VALUE_NOT_FOUND);
        } else {
            Serializable valueKey;
            value = entityPair.getSecond();
            Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
            if (valueKey != null) {
                CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
                this.cache.put((Serializable)valueCacheKey, key);
            }
            this.cache.put((Serializable)keyCacheKey, value == null ? VALUE_NULL : value);
        }
        return entityPair;
    }

    public Pair<K, V> getByValue(V value) {
        Serializable valueKey;
        if (this.cache == null) {
            return this.entityLookup.findByValue(value);
        }
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey == null) {
            return this.entityLookup.findByValue(value);
        }
        CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
        Serializable key = (Serializable)this.cache.get((Serializable)valueCacheKey);
        if (key != null) {
            if (key.equals(VALUE_NOT_FOUND)) {
                return null;
            }
            return this.getByKey(key);
        }
        Pair<K, V> entityPair = this.entityLookup.findByValue(value);
        if (entityPair == null) {
            this.cache.put((Serializable)valueCacheKey, (Object)VALUE_NOT_FOUND);
        } else {
            key = (Serializable)entityPair.getFirst();
            this.cache.put((Serializable)valueCacheKey, (Object)key);
            this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, key), entityPair.getSecond() == null ? VALUE_NULL : entityPair.getSecond());
        }
        return entityPair;
    }

    public Pair<K, V> getOrCreateByValue(V value) {
        Serializable valueKey;
        if (this.cache == null) {
            Pair<K, V> entityPair = this.entityLookup.findByValue(value);
            if (entityPair == null) {
                entityPair = this.entityLookup.createValue(value);
            }
            return entityPair;
        }
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey == null) {
            Pair<K, V> entityPair = this.entityLookup.findByValue(value);
            if (entityPair == null) {
                entityPair = this.entityLookup.createValue(value);
                this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, (Serializable)entityPair.getFirst()), entityPair.getSecond() == null ? VALUE_NULL : entityPair.getSecond());
            }
            return entityPair;
        }
        CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
        Serializable key = (Serializable)this.cache.get((Serializable)valueCacheKey);
        if (key != null && !key.equals(VALUE_NOT_FOUND)) {
            return this.getByKey(key);
        }
        Pair<K, V> entityPair = this.entityLookup.findByValue(value);
        if (entityPair == null) {
            entityPair = this.entityLookup.createValue(value);
        }
        key = (Serializable)entityPair.getFirst();
        this.cache.put((Serializable)valueCacheKey, (Object)key);
        this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, key), (Object)(value == null ? VALUE_NULL : value));
        return entityPair;
    }

    public int updateValue(K key, V value) {
        Serializable valueKey;
        if (this.cache == null) {
            return this.entityLookup.updateValue(key, value);
        }
        this.removeByKey(key, false);
        int updateCount = this.entityLookup.updateValue(key, value);
        if (updateCount == 0) {
            return updateCount;
        }
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey != null) {
            CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
            this.cache.put((Serializable)valueCacheKey, key);
        }
        this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, (Serializable)key), (Object)(value == null ? VALUE_NULL : value));
        return updateCount;
    }

    public K getKey(VK valueKey) {
        CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, (Serializable)valueKey);
        Serializable key = (Serializable)this.cache.get((Serializable)valueCacheKey);
        if (key != null && key.equals(VALUE_NOT_FOUND)) {
            key = null;
        }
        return (K)key;
    }

    public V getValue(K key) {
        CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, (Serializable)key);
        Object value = this.cache.get((Serializable)keyCacheKey);
        if (value == null) {
            return null;
        }
        if (value.equals(VALUE_NOT_FOUND)) {
            return null;
        }
        if (value.equals(VALUE_NULL)) {
            return null;
        }
        return (V)value;
    }

    public void setValue(K key, V value) {
        Serializable valueKey;
        if (this.cache == null) {
            return;
        }
        this.removeByKey(key, false);
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey != null) {
            CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
            this.cache.put((Serializable)valueCacheKey, key);
        }
        this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, (Serializable)key), (Object)(value == null ? VALUE_NULL : value));
    }

    public int deleteByKey(K key) {
        if (this.cache == null) {
            return this.entityLookup.deleteByKey(key);
        }
        this.removeByKey(key);
        return this.entityLookup.deleteByKey(key);
    }

    public int deleteByValue(V value) {
        if (this.cache == null) {
            return this.entityLookup.deleteByValue(value);
        }
        this.removeByValue(value);
        return this.entityLookup.deleteByValue(value);
    }

    public void removeByKey(K key) {
        if (this.cache == null) {
            return;
        }
        this.removeByKey(key, true);
    }

    private void removeByKey(K key, boolean removeKey) {
        VK valueKey;
        CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, (Serializable)key);
        Object value = this.cache.get((Serializable)keyCacheKey);
        if (value != null && !value.equals(VALUE_NOT_FOUND) && (valueKey = this.entityLookup.getValueKey(value)) != null) {
            CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, (Serializable)valueKey);
            this.cache.remove((Serializable)valueCacheKey);
        }
        if (removeKey) {
            this.cache.remove((Serializable)keyCacheKey);
        }
    }

    public void removeByValue(V value) {
        Serializable valueKey;
        if (this.cache == null) {
            return;
        }
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey == null) {
            return;
        }
        CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
        Serializable key = (Serializable)this.cache.get((Serializable)valueCacheKey);
        if (key != null && !key.equals(VALUE_NOT_FOUND)) {
            CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, key);
            this.cache.remove((Serializable)keyCacheKey);
        }
        this.cache.remove((Serializable)valueCacheKey);
    }

    public void clear() {
        if (this.cache == null) {
            return;
        }
        this.cache.clear();
    }

    private static class CacheRegionValueKey
    implements Serializable {
        private static final long serialVersionUID = 5838308035326617927L;
        private final String cacheRegion;
        private final Serializable cacheValueKey;
        private final int hashCode;

        private CacheRegionValueKey(String cacheRegion, Serializable cacheValueKey) {
            this.cacheRegion = cacheRegion;
            this.cacheValueKey = cacheValueKey;
            this.hashCode = cacheRegion.hashCode() + cacheValueKey.hashCode();
        }

        public String toString() {
            return this.cacheRegion + "." + this.cacheValueKey.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheRegionValueKey)) {
                return false;
            }
            CacheRegionValueKey that = (CacheRegionValueKey)obj;
            return this.cacheRegion.equals(that.cacheRegion) && this.cacheValueKey.equals(that.cacheValueKey);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class CacheRegionKey
    implements Serializable {
        private static final long serialVersionUID = -213050301938804468L;
        private final String cacheRegion;
        private final Serializable cacheKey;
        private final int hashCode;

        private CacheRegionKey(String cacheRegion, Serializable cacheKey) {
            this.cacheRegion = cacheRegion;
            this.cacheKey = cacheKey;
            this.hashCode = cacheRegion.hashCode() + cacheKey.hashCode();
        }

        public String toString() {
            return this.cacheRegion + "." + this.cacheKey.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheRegionKey)) {
                return false;
            }
            CacheRegionKey that = (CacheRegionKey)obj;
            return this.cacheRegion.equals(that.cacheRegion) && this.cacheKey.equals(that.cacheKey);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class EntityLookupCallbackDAOAdaptor<K2 extends Serializable, V2, VK2 extends Serializable>
    implements EntityLookupCallbackDAO<K2, V2, VK2> {
        @Override
        public Pair<K2, V2> findByValue(V2 value) {
            return null;
        }

        @Override
        public VK2 getValueKey(V2 value) {
            return null;
        }

        @Override
        public int updateValue(K2 key, V2 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int deleteByKey(K2 key) {
            throw new UnsupportedOperationException("Entity deletion by key is not supported");
        }

        @Override
        public int deleteByValue(V2 value) {
            throw new UnsupportedOperationException("Entity deletion by value is not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntityLookupCallbackDAO<K1 extends Serializable, V1, VK1 extends Serializable> {
        public VK1 getValueKey(V1 var1);

        public Pair<K1, V1> findByKey(K1 var1);

        public Pair<K1, V1> findByValue(V1 var1);

        public Pair<K1, V1> createValue(V1 var1);

        public int updateValue(K1 var1, V1 var2);

        public int deleteByKey(K1 var1);

        public int deleteByValue(V1 var1);
    }
}

