/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.DataModelTestApplicationContextHelper;
import org.apache.poi.util.IOUtils;
import org.springframework.context.ApplicationContext;

public class MimetypeMapContentTest
extends TestCase {
    private static ApplicationContext ctx = DataModelTestApplicationContextHelper.getApplicationContext();
    private MimetypeService mimetypeService;

    public void setUp() throws Exception {
        this.mimetypeService = (MimetypeService)ctx.getBean("mimetypeService");
    }

    public void testGuessMimetypeForFile() throws Exception {
        MimetypeMapContentTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.doc", this.openQuickTestFile("quick.doc")));
        MimetypeMapContentTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("SOMETHING.DOC", this.openQuickTestFile("quick.doc")));
        MimetypeMapContentTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.pdf", this.openQuickTestFile("quick.doc")));
        MimetypeMapContentTest.assertEquals((String)"application/pdf", (String)this.mimetypeService.guessMimetype("something.doc", this.openQuickTestFile("quick.pdf")));
        MimetypeMapContentTest.assertEquals((String)"image/bmp", (String)this.mimetypeService.guessMimetype("image.bmp", this.openQuickTestFile("quick.bmp")));
        MimetypeMapContentTest.assertEquals((String)"application/dita+xml", (String)this.mimetypeService.guessMimetype("concept.dita", this.openQuickTestFile("quickConcept.dita")));
        MimetypeMapContentTest.assertEquals((String)"application/acp", (String)this.mimetypeService.guessMimetype("something.acp", this.openQuickTestFile("quick.acp")));
        File tmp = File.createTempFile("alfresco", ".tmp");
        ContentReader reader = this.openQuickTestFile("quick.doc");
        InputStream inp = reader.getContentInputStream();
        byte[] trunc = new byte[768];
        IOUtils.readFully((InputStream)inp, (byte[])trunc);
        inp.close();
        FileOutputStream out = new FileOutputStream(tmp);
        out.write(trunc);
        out.close();
        FileContentReader truncReader = new FileContentReader(tmp);
        MimetypeMapContentTest.assertEquals((String)"application/x-tika-msoffice", (String)this.mimetypeService.guessMimetype(null, (ContentReader)truncReader));
        MimetypeMapContentTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.doc", (ContentReader)truncReader));
    }

    private ContentReader openQuickTestFile(String filename) {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("quick/" + filename);
        if (url == null) {
            MimetypeMapContentTest.fail((String)("Quick test file \"" + filename + "\" wasn't found"));
        }
        File file = new File(url.getFile());
        return new FileContentReader(file);
    }
}

