/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.util.Date;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.caching.CacheMissException;
import org.alfresco.repo.content.caching.CachingContentStoreCreatedEvent;
import org.alfresco.repo.content.caching.ContentCache;
import org.alfresco.repo.content.caching.quota.QuotaManagerStrategy;
import org.alfresco.repo.content.caching.quota.UnlimitedQuotaStrategy;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class CachingContentStore
implements ContentStore,
ApplicationEventPublisherAware,
BeanNameAware {
    private static final Log log = LogFactory.getLog(CachingContentStore.class);
    private static final int numLocks = 256;
    private static final ReentrantReadWriteLock[] locks = new ReentrantReadWriteLock[256];
    private ContentStore backingStore;
    private ContentCache cache;
    private QuotaManagerStrategy quota = new UnlimitedQuotaStrategy();
    private boolean cacheOnInbound;
    private int maxCacheTries = 2;
    private ApplicationEventPublisher eventPublisher;
    private String beanName;

    public CachingContentStore() {
    }

    public CachingContentStore(ContentStore backingStore, ContentCache cache, boolean cacheOnInbound) {
        this.backingStore = backingStore;
        this.cache = cache;
        this.cacheOnInbound = cacheOnInbound;
    }

    public void init() {
        this.eventPublisher.publishEvent((ApplicationEvent)new CachingContentStoreCreatedEvent(this));
    }

    public boolean isContentUrlSupported(String contentUrl) {
        return this.backingStore.isContentUrlSupported(contentUrl);
    }

    public boolean isWriteSupported() {
        return this.backingStore.isWriteSupported();
    }

    public long getTotalSize() {
        return this.backingStore.getTotalSize();
    }

    public long getSpaceUsed() {
        return this.backingStore.getSpaceUsed();
    }

    public long getSpaceFree() {
        return this.backingStore.getSpaceFree();
    }

    public long getSpaceTotal() {
        return this.backingStore.getSpaceTotal();
    }

    public String getRootLocation() {
        return this.backingStore.getRootLocation();
    }

    public boolean exists(String contentUrl) {
        return this.backingStore.exists(contentUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContentReader getReader(String contentUrl) {
        ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock(contentUrl).readLock();
        readLock.lock();
        try {
            block4: {
                ContentReader contentReader;
                try {
                    if (!this.cache.contains(contentUrl)) break block4;
                    contentReader = this.cache.getReader(contentUrl);
                    Object var5_5 = null;
                }
                catch (CacheMissException cacheMissException) {
                    Object var5_7 = null;
                    readLock.unlock();
                    return this.cacheAndRead(contentUrl);
                }
                readLock.unlock();
                return contentReader;
            }
            Object var5_6 = null;
            readLock.unlock();
            return this.cacheAndRead(contentUrl);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ContentReader cacheAndRead(String url) {
        ContentReader contentReader;
        ReentrantReadWriteLock.WriteLock writeLock;
        block6: {
            ContentReader contentReader2;
            block5: {
                writeLock = this.readWriteLock(url).writeLock();
                writeLock.lock();
                try {
                    for (int i = 0; i < this.maxCacheTries; ++i) {
                        ContentReader backingStoreReader = this.backingStore.getReader(url);
                        long contentSize = backingStoreReader.getSize();
                        if (!this.quota.beforeWritingCacheFile(contentSize)) {
                            ContentReader contentReader3 = backingStoreReader;
                            Object var10_8 = null;
                            writeLock.unlock();
                            return contentReader3;
                        }
                        ContentReader reader = this.attemptCacheAndRead(url);
                        if (reader == null) continue;
                        this.quota.afterWritingCacheFile(contentSize);
                        contentReader2 = reader;
                        break block5;
                    }
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Attempted " + this.maxCacheTries + " times to cache content item and failed - " + "returning reader from backing store instead [" + "backingStore=" + this.backingStore + ", url=" + url + "]"));
                    }
                    contentReader = this.backingStore.getReader(url);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    writeLock.unlock();
                    throw throwable;
                }
            }
            Object var10_9 = null;
            writeLock.unlock();
            return contentReader2;
        }
        Object var10_10 = null;
        writeLock.unlock();
        return contentReader;
    }

    private ContentReader attemptCacheAndRead(String url) {
        ContentReader reader = null;
        try {
            if (!this.cache.contains(url)) {
                if (this.cache.put(url, this.backingStore.getReader(url))) {
                    reader = this.cache.getReader(url);
                }
            } else {
                reader = this.cache.getReader(url);
            }
        }
        catch (CacheMissException e) {
            this.cache.remove(url);
        }
        return reader;
    }

    public ContentWriter getWriter(ContentContext context) {
        if (this.cacheOnInbound) {
            final ContentWriter bsWriter = this.backingStore.getWriter(context);
            if (!this.quota.beforeWritingCacheFile(0L)) {
                return bsWriter;
            }
            final String url = bsWriter.getContentUrl();
            final ContentWriter cacheWriter = this.cache.getWriter(url);
            cacheWriter.addListener(new ContentStreamListener(){

                public void contentStreamClosed() throws ContentIOException {
                    bsWriter.setEncoding(cacheWriter.getEncoding());
                    bsWriter.setLocale(cacheWriter.getLocale());
                    bsWriter.setMimetype(cacheWriter.getMimetype());
                    bsWriter.putContent(cacheWriter.getReader());
                    if (!CachingContentStore.this.quota.afterWritingCacheFile(cacheWriter.getSize())) {
                        CachingContentStore.this.cache.deleteFile(url);
                        CachingContentStore.this.cache.remove(url);
                    }
                }
            });
            return cacheWriter;
        }
        return this.backingStore.getWriter(context);
    }

    public ContentWriter getWriter(ContentReader existingContentReader, String newContentUrl) {
        ContentContext ctx = new ContentContext(existingContentReader, newContentUrl);
        return this.getWriter(ctx);
    }

    public void getUrls(ContentStore.ContentUrlHandler handler) throws ContentIOException {
        this.backingStore.getUrls(handler);
    }

    public void getUrls(Date createdAfter, Date createdBefore, ContentStore.ContentUrlHandler handler) throws ContentIOException {
        this.backingStore.getUrls(createdAfter, createdBefore, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String contentUrl) {
        ReentrantReadWriteLock.ReadLock readLock;
        ReentrantReadWriteLock readWriteLock;
        block6: {
            readWriteLock = this.readWriteLock(contentUrl);
            readLock = readWriteLock.readLock();
            readLock.lock();
            try {
                if (this.cache.contains(contentUrl)) break block6;
                boolean bl = this.backingStore.delete(contentUrl);
                Object var6_6 = null;
                readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                readLock.unlock();
                throw throwable;
            }
        }
        Object var6_7 = null;
        readLock.unlock();
        ReentrantReadWriteLock.WriteLock writeLock = readWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.cache.contains(contentUrl)) {
                this.cache.remove(contentUrl);
            }
            boolean bl = this.backingStore.delete(contentUrl);
            Object var8_11 = null;
            writeLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            writeLock.unlock();
            throw throwable;
        }
    }

    public ReentrantReadWriteLock readWriteLock(String url) {
        return locks[this.lockIndex(url)];
    }

    private int lockIndex(String url) {
        return url.hashCode() & 0xFF;
    }

    @Required
    public void setBackingStore(ContentStore backingStore) {
        this.backingStore = backingStore;
    }

    public String getBackingStoreType() {
        return this.backingStore.getClass().getName();
    }

    public String getBackingStoreDescription() {
        return this.backingStore.toString();
    }

    @Required
    public void setCache(ContentCache cache) {
        this.cache = cache;
    }

    public ContentCache getCache() {
        return this.cache;
    }

    public void setCacheOnInbound(boolean cacheOnInbound) {
        this.cacheOnInbound = cacheOnInbound;
    }

    public boolean isCacheOnInbound() {
        return this.cacheOnInbound;
    }

    public int getMaxCacheTries() {
        return this.maxCacheTries;
    }

    public void setMaxCacheTries(int maxCacheTries) {
        this.maxCacheTries = maxCacheTries;
    }

    @Required
    public void setQuota(QuotaManagerStrategy quota) {
        this.quota = quota;
    }

    public QuotaManagerStrategy getQuota() {
        return this.quota;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            CachingContentStore.locks[i] = new ReentrantReadWriteLock();
        }
    }
}

