/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.io.File;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.alfresco.repo.cache.EhCacheAdapter;
import org.alfresco.repo.content.AbstractWritableContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.repo.content.caching.ContentCacheImpl;
import org.alfresco.repo.content.caching.Key;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=JUnit38ClassRunner.class)
public class CachingContentStoreSpringTest
extends AbstractWritableContentStoreTest {
    private static final String EHCACHE_NAME = "cache.test.cachingContentStoreCache";
    private static final int T24_HOURS = 86400;
    private CachingContentStore store;
    private FileContentStore backingStore;
    private ContentCacheImpl cache;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        File tempDir = TempFileProvider.getTempDir();
        this.backingStore = new FileContentStore(ctx, tempDir.getAbsolutePath() + File.separatorChar + this.getName());
        this.cache = new ContentCacheImpl();
        this.cache.setCacheRoot(TempFileProvider.getLongLifeTempDir((String)"cached_content_test"));
        this.cache.setMemoryStore(this.createMemoryStore());
        this.store = new CachingContentStore(this.backingStore, this.cache, false);
    }

    private EhCacheAdapter<Key, String> createMemoryStore() {
        CacheManager manager = CacheManager.getInstance();
        if (!manager.cacheExists(EHCACHE_NAME)) {
            Cache memoryOnlyCache = new Cache(EHCACHE_NAME, 50, false, false, 86400L, 86400L);
            manager.addCache(memoryOnlyCache);
        }
        EhCacheAdapter<Key, String> memoryStore = new EhCacheAdapter<Key, String>();
        memoryStore.setCache(manager.getCache(EHCACHE_NAME));
        return memoryStore;
    }

    public void testStoreWillReadFromCacheWhenAvailable() {
        String content = "Content for " + this.getName() + " test.";
        ContentWriter writer = this.backingStore.getWriter(ContentContext.NULL_CONTEXT);
        writer.putContent(content);
        String contentUrl = writer.getContentUrl();
        String retrievedContent = this.store.getReader(contentUrl).getContentString();
        CachingContentStoreSpringTest.assertEquals((String)content, (String)retrievedContent);
        this.backingStore.delete(contentUrl);
        CachingContentStoreSpringTest.assertFalse((String)"Original content should have been deleted", (boolean)this.backingStore.exists(contentUrl));
        String contentAfterDelete = this.store.getReader(contentUrl).getContentString();
        CachingContentStoreSpringTest.assertEquals((String)content, (String)contentAfterDelete);
    }

    public void testCacheOnInbound() {
        this.store = new CachingContentStore(this.backingStore, this.cache, true);
        String content = "Content for " + this.getName() + " test.";
        String contentUrl = FileContentStore.createNewFileStoreUrl();
        CachingContentStoreSpringTest.assertFalse((String)"Content shouldn't be cached yet", (boolean)this.cache.contains(contentUrl));
        ContentWriter writer = this.store.getWriter(new ContentContext(null, contentUrl));
        writer.putContent(content);
        CachingContentStoreSpringTest.assertTrue((String)"Cache should contain content after write", (boolean)this.cache.contains(contentUrl));
        String retrievedContent = this.cache.getReader(contentUrl).getContentString();
        CachingContentStoreSpringTest.assertEquals((String)content, (String)retrievedContent);
        String fromBackingStore = this.backingStore.getReader(contentUrl).getContentString();
        CachingContentStoreSpringTest.assertEquals((String)"Content should be in backing store", (String)content, (String)fromBackingStore);
        this.backingStore.delete(contentUrl);
        CachingContentStoreSpringTest.assertFalse((String)"Original content should have been deleted", (boolean)this.backingStore.exists(contentUrl));
        String contentAfterDelete = this.store.getReader(contentUrl).getContentString();
        CachingContentStoreSpringTest.assertEquals((String)content, (String)contentAfterDelete);
    }

    public void testStoreWillRecoverFromDeletedCacheFile() {
        String content = "Content for " + this.getName() + " test.";
        ContentWriter writer = this.backingStore.getWriter(ContentContext.NULL_CONTEXT);
        writer.putContent(content);
        String contentUrl = writer.getContentUrl();
        String retrievedContent = this.store.getReader(contentUrl).getContentString();
        CachingContentStoreSpringTest.assertEquals((String)content, (String)retrievedContent);
        File cacheFile = new File(this.cache.getCacheFilePath(contentUrl));
        cacheFile.delete();
        CachingContentStoreSpringTest.assertTrue((String)"Cached content should have been deleted", (!cacheFile.exists() ? 1 : 0) != 0);
        String contentAfterDelete = this.store.getReader(contentUrl).getContentString();
        CachingContentStoreSpringTest.assertEquals((String)content, (String)contentAfterDelete);
    }

    @Override
    protected ContentStore getStore() {
        return this.store;
    }
}

