/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.content.caching.CacheMissException;
import org.alfresco.repo.content.caching.ContentCacheImpl;
import org.alfresco.repo.content.caching.FileHandler;
import org.alfresco.repo.content.caching.Key;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class ContentCacheImplTest {
    private ContentCacheImpl contentCache;
    @Mock
    private SimpleCache<Key, String> lookupTable;

    @Before
    public void setUp() throws Exception {
        this.contentCache = new ContentCacheImpl();
        this.contentCache.setMemoryStore(this.lookupTable);
        this.contentCache.setCacheRoot(TempFileProvider.getTempDir());
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotSetNullCacheRoot() {
        this.contentCache.setCacheRoot(null);
    }

    @Test
    public void willCreateNonExistentCacheRoot() {
        File cacheRoot = new File(TempFileProvider.getTempDir(), GUID.generate());
        cacheRoot.deleteOnExit();
        Assert.assertFalse((String)"Pre-condition of test is that cacheRoot does not exist", (boolean)cacheRoot.exists());
        this.contentCache.setCacheRoot(cacheRoot);
        Assert.assertTrue((String)"cacheRoot should have been created", (boolean)cacheRoot.exists());
    }

    @Test
    public void canGetReaderForItemInCacheHavingLiveFile() {
        String url = "store://content/url.bin";
        Mockito.when((Object)this.lookupTable.contains((Serializable)Key.forUrl("store://content/url.bin"))).thenReturn((Object)true);
        String path = this.tempfile().getAbsolutePath();
        Mockito.when((Object)this.lookupTable.get((Serializable)Key.forUrl("store://content/url.bin"))).thenReturn((Object)path);
        FileContentReader reader = (FileContentReader)this.contentCache.getReader("store://content/url.bin");
        Assert.assertEquals((String)"Reader should have correct URL", (Object)"store://content/url.bin", (Object)reader.getContentUrl());
        Assert.assertEquals((String)"Reader should be for correct cached content file", (Object)path, (Object)reader.getFile().getAbsolutePath());
        ((SimpleCache)Mockito.verify(this.lookupTable)).get((Serializable)Key.forCacheFile(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=CacheMissException.class)
    public void getReaderForItemInCacheButMissingContentFile() {
        String url = "store://content/url.bin";
        Mockito.when((Object)this.lookupTable.contains((Serializable)Key.forUrl("store://content/url.bin"))).thenReturn((Object)true);
        String path = "/no/content/file/at/this/path.bin";
        Mockito.when((Object)this.lookupTable.get((Serializable)Key.forUrl("store://content/url.bin"))).thenReturn((Object)"/no/content/file/at/this/path.bin");
        try {
            this.contentCache.getReader("store://content/url.bin");
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((SimpleCache)Mockito.verify(this.lookupTable)).get((Serializable)Key.forCacheFile("/no/content/file/at/this/path.bin"));
            throw throwable;
        }
        ((SimpleCache)Mockito.verify(this.lookupTable)).get((Serializable)Key.forCacheFile("/no/content/file/at/this/path.bin"));
    }

    @Test(expected=CacheMissException.class)
    public void getReaderWhenItemNotInCache() {
        String url = "store://content/url.bin";
        Mockito.when((Object)this.lookupTable.contains((Serializable)Key.forUrl("store://content/url.bin"))).thenReturn((Object)false);
        this.contentCache.getReader("store://content/url.bin");
    }

    @Test
    public void contains() {
        String url = "store://content/url.bin";
        Mockito.when((Object)this.lookupTable.contains((Serializable)Key.forUrl("store://content/url.bin"))).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.contentCache.contains(Key.forUrl("store://content/url.bin")));
        Assert.assertTrue((boolean)this.contentCache.contains("store://content/url.bin"));
        Mockito.when((Object)this.lookupTable.contains((Serializable)Key.forUrl("store://content/url.bin"))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.contentCache.contains(Key.forUrl("store://content/url.bin")));
        Assert.assertFalse((boolean)this.contentCache.contains("store://content/url.bin"));
    }

    @Test
    public void putIntoLookup() {
        Key key = Key.forUrl("store://some/url");
        String value = "/some/path";
        this.contentCache.putIntoLookup(key, "/some/path");
        ((SimpleCache)Mockito.verify(this.lookupTable)).put((Serializable)key, (Object)"/some/path");
    }

    @Test
    public void getCacheFilePath() {
        String url = "store://some/url.bin";
        String expectedPath = "/some/cache/file/path";
        Mockito.when((Object)this.lookupTable.get((Serializable)Key.forUrl("store://some/url.bin"))).thenReturn((Object)"/some/cache/file/path");
        String path = this.contentCache.getCacheFilePath("store://some/url.bin");
        Assert.assertEquals((String)"Paths must match", (Object)"/some/cache/file/path", (Object)path);
    }

    @Test
    public void getContentUrl() {
        File cacheFile = new File("/some/path");
        String expectedUrl = "store://some/url";
        Mockito.when((Object)this.lookupTable.get((Serializable)Key.forCacheFile(cacheFile))).thenReturn((Object)"store://some/url");
        String url = this.contentCache.getContentUrl(cacheFile);
        Assert.assertEquals((String)"Content URLs should match", (Object)"store://some/url", (Object)url);
    }

    @Test
    public void putForZeroLengthFile() {
        ContentReader contentReader = (ContentReader)Mockito.mock(ContentReader.class);
        Mockito.when((Object)contentReader.getSize()).thenReturn((Object)0L);
        boolean putResult = this.contentCache.put("", contentReader);
        Assert.assertFalse((String)"Zero length files should not be cached", (boolean)putResult);
    }

    @Test
    public void putForNonEmptyFile() {
        ContentReader contentReader = (ContentReader)Mockito.mock(ContentReader.class);
        Mockito.when((Object)contentReader.getSize()).thenReturn((Object)999000L);
        ArgumentCaptor cacheFileArg = ArgumentCaptor.forClass(File.class);
        ((ContentReader)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                File f = (File)args[0];
                try {
                    f.createNewFile();
                }
                catch (IOException error) {
                    error.printStackTrace();
                }
                return null;
            }
        }).when((Object)contentReader)).getContent((File)cacheFileArg.capture());
        String url = "store://some/url.bin";
        boolean putResult = this.contentCache.put("store://some/url.bin", contentReader);
        Assert.assertTrue((String)"Non-empty files should be cached", (boolean)putResult);
        String cacheFilePath = ((File)cacheFileArg.getValue()).getAbsolutePath().replace(".tmp", ".bin");
        ((SimpleCache)Mockito.verify(this.lookupTable)).put((Serializable)Key.forUrl("store://some/url.bin"), (Object)cacheFilePath);
        ((SimpleCache)Mockito.verify(this.lookupTable)).put((Serializable)Key.forCacheFile(cacheFilePath), (Object)"store://some/url.bin");
    }

    @Test
    public void remove() {
        String url = "store://some/url.bin";
        String path = "/some/path";
        Mockito.when((Object)this.lookupTable.get((Serializable)Key.forUrl("store://some/url.bin"))).thenReturn((Object)"/some/path");
        this.contentCache.remove("store://some/url.bin");
        ((SimpleCache)Mockito.verify(this.lookupTable)).remove((Serializable)Key.forUrl("store://some/url.bin"));
        ((SimpleCache)Mockito.verify(this.lookupTable)).remove((Serializable)Key.forCacheFile("/some/path"));
    }

    @Test
    public void deleteFile() {
        File cacheFile = this.tempfile();
        Assert.assertTrue((String)"Temp file should have been written", (boolean)cacheFile.exists());
        Mockito.when((Object)this.contentCache.getCacheFilePath("url")).thenReturn((Object)cacheFile.getAbsolutePath());
        this.contentCache.deleteFile("url");
        Assert.assertFalse((String)"File should have been deleted", (boolean)cacheFile.exists());
    }

    @Test
    public void getWriter() {
        String url = "store://some/url.bin";
        FileContentWriter writer = (FileContentWriter)this.contentCache.getWriter("store://some/url.bin");
        writer.putContent("Some test content for " + this.getClass().getName());
        Assert.assertEquals((Object)"store://some/url.bin", (Object)writer.getContentUrl());
        ((SimpleCache)Mockito.verify(this.lookupTable)).put((Serializable)Key.forUrl("store://some/url.bin"), (Object)writer.getFile().getAbsolutePath());
        ((SimpleCache)Mockito.verify(this.lookupTable)).put((Serializable)Key.forCacheFile(writer.getFile().getAbsolutePath()), (Object)"store://some/url.bin");
    }

    @Test
    public void compareNumericFileNames() {
        ContentCacheImpl.NumericFileNameComparator comparator = new ContentCacheImpl.NumericFileNameComparator();
        Assert.assertEquals((long)-1L, (long)comparator.compare(new File("1"), new File("2")));
        Assert.assertEquals((long)0L, (long)comparator.compare(new File("2"), new File("2")));
        Assert.assertEquals((long)1L, (long)comparator.compare(new File("2"), new File("1")));
        Assert.assertEquals((long)-1L, (long)comparator.compare(new File("3"), new File("20")));
        Assert.assertEquals((long)1L, (long)comparator.compare(new File("20"), new File("3")));
        Assert.assertEquals((long)-1L, (long)comparator.compare(new File("3"), new File("non-numeric")));
        Assert.assertEquals((long)1L, (long)comparator.compare(new File("non-numeric"), new File("3")));
    }

    @Test
    public void canVisitOldestDirsFirst() {
        File cacheRoot = new File(TempFileProvider.getTempDir(), GUID.generate());
        cacheRoot.deleteOnExit();
        this.contentCache.setCacheRoot(cacheRoot);
        File f1 = this.tempfile(this.createDirs("2000/3/30/17/45/31"), "files-are-unsorted.bin");
        File f2 = this.tempfile(this.createDirs("2000/3/4/17/45/31"), "another-file.bin");
        File f3 = this.tempfile(this.createDirs("2010/12/24/23/59/58"), "a-second-before.bin");
        File f4 = this.tempfile(this.createDirs("2010/12/24/23/59/59"), "last-one.bin");
        File f5 = this.tempfile(this.createDirs("2000/1/7/2/7/12"), "first-one.bin");
        FileHandler handler = (FileHandler)Mockito.mock(FileHandler.class);
        this.contentCache.processFiles(handler);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
        ((FileHandler)inOrder.verify((Object)handler)).handle(f5);
        ((FileHandler)inOrder.verify((Object)handler)).handle(f2);
        ((FileHandler)inOrder.verify((Object)handler)).handle(f1);
        ((FileHandler)inOrder.verify((Object)handler)).handle(f3);
        ((FileHandler)inOrder.verify((Object)handler)).handle(f4);
    }

    private File tempfile() {
        return this.tempfile("cached-content", ".bin");
    }

    private File tempfile(String name, String suffix) {
        File file = TempFileProvider.createTempFile((String)name, (String)suffix);
        file.deleteOnExit();
        return file;
    }

    private File tempfile(File dir, String name) {
        File f = new File(dir, name);
        try {
            f.createNewFile();
        }
        catch (IOException error) {
            throw new RuntimeException(error);
        }
        f.deleteOnExit();
        return f;
    }

    private File createDirs(String path) {
        File f = new File(this.contentCache.getCacheRoot(), path);
        f.mkdirs();
        return f;
    }
}

