/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class FullTest {
    private static ApplicationContext ctx;
    private CachingContentStore store;

    @BeforeClass
    public static void beforeClass() {
        String conf = "classpath:cachingstore/test-context.xml";
        ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{conf});
    }

    @Before
    public void setUp() {
        this.store = (CachingContentStore)ctx.getBean("cachingContentStore");
        this.store.setCacheOnInbound(true);
    }

    @Test
    public void canUseCachingContentStore() {
        ContentWriter writer = this.store.getWriter(ContentContext.NULL_CONTEXT);
        String content = this.makeContent();
        writer.putContent(content);
        ContentReader reader = this.store.getReader(writer.getContentUrl());
        Assert.assertEquals((String)"Reader and writer should have same URLs", (Object)writer.getContentUrl(), (Object)reader.getContentUrl());
        Assert.assertEquals((String)"Reader should get correct content", (Object)content, (Object)reader.getContentString());
    }

    @Test
    public void writeToCacheWithContentContext() {
        String proposedUrl = FileContentStore.createNewFileStoreUrl();
        ContentWriter writer = this.store.getWriter(new ContentContext(null, proposedUrl));
        String content = this.makeContent();
        writer.putContent(content);
        Assert.assertEquals((String)"Writer should have correct URL", (Object)proposedUrl, (Object)writer.getContentUrl());
        ContentReader reader = this.store.getReader(writer.getContentUrl());
        Assert.assertEquals((String)"Reader and writer should have same URLs", (Object)writer.getContentUrl(), (Object)reader.getContentUrl());
        Assert.assertEquals((String)"Reader should get correct content", (Object)content, (Object)reader.getContentString());
    }

    @Test
    public void writeToCacheWithExistingReader() {
        ContentWriter oldWriter = this.store.getWriter(ContentContext.NULL_CONTEXT);
        oldWriter.putContent("Old content for " + this.getClass().getSimpleName());
        ContentReader existingReader = oldWriter.getReader();
        String proposedUrl = FileContentStore.createNewFileStoreUrl();
        ContentWriter writer = this.store.getWriter(new ContentContext(existingReader, proposedUrl));
        String content = this.makeContent();
        writer.putContent(content);
        Assert.assertEquals((String)"Writer should have correct URL", (Object)proposedUrl, (Object)writer.getContentUrl());
        Assert.assertFalse((String)"Old and new writers must have different URLs", (boolean)oldWriter.getContentUrl().equals(writer.getContentUrl()));
        ContentReader reader = this.store.getReader(writer.getContentUrl());
        Assert.assertEquals((String)"Reader and writer should have same URLs", (Object)writer.getContentUrl(), (Object)reader.getContentUrl());
        Assert.assertEquals((String)"Reader should get correct content", (Object)content, (Object)reader.getContentString());
    }

    private String makeContent() {
        return "Example content for " + this.getClass().getSimpleName();
    }
}

