/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching.cleanup;

import java.io.File;
import java.util.Date;
import org.alfresco.repo.content.caching.CacheFileProps;
import org.alfresco.repo.content.caching.ContentCacheImpl;
import org.alfresco.repo.content.caching.FileHandler;
import org.alfresco.repo.content.caching.cleanup.CachedContentCleanerCreatedEvent;
import org.alfresco.repo.content.caching.quota.UsageTracker;
import org.alfresco.util.Deleter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class CachedContentCleaner
extends Thread
implements FileHandler,
ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog(CachedContentCleaner.class);
    private ContentCacheImpl cache;
    private long minFileAgeMillis = 0L;
    private Integer maxDeleteWatchCount = 1;
    private boolean running;
    private UsageTracker usageTracker;
    private long newDiskUsage;
    private long numFilesSeen;
    private long numFilesDeleted;
    private long sizeFilesDeleted;
    private long numFilesMarked;
    private Date timeStarted;
    private Date timeFinished;
    private ApplicationEventPublisher eventPublisher;
    private long targetReductionBytes;
    private String reasonMessage;

    public CachedContentCleaner() {
        this.setName(this.getClass().getSimpleName());
        this.setDaemon(true);
    }

    public void init() {
        this.eventPublisher.publishEvent((ApplicationEvent)new CachedContentCleanerCreatedEvent(this));
        this.start();
    }

    public void run() {
        while (true) {
            this.doClean();
        }
    }

    public synchronized void execute() {
        this.execute("none specified");
    }

    public synchronized void executeAggressive(String reason, long targetReductionBytes) {
        this.targetReductionBytes = targetReductionBytes;
        this.execute(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClean() {
        CachedContentCleaner cachedContentCleaner = this;
        synchronized (cachedContentCleaner) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.running = true;
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting cleaner, reason: " + this.reasonMessage));
        }
        this.resetStats();
        this.timeStarted = new Date();
        this.cache.processFiles(this);
        this.timeFinished = new Date();
        if (this.usageTracker != null) {
            this.usageTracker.setCurrentUsageBytes(this.newDiskUsage);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished, duration: " + this.getDurationSeconds() + "s, seen: " + this.numFilesSeen + ", marked: " + this.numFilesMarked + ", deleted: " + this.numFilesDeleted + " (" + String.format("%.2f", this.getSizeFilesDeletedMB()) + "MB, " + this.sizeFilesDeleted + " bytes)" + ", target: " + this.targetReductionBytes + " bytes"));
        }
        this.targetReductionBytes = 0L;
        this.running = false;
        cachedContentCleaner = this;
        synchronized (cachedContentCleaner) {
            this.notifyAll();
        }
    }

    public synchronized void execute(String reasonMessage) {
        this.reasonMessage = reasonMessage;
        this.notifyAll();
    }

    private void resetStats() {
        this.newDiskUsage = 0L;
        this.numFilesSeen = 0L;
        this.numFilesDeleted = 0L;
        this.sizeFilesDeleted = 0L;
        this.numFilesMarked = 0L;
    }

    public void handle(File cachedContentFile) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handle file: " + cachedContentFile + " (target reduction: " + this.targetReductionBytes + " bytes)"));
        }
        ++this.numFilesSeen;
        CacheFileProps props = null;
        boolean deleted = false;
        if (this.targetReductionBytes > 0L && this.sizeFilesDeleted < this.targetReductionBytes) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Target reduction " + this.targetReductionBytes + " bytes not yet reached. Deleted so far: " + this.sizeFilesDeleted));
            }
            deleted = this.deleteFilesNow(cachedContentFile);
        } else if (this.oldEnoughForCleanup(cachedContentFile)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("File is older than " + this.minFileAgeMillis + "ms - considering for cleanup: " + cachedContentFile));
            }
            props = new CacheFileProps(cachedContentFile);
            String url = this.cache.getContentUrl(cachedContentFile);
            if (url == null) {
                props.load();
                url = props.getContentUrl();
            }
            if (url == null || !this.cache.contains(url)) {
                deleted = this.markOrDelete(cachedContentFile, props);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("File too young for cleanup - ignoring " + cachedContentFile));
        }
        if (!deleted) {
            if (props == null) {
                props = new CacheFileProps(cachedContentFile);
            }
            long size = cachedContentFile.length() + props.fileSize();
            this.newDiskUsage += size;
        }
    }

    private boolean oldEnoughForCleanup(File file) {
        if (this.minFileAgeMillis == 0L) {
            return true;
        }
        long now = System.currentTimeMillis();
        return file.lastModified() < now - this.minFileAgeMillis;
    }

    private boolean markOrDelete(File file, CacheFileProps props) {
        Integer deleteWatchCount = props.getDeleteWatchCount();
        if (deleteWatchCount < 0) {
            deleteWatchCount = 0;
        }
        boolean deleted = false;
        if (deleteWatchCount < this.maxDeleteWatchCount) {
            Integer n = deleteWatchCount;
            Integer n2 = deleteWatchCount = Integer.valueOf(deleteWatchCount + 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Marking file for deletion, deleteWatchCount=" + deleteWatchCount + ", file: " + file));
            }
            props.setDeleteWatchCount(deleteWatchCount);
            props.store();
            ++this.numFilesMarked;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting cache file " + file));
            }
            deleted = this.deleteFilesNow(file);
        }
        return deleted;
    }

    private boolean deleteFilesNow(File cacheFile) {
        CacheFileProps props = new CacheFileProps(cacheFile);
        props.delete();
        long fileSize = cacheFile.length();
        boolean deleted = cacheFile.delete();
        if (deleted) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Deleted cache file: " + cacheFile));
            }
            ++this.numFilesDeleted;
            this.sizeFilesDeleted += fileSize;
            Deleter.deleteEmptyParents((File)cacheFile, (File)this.cache.getCacheRoot());
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Failed to delete cache file: " + cacheFile));
        }
        return deleted;
    }

    @Required
    public void setCache(ContentCacheImpl cache) {
        this.cache = cache;
    }

    public void setMinFileAgeMillis(long minFileAgeMillis) {
        this.minFileAgeMillis = minFileAgeMillis;
    }

    public void setMaxDeleteWatchCount(Integer maxDeleteWatchCount) {
        if (maxDeleteWatchCount < 0) {
            throw new IllegalArgumentException("maxDeleteWatchCount cannot be negative [value=" + maxDeleteWatchCount + "]");
        }
        this.maxDeleteWatchCount = maxDeleteWatchCount;
    }

    public void setUsageTracker(UsageTracker usageTracker) {
        this.usageTracker = usageTracker;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getNumFilesSeen() {
        return this.numFilesSeen;
    }

    public long getNumFilesDeleted() {
        return this.numFilesDeleted;
    }

    public long getSizeFilesDeleted() {
        return this.sizeFilesDeleted;
    }

    public double getSizeFilesDeletedMB() {
        return (double)this.getSizeFilesDeleted() / 1048576.0;
    }

    public long getNumFilesMarked() {
        return this.numFilesMarked;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public long getDurationSeconds() {
        return this.getDurationMillis() / 1000L;
    }

    public long getDurationMillis() {
        return this.timeFinished.getTime() - this.timeStarted.getTime();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public File getCacheRoot() {
        return this.cache.getCacheRoot();
    }
}

