/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching.quota;

import org.alfresco.repo.content.caching.cleanup.CachedContentCleaner;
import org.alfresco.repo.content.caching.quota.StandardQuotaStrategy;
import org.apache.commons.lang.reflect.FieldUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StandardQuotaStrategyMockTest {
    private StandardQuotaStrategy quota;
    @Mock
    private CachedContentCleaner cleaner;

    @Before
    public void setUp() throws Exception {
        this.quota = new StandardQuotaStrategy();
        this.quota.setMaxUsageBytes(1000L);
        this.quota.setMaxFileSizeMB(100);
        this.quota.setCleaner(this.cleaner);
    }

    @Test
    public void testCanSetMaxUsageInMB() throws IllegalAccessException {
        this.quota.setMaxUsageMB(0L);
        Assert.assertEquals((long)0L, (long)((Long)FieldUtils.readDeclaredField((Object)this.quota, (String)"maxUsageBytes", (boolean)true)));
        this.quota.setMaxUsageMB(500L);
        Assert.assertEquals((long)524288000L, (long)((Long)FieldUtils.readDeclaredField((Object)this.quota, (String)"maxUsageBytes", (boolean)true)));
        this.quota.setMaxUsageMB(1024L);
        Assert.assertEquals((long)0x40000000L, (long)((Long)FieldUtils.readDeclaredField((Object)this.quota, (String)"maxUsageBytes", (boolean)true)));
    }

    @Test
    public void testPanicThresholdForBeforeWritingCacheFile() {
        this.quota.setCurrentUsageBytes(0L);
        Assert.assertTrue((String)"Should allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(899L));
        Assert.assertFalse((String)"Should not allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(900L));
        this.quota.setCurrentUsageBytes(890L);
        Assert.assertTrue((String)"Should allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(9L));
        Assert.assertFalse((String)"Should not allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(10L));
        this.quota.setCurrentUsageBytes(600L);
        Assert.assertTrue((String)"Should allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(299L));
        Assert.assertFalse((String)"Should not allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(300L));
        this.quota.setCurrentUsageBytes(899L);
        Assert.assertTrue((String)"Should allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(0L));
        Assert.assertFalse((String)"Should not allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(1L));
        this.quota.setCurrentUsageBytes(2345L);
        Assert.assertFalse((String)"Should not allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(0L));
        Assert.assertFalse((String)"Should not allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(1L));
        Assert.assertFalse((String)"Should not allow writing of cache file", (boolean)this.quota.beforeWritingCacheFile(12300L));
    }

    @Test
    public void afterWritingCacheFileDiskUsageUpdatedCorrectly() {
        this.quota.setCurrentUsageBytes(410L);
        this.quota.afterWritingCacheFile(40L);
        Assert.assertEquals((String)"Incorrect usage estimate", (long)450L, (long)this.quota.getCurrentUsageBytes());
        this.quota.afterWritingCacheFile(150L);
        Assert.assertEquals((String)"Incorrect usage estimate", (long)600L, (long)this.quota.getCurrentUsageBytes());
    }

    @Ignore
    @Test
    public void testThresholdsAfterWritingCacheFile() {
        this.quota.setCurrentUsageBytes(0L);
        this.quota.afterWritingCacheFile(700L);
        ((CachedContentCleaner)Mockito.verify((Object)this.cleaner, (VerificationMode)Mockito.never())).execute("quota (clean threshold)");
        this.quota.setCurrentUsageBytes(700L);
        this.quota.afterWritingCacheFile(100L);
        ((CachedContentCleaner)Mockito.verify((Object)this.cleaner)).execute("quota (clean threshold)");
        this.quota.setCurrentUsageBytes(999L);
        this.quota.afterWritingCacheFile(1L);
        ((CachedContentCleaner)Mockito.verify((Object)this.cleaner)).executeAggressive("quota (limit reached)", 700L);
    }

    @Ignore
    @Test
    public void testThresholdsBeforeWritingCacheFile() {
        this.quota.setCurrentUsageBytes(800L);
        this.quota.beforeWritingCacheFile(0L);
        ((CachedContentCleaner)Mockito.verify((Object)this.cleaner, (VerificationMode)Mockito.never())).execute("quota (clean threshold)");
        this.quota.setCurrentUsageBytes(900L);
        this.quota.beforeWritingCacheFile(0L);
        ((CachedContentCleaner)Mockito.verify((Object)this.cleaner)).execute("quota (panic threshold)");
    }

    @Test
    public void canGetMaxFileSizeBytes() {
        this.quota.setMaxFileSizeMB(1024);
        Assert.assertEquals((String)"1GB incorrect", (long)0x40000000L, (long)this.quota.getMaxFileSizeBytes());
        this.quota.setMaxFileSizeMB(0);
        Assert.assertEquals((String)"0MB incorrect", (long)0L, (long)this.quota.getMaxFileSizeBytes());
    }

    @Test
    public void attemptToWriteFileExceedingMaxFileSizeIsVetoed() {
        this.quota.setMaxUsageMB(4096L);
        this.quota.setMaxFileSizeMB(0);
        Assert.assertTrue((String)"File should be written", (boolean)this.quota.beforeWritingCacheFile(1L));
        Assert.assertTrue((String)"File should be written", (boolean)this.quota.beforeWritingCacheFile(0x1400000L));
        this.quota.setMaxFileSizeMB(1);
        Assert.assertTrue((String)"File should be written", (boolean)this.quota.beforeWritingCacheFile(0x100000L));
        Assert.assertFalse((String)"File should be vetoed - too large", (boolean)this.quota.beforeWritingCacheFile(0x100001L));
        this.quota.setMaxFileSizeMB(20);
        Assert.assertTrue((String)"File should be written", (boolean)this.quota.beforeWritingCacheFile(0x1400000L));
        Assert.assertFalse((String)"File should be vetoed - too large", (boolean)this.quota.beforeWritingCacheFile(0x1400001L));
        Assert.assertTrue((String)"File should be written", (boolean)this.quota.beforeWritingCacheFile(0L));
    }

    @Test
    public void afterFileWrittenExceedingMaxFileSizeFileIsDeleted() {
        this.quota.setMaxFileSizeMB(0);
        Assert.assertTrue((String)"File should be kept", (boolean)this.quota.afterWritingCacheFile(1L));
        Assert.assertTrue((String)"File should be kept", (boolean)this.quota.afterWritingCacheFile(0x1400000L));
        Assert.assertEquals((String)"Incorrect usage estimate", (long)0x1400001L, (long)this.quota.getCurrentUsageBytes());
        this.quota.setMaxFileSizeMB(20);
        this.quota.setCurrentUsageBytes(0L);
        Assert.assertTrue((String)"File should be kept", (boolean)this.quota.afterWritingCacheFile(0x1400000L));
        Assert.assertFalse((String)"File should be removed", (boolean)this.quota.afterWritingCacheFile(0x1400001L));
        Assert.assertEquals((String)"Incorrect usage estimate", (long)0x1400000L, (long)this.quota.getCurrentUsageBytes());
    }

    @Test
    public void testCurrentUsageMB() {
        this.quota.setCurrentUsageBytes(524288L);
        Assert.assertEquals((double)0.5, (double)this.quota.getCurrentUsageMB(), (double)0.0);
        this.quota.setCurrentUsageBytes(0x100000L);
        Assert.assertEquals((double)1.0, (double)this.quota.getCurrentUsageMB(), (double)0.0);
        this.quota.setCurrentUsageBytes(53262546L);
        Assert.assertEquals((double)50.795f, (double)this.quota.getCurrentUsageMB(), (double)0.001);
    }
}

