/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;

public class MappingMetadataExtracterTest
extends TestCase {
    private DummyMappingMetadataExtracter extracter;
    private ContentReader reader;
    private Map<QName, Serializable> destination;

    protected void setUp() throws Exception {
        this.extracter = new DummyMappingMetadataExtracter();
        this.extracter.register();
        this.reader = new FileContentReader(AbstractContentTransformerTest.loadQuickTestFile("txt"));
        this.reader.setMimetype("text/plain");
        this.destination = new HashMap<QName, Serializable>(7);
        this.destination.put(DummyMappingMetadataExtracter.QNAME_A1, JunkValue.INSTANCE);
        this.destination.put(DummyMappingMetadataExtracter.QNAME_A2, (Serializable)((Object)""));
        this.destination.put(DummyMappingMetadataExtracter.QNAME_B, null);
    }

    public void testSetUp() {
        MappingMetadataExtracterTest.assertNotNull((Object)this.reader);
        MappingMetadataExtracterTest.assertNotNull((Object)this.extracter);
        MappingMetadataExtracterTest.assertTrue((String)"Extracter not initialized.", (boolean)this.extracter.initCheck);
    }

    public void testDefaultExtract() throws Exception {
        this.destination.clear();
        this.extracter.extract(this.reader, this.destination);
        MappingMetadataExtracterTest.assertEquals((int)4, (int)this.destination.size());
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_A1));
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_A2));
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_B));
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_IMG));
    }

    public void testPropertyMappingOverride() throws Exception {
        Properties props = new Properties();
        props.put("namespace.prefix.my", "http://DummyMappingMetadataExtracter");
        props.put("a", " my:a1, my:a2 ");
        this.extracter.setMappingProperties(props);
        this.extracter.register();
        this.destination.clear();
        this.extracter.extract(this.reader, this.destination);
        MappingMetadataExtracterTest.assertEquals((int)2, (int)this.destination.size());
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_A1));
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_A2));
    }

    public void testPropertyMappingMerge() throws Exception {
        Properties props = new Properties();
        props.put("namespace.prefix.my", "http://DummyMappingMetadataExtracter");
        props.put("a", " my:a3 ");
        this.extracter.setMappingProperties(props);
        this.extracter.setInheritDefaultMapping(true);
        this.extracter.register();
        this.destination.clear();
        this.extracter.extract(this.reader, this.destination);
        MappingMetadataExtracterTest.assertEquals((int)5, (int)this.destination.size());
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_A1));
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_A2));
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_A3));
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_B));
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_IMG));
    }

    public void testPropertyMappingOverrideExtra() throws Exception {
        Properties props = new Properties();
        props.put("namespace.prefix.my", "http://DummyMappingMetadataExtracter");
        props.put("c", " my:c ");
        props.put("d", " my:d ");
        props.put("e", " my:e ");
        this.extracter.setMappingProperties(props);
        this.extracter.register();
        this.destination.clear();
        this.extracter.extract(this.reader, this.destination);
        MappingMetadataExtracterTest.assertEquals((int)2, (int)this.destination.size());
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_C));
        MappingMetadataExtracterTest.assertTrue((boolean)this.destination.containsKey(DummyMappingMetadataExtracter.QNAME_D));
    }

    public void testOverwritePolicyEager() {
        this.extracter.setOverwritePolicy(MetadataExtracter.OverwritePolicy.EAGER);
        this.extracter.extract(this.reader, this.destination);
        MappingMetadataExtracterTest.assertEquals((int)4, (int)this.destination.size());
        MappingMetadataExtracterTest.assertEquals((Object)"AAA", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_A1));
        MappingMetadataExtracterTest.assertEquals((Object)"AAA", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_A2));
        MappingMetadataExtracterTest.assertEquals((Object)"BBB", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_B));
        MappingMetadataExtracterTest.assertEquals((Object)"IMAGE", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_IMG));
    }

    public void testOverwritePolicyPragmatic() {
        this.extracter.setOverwritePolicy(MetadataExtracter.OverwritePolicy.PRAGMATIC);
        this.destination.put(DummyMappingMetadataExtracter.QNAME_C, (Serializable)((Object)"Will not change"));
        this.destination.put(DummyMappingMetadataExtracter.QNAME_IMG, (Serializable)((Object)"Will be changed"));
        this.extracter.extract(this.reader, this.destination);
        MappingMetadataExtracterTest.assertEquals((int)5, (int)this.destination.size());
        MappingMetadataExtracterTest.assertEquals((Object)JunkValue.INSTANCE, (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_A1));
        MappingMetadataExtracterTest.assertEquals((Object)"AAA", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_A2));
        MappingMetadataExtracterTest.assertEquals((Object)"BBB", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_B));
        MappingMetadataExtracterTest.assertEquals((Object)"Will not change", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_C));
        MappingMetadataExtracterTest.assertEquals((Object)"IMAGE", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_IMG));
    }

    public void testOverwritePolicyPrudent() {
        this.extracter.setOverwritePolicy(MetadataExtracter.OverwritePolicy.PRUDENT);
        this.destination.put(DummyMappingMetadataExtracter.QNAME_IMG, (Serializable)((Object)"Won't be changed"));
        this.extracter.extract(this.reader, this.destination);
        MappingMetadataExtracterTest.assertEquals((int)4, (int)this.destination.size());
        MappingMetadataExtracterTest.assertEquals((Object)JunkValue.INSTANCE, (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_A1));
        MappingMetadataExtracterTest.assertEquals((Object)"AAA", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_A2));
        MappingMetadataExtracterTest.assertEquals((Object)"BBB", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_B));
        MappingMetadataExtracterTest.assertEquals((Object)"Won't be changed", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_IMG));
    }

    public void testOverwritePolicyCautious() {
        this.extracter.setOverwritePolicy(MetadataExtracter.OverwritePolicy.CAUTIOUS);
        this.extracter.extract(this.reader, this.destination);
        MappingMetadataExtracterTest.assertEquals((int)4, (int)this.destination.size());
        MappingMetadataExtracterTest.assertEquals((Object)JunkValue.INSTANCE, (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_A1));
        MappingMetadataExtracterTest.assertEquals((Object)"", (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_A2));
        MappingMetadataExtracterTest.assertEquals(null, (Object)this.destination.get(DummyMappingMetadataExtracter.QNAME_B));
    }

    private static class JunkValue
    implements Serializable {
        private static final JunkValue INSTANCE = new JunkValue();
        private static final long serialVersionUID = 1L;

        private JunkValue() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyMappingMetadataExtracter
    extends AbstractMappingMetadataExtracter {
        public static final String PROP_A = "a";
        public static final String PROP_B = "b";
        public static final String PROP_C = "c";
        public static final String PROP_D = "d";
        public static final String PROP_E = "e";
        public static final String PROP_IMG = "exif";
        public static final String VALUE_A = "AAA";
        public static final String VALUE_B = "BBB";
        public static final String VALUE_C = "CCC";
        public static final String VALUE_D = "DDD";
        public static final String VALUE_IMG = "IMAGE";
        public static final String NAMESPACE_MY = "http://DummyMappingMetadataExtracter";
        public static final QName QNAME_A1 = QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"a1");
        public static final QName QNAME_A2 = QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"a2");
        public static final QName QNAME_A3 = QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"a3");
        public static final QName QNAME_B = QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"b");
        public static final QName QNAME_C = QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"c");
        public static final QName QNAME_D = QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"d");
        public static final QName QNAME_E = QName.createQName((String)"http://DummyMappingMetadataExtracter", (String)"e");
        public static final QName QNAME_IMG = QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"test");
        private static final Set<String> MIMETYPES = new HashSet<String>(5);
        Map<String, Set<QName>> defaultMapping;
        private boolean initCheck = false;

        public DummyMappingMetadataExtracter() {
            super(MIMETYPES);
        }

        @Override
        protected void init() {
            this.defaultMapping = new HashMap<String, Set<QName>>(7);
            this.defaultMapping.put(PROP_A, new HashSet<QName>(Arrays.asList(QNAME_A1, QNAME_A2)));
            this.defaultMapping.put(PROP_B, new HashSet<QName>(Arrays.asList(QNAME_B)));
            this.defaultMapping.put(PROP_IMG, new HashSet<QName>(Arrays.asList(QNAME_IMG)));
            this.initCheck = true;
            super.init();
        }

        @Override
        protected Map<String, Set<QName>> getDefaultMapping() {
            return this.defaultMapping;
        }

        @Override
        protected Map<String, Serializable> extractRaw(ContentReader reader) {
            reader.getContentString();
            HashMap<String, Serializable> ret = new HashMap<String, Serializable>(7);
            ret.put(PROP_A, (Serializable)((Object)VALUE_A));
            ret.put(PROP_B, (Serializable)((Object)VALUE_B));
            ret.put(PROP_C, (Serializable)((Object)VALUE_C));
            ret.put(PROP_D, (Serializable)((Object)VALUE_D));
            ret.put(PROP_IMG, (Serializable)((Object)VALUE_IMG));
            return ret;
        }

        static {
            MIMETYPES.add("text/plain");
            MIMETYPES.add("text/xml");
        }
    }
}

