/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RFC822MetadataExtracter
extends AbstractMappingMetadataExtracter {
    protected static final String KEY_MESSAGE_FROM = "messageFrom";
    protected static final String KEY_MESSAGE_TO = "messageTo";
    protected static final String KEY_MESSAGE_CC = "messageCc";
    protected static final String KEY_MESSAGE_SUBJECT = "messageSubject";
    protected static final String KEY_MESSAGE_SENT = "messageSent";
    protected static final String KEY_MESSAGE_RECEIVED = "messageReceived";
    public static String[] SUPPORTED_MIMETYPES = new String[]{"message/rfc822"};

    public RFC822MetadataExtracter() {
        super(new HashSet<String>(Arrays.asList(SUPPORTED_MIMETYPES)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        Map<String, Serializable> rawProperties = this.newRawMap();
        InputStream is = null;
        try {
            is = reader.getContentInputStream();
            MimeMessage mimeMessage = new MimeMessage(null, is);
            if (mimeMessage != null) {
                String tmp = InternetAddress.toString((Address[])mimeMessage.getFrom());
                tmp = tmp != null ? MimeUtility.decodeText((String)tmp) : null;
                this.putRawValue(KEY_MESSAGE_FROM, (Serializable)((Object)tmp), rawProperties);
                tmp = InternetAddress.toString((Address[])mimeMessage.getRecipients(MimeMessage.RecipientType.TO));
                tmp = tmp != null ? MimeUtility.decodeText((String)tmp) : null;
                this.putRawValue(KEY_MESSAGE_TO, (Serializable)((Object)tmp), rawProperties);
                tmp = InternetAddress.toString((Address[])mimeMessage.getRecipients(MimeMessage.RecipientType.CC));
                tmp = tmp != null ? MimeUtility.decodeText((String)tmp) : null;
                this.putRawValue(KEY_MESSAGE_CC, (Serializable)((Object)tmp), rawProperties);
                this.putRawValue(KEY_MESSAGE_SENT, mimeMessage.getSentDate(), rawProperties);
                Date rxDate = mimeMessage.getReceivedDate();
                if (rxDate != null) {
                    this.putRawValue(KEY_MESSAGE_RECEIVED, rxDate, rawProperties);
                } else {
                    String[] rx = mimeMessage.getHeader("received");
                    if (rx != null && rx.length > 0) {
                        String lastReceived = rx[0];
                        int x = (lastReceived = MimeUtility.unfold((String)lastReceived)).lastIndexOf(59);
                        if (x > 0) {
                            String dateStr = lastReceived.substring(x + 1).trim();
                            this.putRawValue(KEY_MESSAGE_RECEIVED, (Serializable)((Object)dateStr), rawProperties);
                        }
                    }
                }
                String[] subj = mimeMessage.getHeader("Subject");
                if (subj != null && subj.length > 0) {
                    String decodedSubject = subj[0];
                    try {
                        decodedSubject = MimeUtility.decodeText((String)decodedSubject);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.warn((Object)e.toString());
                    }
                    this.putRawValue(KEY_MESSAGE_SUBJECT, (Serializable)((Object)decodedSubject), rawProperties);
                }
                Set<String> keys = this.getMapping().keySet();
                Enumeration headers = mimeMessage.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header header = (Header)headers.nextElement();
                    if (!keys.contains(header.getName())) continue;
                    tmp = header.getValue();
                    tmp = tmp != null ? MimeUtility.decodeText((String)tmp) : null;
                    this.putRawValue(header.getName(), (Serializable)((Object)tmp), rawProperties);
                }
            }
            Object var12_13 = null;
            if (is == null) return rawProperties;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
            return rawProperties;
        }
        catch (IOException e) {}
        return rawProperties;
    }

    public final Map<String, Set<QName>> getCurrentMapping() {
        return super.getMapping();
    }
}

