/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.alfresco.repo.content.metadata.TikaPoweredMetadataExtracter;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.Parser;
import org.gagravarr.tika.FlacParser;
import org.gagravarr.tika.VorbisParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaAudioMetadataExtracter
extends TikaPoweredMetadataExtracter {
    protected static final String KEY_LYRICS = "lyrics";
    private static Parser[] parsers = new Parser[]{new VorbisParser(), new FlacParser()};
    public static ArrayList<String> SUPPORTED_MIMETYPES = TikaAudioMetadataExtracter.buildSupportedMimetypes(new String[]{"audio/vorbis", "audio/x-flac"}, parsers);
    protected TikaConfig tikaConfig;

    public void setTikaConfig(TikaConfig tikaConfig) {
        this.tikaConfig = tikaConfig;
    }

    public TikaAudioMetadataExtracter() {
        this(SUPPORTED_MIMETYPES);
    }

    public TikaAudioMetadataExtracter(ArrayList<String> supportedMimeTypes) {
        super(supportedMimeTypes);
    }

    @Override
    protected Parser getParser() {
        return new CompositeParser(this.tikaConfig.getMediaTypeRegistry(), parsers);
    }

    @Override
    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        this.putRawValue("description", (Serializable)((Object)this.generateDescription(metadata)), properties);
        Date releaseDate = this.generateReleaseDate(metadata);
        this.putRawValue("created", releaseDate, properties);
        this.putRawValue(XMPDM.RELEASE_DATE.getName(), releaseDate, properties);
        return properties;
    }

    private Date generateReleaseDate(Metadata metadata) {
        String date = metadata.get(XMPDM.RELEASE_DATE);
        if (date == null || date.length() == 0) {
            return null;
        }
        if (date.matches("\\d\\d\\d\\d")) {
            Calendar c = Calendar.getInstance();
            c.set(Integer.parseInt(date), 0, 1, 0, 0, 0);
            c.set(14, 0);
            return c.getTime();
        }
        return this.makeDate(date);
    }

    private String generateDescription(Metadata metadata) {
        StringBuilder result = new StringBuilder();
        if (metadata.get("title") != null) {
            result.append(metadata.get("title"));
            if (metadata.get(XMPDM.ALBUM) != null) {
                result.append(" - ").append(metadata.get(XMPDM.ALBUM));
            }
            if (metadata.get(XMPDM.ARTIST) != null) {
                result.append(" (").append(metadata.get(XMPDM.ARTIST)).append(")");
            }
        }
        return result.toString();
    }
}

