/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.TikaAudioMetadataExtracter;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaAudioMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private TikaAudioMetadataExtracter extracter;
    private static final String ARTIST = "Hauskaz";
    private static final String ALBUM = "About a dog and a fox";
    private static final String GENRE = "Foxtrot";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = (TikaAudioMetadataExtracter)this.ctx.getBean("extracter.Audio");
        this.extracter.register();
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testSupports() throws Exception {
        for (String mimetype : TikaAudioMetadataExtracter.SUPPORTED_MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            TikaAudioMetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testOggExtraction() throws Exception {
        this.testExtractFromMimetype("audio/vorbis");
    }

    public void testFlacExtraction() throws Exception {
        this.testExtractFromMimetype("audio/x-flac");
    }

    @Override
    protected void testCommonMetadata(String mimetype, Map<QName, Serializable> properties) {
        TikaAudioMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_TITLE + " not found for mimetype " + mimetype), (String)"The quick brown fox jumps over the lazy dog", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_TITLE))));
        TikaAudioMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_AUTHOR + " not found for mimetype " + mimetype), (String)ARTIST, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_AUTHOR))));
        TikaAudioMetadataExtracterTest.assertContains("Property " + ContentModel.PROP_DESCRIPTION + " didn't contain " + "The quick brown fox jumps over the lazy dog" + " for mimetype " + mimetype, "The quick brown fox jumps over the lazy dog", (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_DESCRIPTION)));
    }

    @Override
    public void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        QName album = QName.createQName((String)"http://www.alfresco.org/model/audio/1.0", (String)"album");
        TikaAudioMetadataExtracterTest.assertEquals((String)("Property " + album + " not found for mimetype " + mimetype), (String)ALBUM, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(album))));
        QName artist = QName.createQName((String)"http://www.alfresco.org/model/audio/1.0", (String)"artist");
        TikaAudioMetadataExtracterTest.assertEquals((String)("Property " + artist + " not found for mimetype " + mimetype), (String)ARTIST, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(artist))));
        QName genre = QName.createQName((String)"http://www.alfresco.org/model/audio/1.0", (String)"genre");
        TikaAudioMetadataExtracterTest.assertEquals((String)("Property " + genre + " not found for mimetype " + mimetype), (String)GENRE, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(genre))));
        QName releaseDate = QName.createQName((String)"http://www.alfresco.org/model/audio/1.0", (String)"releaseDate");
        TikaAudioMetadataExtracterTest.assertEquals((String)("Property " + releaseDate + " not found for mimetype " + mimetype), (String)"2009-01-01T00:00:00.000Z", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(releaseDate))));
        QName channels = QName.createQName((String)"http://www.alfresco.org/model/audio/1.0", (String)"channelType");
        TikaAudioMetadataExtracterTest.assertEquals((String)("Property " + channels + " not found for mimetype " + mimetype), (String)"Stereo", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(channels))));
        TikaAudioMetadataExtracterTest.assertContains("Property " + ContentModel.PROP_DESCRIPTION + " didn't contain " + ARTIST + " for mimetype " + mimetype, ARTIST, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_DESCRIPTION)));
    }
}

