/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TikaPoweredMetadataExtracter
extends AbstractMappingMetadataExtracter {
    protected static Log logger = LogFactory.getLog(TikaPoweredMetadataExtracter.class);
    protected static final String KEY_AUTHOR = "author";
    protected static final String KEY_TITLE = "title";
    protected static final String KEY_SUBJECT = "subject";
    protected static final String KEY_CREATED = "created";
    protected static final String KEY_DESCRIPTION = "description";
    protected static final String KEY_COMMENTS = "comments";
    private DateFormat[] tikaDateFormats;

    protected static ArrayList<String> buildSupportedMimetypes(String[] explicitTypes, Parser ... tikaParsers) {
        ArrayList<String> types = new ArrayList<String>();
        for (String string : explicitTypes) {
            if (types.contains(string)) continue;
            types.add(string);
        }
        if (tikaParsers != null) {
            for (String string : tikaParsers) {
                for (MediaType mt : string.getSupportedTypes(new ParseContext())) {
                    String type = mt.toString();
                    if (types.contains(type)) continue;
                    types.add(type);
                }
            }
        }
        return types;
    }

    public TikaPoweredMetadataExtracter(ArrayList<String> supportedMimeTypes) {
        this(new HashSet<String>(supportedMimeTypes));
    }

    public TikaPoweredMetadataExtracter(HashSet<String> supportedMimeTypes) {
        super(supportedMimeTypes);
        for (DateFormat df : this.tikaDateFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM-dd", Locale.US), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US), new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("yyyy/MM/dd", Locale.US), new SimpleDateFormat("EEE MMM dd hh:mm:ss zzz yyyy"), new SimpleDateFormat("EEE MMM dd hh:mm:ss zzz yyyy", Locale.US)}) {
            SimpleDateFormat sdf;
            if (!(df instanceof SimpleDateFormat) || !(sdf = (SimpleDateFormat)df).toPattern().endsWith("'Z'")) continue;
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }

    @Override
    protected Date makeDate(String dateStr) {
        for (DateFormat df : this.tikaDateFormats) {
            try {
                return df.parse(dateStr);
            }
            catch (ParseException ee) {
            }
        }
        return super.makeDate(dateStr);
    }

    protected abstract Parser getParser();

    protected boolean needHeaderContents() {
        return false;
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        return properties;
    }

    private InputStream getInputStream(ContentReader reader) throws IOException {
        if ("image/jpeg".equals(reader.getMimetype()) || "image/tiff".equals(reader.getMimetype())) {
            if (reader instanceof FileContentReader) {
                return TikaInputStream.get((File)((FileContentReader)reader).getFile());
            }
            File tmpFile = TempFileProvider.createTempFile((String)"tika", (String)"tmp");
            reader.getContent(tmpFile);
            return TikaInputStream.get((File)tmpFile);
        }
        return reader.getContentInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        Map<String, Serializable> rawProperties = this.newRawMap();
        InputStream is = null;
        try {
            void var7_11;
            is = this.getInputStream(reader);
            Parser parser = this.getParser();
            ParseContext context = new ParseContext();
            Metadata metadata = new Metadata();
            metadata.add("Content-Type", reader.getMimetype());
            Map<String, String> headers = null;
            if (this.needHeaderContents()) {
                MapCaptureContentHandler headerCapture = new MapCaptureContentHandler();
                headers = headerCapture.tags;
                HeadContentHandler headContentHandler = new HeadContentHandler(headerCapture);
            } else {
                NullContentHandler nullContentHandler = new NullContentHandler();
            }
            parser.parse(is, (ContentHandler)var7_11, metadata, context);
            for (String tikaKey : metadata.names()) {
                this.putRawValue(tikaKey, (Serializable)((Object)metadata.get(tikaKey)), rawProperties);
            }
            this.putRawValue(KEY_AUTHOR, (Serializable)((Object)metadata.get("Author")), rawProperties);
            this.putRawValue(KEY_TITLE, (Serializable)((Object)metadata.get(KEY_TITLE)), rawProperties);
            this.putRawValue(KEY_COMMENTS, (Serializable)((Object)metadata.get("Comments")), rawProperties);
            String subject = metadata.get(KEY_SUBJECT);
            String description = metadata.get(KEY_DESCRIPTION);
            if (subject != null && description != null) {
                this.putRawValue(KEY_DESCRIPTION, (Serializable)((Object)description), rawProperties);
                this.putRawValue(KEY_SUBJECT, (Serializable)((Object)subject), rawProperties);
            } else if (subject != null) {
                this.putRawValue(KEY_DESCRIPTION, (Serializable)((Object)subject), rawProperties);
                this.putRawValue(KEY_SUBJECT, (Serializable)((Object)subject), rawProperties);
            } else if (description != null) {
                this.putRawValue(KEY_DESCRIPTION, (Serializable)((Object)description), rawProperties);
                this.putRawValue(KEY_SUBJECT, (Serializable)((Object)description), rawProperties);
            }
            if (metadata.get(Metadata.CREATION_DATE) != null) {
                this.putRawValue(KEY_CREATED, (Serializable)((Object)metadata.get(Metadata.CREATION_DATE)), rawProperties);
            } else if (metadata.get(Metadata.DATE) != null) {
                this.putRawValue(KEY_CREATED, (Serializable)((Object)metadata.get(Metadata.DATE)), rawProperties);
            }
            rawProperties = this.extractSpecific(metadata, rawProperties, headers);
            Object var14_16 = null;
            if (is == null) return rawProperties;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
            return rawProperties;
        }
        catch (IOException e) {}
        return rawProperties;
    }

    protected static class NullContentHandler
    implements ContentHandler {
        protected NullContentHandler() {
        }

        public void characters(char[] paramArrayOfChar, int paramInt1, int paramInt2) throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String paramString1, String paramString2, String paramString3) throws SAXException {
        }

        public void endPrefixMapping(String paramString) throws SAXException {
        }

        public void ignorableWhitespace(char[] paramArrayOfChar, int paramInt1, int paramInt2) throws SAXException {
        }

        public void processingInstruction(String paramString1, String paramString2) throws SAXException {
        }

        public void setDocumentLocator(Locator paramLocator) {
        }

        public void skippedEntity(String paramString) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String paramString1, String paramString2, String paramString3, Attributes paramAttributes) throws SAXException {
        }

        public void startPrefixMapping(String paramString1, String paramString2) throws SAXException {
        }
    }

    protected static class MapCaptureContentHandler
    implements ContentHandler {
        protected Map<String, String> tags = new HashMap<String, String>();
        private StringBuffer text;

        protected MapCaptureContentHandler() {
        }

        public void characters(char[] ch, int start, int len) {
            if (this.text != null) {
                this.text.append(ch, start, len);
            }
        }

        public void endElement(String namespace, String localname, String qname) {
            if (this.text != null && this.text.length() > 0) {
                this.tags.put(qname, this.text.toString());
            }
            this.text = null;
        }

        public void startElement(String namespace, String localname, String qname, Attributes attrs) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.tags.put(attrs.getQName(i), attrs.getValue(i));
            }
            this.text = new StringBuffer();
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String paramString) throws SAXException {
        }

        public void ignorableWhitespace(char[] paramArrayOfChar, int paramInt1, int paramInt2) throws SAXException {
        }

        public void processingInstruction(String paramString1, String paramString2) throws SAXException {
        }

        public void setDocumentLocator(Locator paramLocator) {
        }

        public void skippedEntity(String paramString) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startPrefixMapping(String paramString1, String paramString2) throws SAXException {
        }
    }

    protected static class HeadContentHandler
    extends ContentHandlerDecorator {
        private static final XPathParser PARSER = new XPathParser("xhtml", "http://www.w3.org/1999/xhtml");
        private static final Matcher MATCHER = PARSER.parse("/xhtml:html/xhtml:head/descendant:node()");

        protected HeadContentHandler(ContentHandler handler) {
            super((ContentHandler)new MatchingContentHandler(handler, MATCHER));
        }
    }
}

