/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.BinaryPassThroughContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class BinaryPassThroughContentTransformerTest
extends AbstractContentTransformerTest {
    private BinaryPassThroughContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new BinaryPassThroughContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        TransformationOptions options = new TransformationOptions();
        boolean reliability = false;
        reliability = this.transformer.isTransformable("text/plain", -1L, "text/plain", options);
        BinaryPassThroughContentTransformerTest.assertFalse((String)"Mimetype should not be supported", (boolean)reliability);
        reliability = this.transformer.isTransformable("text/xml", -1L, "text/xml", options);
        BinaryPassThroughContentTransformerTest.assertFalse((String)"Mimetype should not be supported", (boolean)reliability);
        reliability = this.transformer.isTransformable("application/msword", -1L, "application/msword", options);
        BinaryPassThroughContentTransformerTest.assertTrue((String)"Mimetype should be supported", (boolean)reliability);
        reliability = this.transformer.isTransformable("application/vnd.ms-excel", -1L, "application/vnd.ms-excel", options);
        BinaryPassThroughContentTransformerTest.assertTrue((String)"Mimetype should be supported", (boolean)reliability);
    }
}

