/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class EMLTransformer
extends AbstractContentTransformer2 {
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "message/rfc822".equals(sourceMimetype) && "text/plain".equals(targetMimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        InputStream is = null;
        try {
            is = reader.getContentInputStream();
            MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), is);
            StringBuilder sb = new StringBuilder();
            Object content = mimeMessage.getContent();
            if (content instanceof Multipart) {
                sb.append((CharSequence)this.processMultiPart((Multipart)content));
            } else {
                sb.append(content.toString());
            }
            writer.putContent(sb.toString());
            Object var9_8 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            is.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private StringBuilder processMultiPart(Multipart multipart) throws MessagingException, IOException {
        StringBuilder sb = new StringBuilder();
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            if (part.getContent() instanceof Multipart) {
                sb.append((CharSequence)this.processMultiPart((Multipart)part.getContent()));
                continue;
            }
            if (!part.getContentType().contains("text")) continue;
            sb.append(part.getContent().toString()).append("\n");
        }
        return sb;
    }
}

