/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.PdfBoxPdfToImageContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class PdfBoxPdfToImageContentTransformerTest
extends AbstractContentTransformerTest {
    private PdfBoxPdfToImageContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new PdfBoxPdfToImageContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        PdfBoxPdfToImageContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/pdf", -1L, "image/png", new TransformationOptions()));
    }

    public void testExtractContentFromSecuredPdf() throws Exception {
        File securePdfFile = PdfBoxPdfToImageContentTransformerTest.loadNamedQuickTestFile("quick-secured.pdf");
        PdfBoxPdfToImageContentTransformerTest.assertNotNull((String)"test file was null.", (Object)securePdfFile);
        FileContentReader reader = new FileContentReader(securePdfFile);
        reader.setMimetype("application/pdf");
        reader.setEncoding("UTF-8");
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis()), (String)"txt"));
        writer.setMimetype("image/png");
        writer.setEncoding("UTF-8");
        this.transformer.transform(reader, writer);
        ContentReader checkReader = writer.getReader();
        checkReader.setMimetype("image/png");
        PdfBoxPdfToImageContentTransformerTest.assertTrue((String)"PNG output was empty", (checkReader.getContentData().getSize() != 0L ? 1 : 0) != 0);
    }

    public void testTransformAdobeIllustrator() throws Exception {
        for (String quickFile : new String[]{"quickCS3.ai", "quickCS5.ai"}) {
            File aiFile = PdfBoxPdfToImageContentTransformerTest.loadNamedQuickTestFile(quickFile);
            PdfBoxPdfToImageContentTransformerTest.assertNotNull((String)"test file was null.", (Object)aiFile);
            FileContentReader reader = new FileContentReader(aiFile);
            reader.setMimetype("application/illustrator");
            reader.setEncoding("UTF-8");
            FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis()), (String)"txt"));
            writer.setMimetype("image/png");
            writer.setEncoding("UTF-8");
            this.transformer.transform(reader, writer);
            ContentReader checkReader = writer.getReader();
            checkReader.setMimetype("image/png");
            PdfBoxPdfToImageContentTransformerTest.assertTrue((String)"PNG output was empty", (checkReader.getContentData().getSize() != 0L ? 1 : 0) != 0);
        }
    }
}

