/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.Writer;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerConfigurationException;
import org.alfresco.repo.content.TikaOfficeDetectParser;
import org.alfresco.repo.content.transform.TikaPoweredContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PoiHssfContentTransformer
extends TikaPoweredContentTransformer {
    public static final String WRONG_FORMAT_MESSAGE_ID = "transform.err.format_or_password";
    private static Log logger = LogFactory.getLog(PoiHssfContentTransformer.class);

    public PoiHssfContentTransformer() {
        super(new String[]{"application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"});
    }

    protected Parser getParser() {
        return new TikaOfficeDetectParser();
    }

    public boolean isTransformable(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        if (this.sourceMimeTypes.contains(sourceMimetype) && "text/csv".equals(targetMimetype)) {
            return this.isTransformableSize(sourceMimetype, sourceSize, targetMimetype, options);
        }
        return super.isTransformable(sourceMimetype, sourceSize, targetMimetype, options);
    }

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.isTransformable(sourceMimetype, -1L, targetMimetype, options);
    }

    public boolean isExplicitTransformation(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (this.sourceMimeTypes.contains(sourceMimetype) && ("text/html".equals(targetMimetype) || "application/xhtml+xml".equals(targetMimetype))) {
            return true;
        }
        return super.isTransformable(sourceMimetype, targetMimetype, options);
    }

    protected ContentHandler getContentHandler(String targetMimeType, Writer output) throws TransformerConfigurationException {
        if ("text/csv".equals(targetMimeType)) {
            return new CsvContentHandler(output);
        }
        return super.getContentHandler(targetMimeType, output);
    }

    protected static class CsvContentHandler
    extends BodyContentHandler {
        private static final char[] comma = new char[]{','};
        private static final Pattern all_nums = Pattern.compile("[\\d\\.\\-\\+]+");
        private boolean inCell = false;
        private boolean needsComma = false;

        protected CsvContentHandler(Writer output) {
            super(output);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (length != 1 || ch[0] != '\t') {
                super.ignorableWhitespace(ch, start, length);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inCell) {
                StringBuffer t = new StringBuffer(new String(ch, start, length));
                if (all_nums.matcher(t).matches()) {
                    super.characters(ch, start, length);
                } else {
                    for (int i = t.length() - 1; i >= 0; --i) {
                        if (t.charAt(i) != '\"') continue;
                        t.insert(i, '\"');
                        --i;
                    }
                    t.insert(0, '\"');
                    t.append('\"');
                    char[] c = t.toString().toCharArray();
                    super.characters(c, 0, c.length);
                }
            } else {
                super.characters(ch, start, length);
            }
        }

        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            if (localName.equals("td")) {
                this.inCell = true;
                if (this.needsComma) {
                    super.characters(comma, 0, 1);
                    this.needsComma = true;
                }
            } else {
                super.startElement(uri, localName, name, atts);
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (localName.equals("td")) {
                this.needsComma = true;
                this.inCell = false;
            } else {
                if (localName.equals("tr")) {
                    this.needsComma = false;
                }
                super.endElement(uri, localName, name);
            }
        }
    }
}

