/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.AbstractContentTransformerLimits;
import org.alfresco.repo.content.transform.ComplexContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.FailoverContentTransformer;
import org.alfresco.repo.content.transform.ProxyContentTransformer;
import org.alfresco.repo.content.transform.RuntimeExecutableContentTransformerWorker;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerDebug {
    private static final Log logger = LogFactory.getLog(TransformerDebug.class);
    private final MimetypeService mimetypeService;

    public TransformerDebug(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void pushAvailable(String fromUrl, String sourceMimetype, String targetMimetype) {
        if (this.isEnabled()) {
            this.push(null, fromUrl, sourceMimetype, targetMimetype, -1L, Call.AVAILABLE);
        }
    }

    public void pushTransform(ContentTransformer transformer, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize) {
        if (this.isEnabled()) {
            this.push(this.getName(transformer), fromUrl, sourceMimetype, targetMimetype, sourceSize, Call.TRANSFORM);
        }
    }

    private void push(String name, String fromUrl, String sourceMimetype, String targetMimetype, long sourceSize, Call callType) {
        Deque<Frame> ourStack = ThreadInfo.getStack();
        Frame frame = ourStack.peek();
        if (callType == Call.TRANSFORM && frame != null && frame.callType == Call.AVAILABLE) {
            frame.callType = Call.AVAILABLE_AND_TRANSFORM;
        } else {
            frame = new Frame(frame, fromUrl, sourceMimetype, targetMimetype, callType);
            ourStack.push(frame);
            if (callType == Call.TRANSFORM) {
                this.logBasicDetails(frame, sourceSize, name, ourStack.size() == 1);
            }
        }
    }

    public void unavailableTransformer(ContentTransformer transformer, long maxSourceSizeKBytes) {
        Deque<Frame> ourStack;
        Frame frame;
        if (this.isEnabled() && (frame = (ourStack = ThreadInfo.getStack()).peek()) != null) {
            boolean debug;
            String name = this.getName(transformer);
            String reason = String.format("> %,dK", maxSourceSizeKBytes);
            boolean bl = debug = maxSourceSizeKBytes != 0L;
            if (ourStack.size() == 1) {
                if (frame.unavailableTransformers == null) {
                    frame.unavailableTransformers = new HashSet();
                }
                frame.unavailableTransformers.add(new UnavailableTransformer(name, reason, debug));
            } else {
                this.log("-- " + name + ' ' + reason, debug);
            }
        }
    }

    public void availableTransformers(List<ContentTransformer> transformers, long sourceSize, String calledFrom) {
        if (this.isEnabled()) {
            Deque<Frame> ourStack = ThreadInfo.getStack();
            Frame frame = ourStack.peek();
            this.logBasicDetails(frame, sourceSize, calledFrom + (transformers.size() == 0 ? " NO transformers" : ""), ourStack.size() == 1);
            char c = 'a';
            int longestNameLength = this.getLongestTransformerNameLength(transformers, frame);
            for (ContentTransformer trans : transformers) {
                String name = this.getName(trans);
                int pad = longestNameLength - name.length();
                String string = c == 'a' ? "**" : "  ";
                char c2 = c;
                c = (char)(c + 1);
                this.log(string + c2 + ") " + name + this.spaces(pad + 1) + trans.getTransformationTime() + " ms");
            }
            if (frame.unavailableTransformers != null) {
                for (UnavailableTransformer unavailable : frame.unavailableTransformers) {
                    int pad = longestNameLength - unavailable.name.length();
                    char c3 = c;
                    c = (char)(c + '\u0001');
                    this.log("--" + c3 + ") " + unavailable.name + this.spaces(pad + 1) + unavailable.reason, unavailable.debug);
                }
            }
        }
    }

    private int getLongestTransformerNameLength(List<ContentTransformer> transformers, Frame frame) {
        int length;
        int longestNameLength = 0;
        for (ContentTransformer trans : transformers) {
            length = this.getName(trans).length();
            if (longestNameLength >= length) continue;
            longestNameLength = length;
        }
        if (frame.unavailableTransformers != null) {
            for (UnavailableTransformer unavailable : frame.unavailableTransformers) {
                length = unavailable.name.length();
                if (longestNameLength >= length) continue;
                longestNameLength = length;
            }
        }
        return longestNameLength;
    }

    private void logBasicDetails(Frame frame, long sourceSize, String message, boolean firstLevel) {
        if (frame.fromUrl != null && (firstLevel || frame.id != 1)) {
            this.log(frame.fromUrl, firstLevel);
        }
        this.log(this.getMimetypeExt(frame.sourceMimetype) + this.getMimetypeExt(frame.targetMimetype) + String.format("%,dK ", sourceSize / 1024L) + message);
        this.log(frame.sourceMimetype + ' ' + frame.targetMimetype, false);
    }

    public void popAvailable() {
        if (this.isEnabled()) {
            this.pop(Call.AVAILABLE);
        }
    }

    public void popTransform() {
        if (this.isEnabled()) {
            this.pop(Call.TRANSFORM);
        }
    }

    private void pop(Call callType) {
        Frame frame;
        Deque<Frame> ourStack = ThreadInfo.getStack();
        if (!ourStack.isEmpty() && ((frame = ourStack.peek()).callType == callType || frame.callType == Call.AVAILABLE_AND_TRANSFORM && callType == Call.AVAILABLE)) {
            if (ourStack.size() == 1 || logger.isTraceEnabled()) {
                boolean topFrame = ourStack.size() == 1;
                this.log("Finished in " + (System.currentTimeMillis() - frame.start) + " ms" + (frame.callType == Call.AVAILABLE ? " Transformer NOT called" : "") + (topFrame ? "\n" : ""), topFrame);
            }
            ourStack.pop();
        }
    }

    public boolean isEnabled() {
        return logger.isDebugEnabled() && ThreadInfo.getDebug() || logger.isTraceEnabled();
    }

    public static boolean setDebugOutput(boolean debugOutput) {
        return ThreadInfo.setDebugOutput(debugOutput);
    }

    public void debug(String message) {
        if (this.isEnabled() && message != null) {
            this.log(message);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isEnabled()) {
            this.log(message + ' ' + t.getMessage());
        }
    }

    private void log(String message) {
        this.log(message, true);
    }

    private void log(String message, boolean debug) {
        this.log(message, null, debug);
    }

    private void log(String message, Throwable t, boolean debug) {
        if (debug && ThreadInfo.getDebug()) {
            logger.debug((Object)(this.getReference() + message), t);
        } else {
            logger.trace((Object)(this.getReference() + message), t);
        }
    }

    public <T extends Throwable> T setCause(T t) {
        return t;
    }

    private String getReference() {
        StringBuilder sb = new StringBuilder("");
        Frame frame = null;
        Iterator<Frame> iterator = ThreadInfo.getStack().descendingIterator();
        int lengthOfFirstId = 0;
        while (iterator.hasNext()) {
            frame = iterator.next();
            if (sb.length() == 0) {
                sb.append(frame.id);
                lengthOfFirstId = sb.length();
                continue;
            }
            sb.append('.');
            sb.append(frame.id);
        }
        if (frame != null) {
            sb.append(this.spaces(9 - sb.length() + lengthOfFirstId));
        }
        return sb.toString();
    }

    private String getName(ContentTransformer transformer) {
        return (transformer instanceof AbstractContentTransformer2 ? ((AbstractContentTransformerLimits)transformer).getBeanName() : transformer.getClass().getSimpleName()) + (transformer instanceof ComplexContentTransformer ? "<<Complex>>" : (transformer instanceof FailoverContentTransformer ? "<<Failover>>" : (transformer instanceof ProxyContentTransformer ? (((ProxyContentTransformer)transformer).getWorker() instanceof RuntimeExecutableContentTransformerWorker ? "<<Runtime>>" : "<<Proxy>>") : "")));
    }

    private String getMimetypeExt(String mimetype) {
        StringBuilder sb = new StringBuilder("");
        if (this.mimetypeService == null) {
            sb.append(mimetype);
            sb.append(' ');
        } else {
            String mimetypeExt = this.mimetypeService.getExtension(mimetype);
            sb.append(mimetypeExt);
            sb.append(this.spaces(5 - mimetypeExt.length()));
        }
        return sb.toString();
    }

    private String spaces(int i) {
        StringBuilder sb = new StringBuilder("");
        while (--i >= 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private class UnavailableTransformer {
        private final String name;
        private final String reason;
        private final transient boolean debug;

        UnavailableTransformer(String name, String reason, boolean debug) {
            this.name = name;
            this.reason = reason;
            this.debug = debug;
        }

        public int hashCode() {
            int hashCode = 37 * this.name.hashCode();
            return hashCode += 37 * this.reason.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UnavailableTransformer) {
                UnavailableTransformer that = (UnavailableTransformer)obj;
                return EqualsHelper.nullSafeEquals((Object)this.name, (Object)that.name) && EqualsHelper.nullSafeEquals((Object)this.reason, (Object)that.reason);
            }
            return false;
        }
    }

    private static class Frame {
        private static final AtomicInteger uniqueId = new AtomicInteger(0);
        private final int id;
        private final String fromUrl;
        private final String sourceMimetype;
        private final String targetMimetype;
        private final long start;
        private Call callType;
        private int childId;
        private Set<UnavailableTransformer> unavailableTransformers;

        private Frame(Frame parent, String fromUrl, String sourceMimetype, String targetMimetype, Call pushCall) {
            this.id = parent == null ? uniqueId.getAndIncrement() : (parent.childId = parent.childId + 1);
            this.fromUrl = fromUrl;
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
            this.callType = pushCall;
            this.start = System.currentTimeMillis();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadInfo {
        private static final ThreadLocal<ThreadInfo> threadInfo = new ThreadLocal<ThreadInfo>(){

            @Override
            protected ThreadInfo initialValue() {
                return new ThreadInfo();
            }
        };
        private final Deque<Frame> stack = new ArrayDeque<Frame>();
        private boolean debugOutput = true;

        private ThreadInfo() {
        }

        public static Deque<Frame> getStack() {
            return ThreadInfo.threadInfo.get().stack;
        }

        public static boolean getDebug() {
            return ThreadInfo.threadInfo.get().debugOutput;
        }

        public static boolean setDebugOutput(boolean debugOutput) {
            ThreadInfo thisThreadInfo = threadInfo.get();
            boolean orig = thisThreadInfo.debugOutput;
            thisThreadInfo.debugOutput = debugOutput;
            return orig;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Call {
        AVAILABLE,
        TRANSFORM,
        AVAILABLE_AND_TRANSFORM;

    }
}

