/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;

public class DescriptorServiceTest
extends BaseSpringTest {
    private NodeService nodeService;
    private ImporterBootstrap systemBootstrap;
    private StoreRef storeRef;
    private AuthenticationComponent authenticationComponent;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.systemBootstrap = (ImporterBootstrap)((Object)this.applicationContext.getBean("systemBootstrap"));
        this.storeRef = new StoreRef("system", "Test_" + System.currentTimeMillis());
        this.systemBootstrap.setStoreUrl(this.storeRef.toString());
        this.systemBootstrap.bootstrap();
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    public void testServerDescriptor() {
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        DescriptorService descriptorService = registry.getDescriptorService();
        Descriptor serverDescriptor = descriptorService.getServerDescriptor();
        String major = serverDescriptor.getVersionMajor();
        String minor = serverDescriptor.getVersionMinor();
        String revision = serverDescriptor.getVersionRevision();
        String label = serverDescriptor.getVersionLabel();
        String build = serverDescriptor.getVersionBuild();
        String edition = serverDescriptor.getEdition();
        String id = serverDescriptor.getId();
        String version = major + "." + minor + "." + revision;
        version = this.buildVersionString(version, label, build);
        DescriptorServiceTest.assertEquals((String)version, (String)serverDescriptor.getVersion());
        int schemaVersion = serverDescriptor.getSchema();
        DescriptorServiceTest.assertTrue((String)"Server schema version must be greater than 0", (schemaVersion > 0 ? 1 : 0) != 0);
        DescriptorServiceTest.assertNotNull((String)"edition is null", (Object)edition);
        DescriptorServiceTest.assertEquals((String)"id ", (String)id, (String)"Unknown");
    }

    public void testCurrentRepositoryDescriptor() {
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        DescriptorService descriptorService = registry.getDescriptorService();
        Descriptor repoDescriptor = descriptorService.getCurrentRepositoryDescriptor();
        String major = repoDescriptor.getVersionMajor();
        String minor = repoDescriptor.getVersionMinor();
        String revision = repoDescriptor.getVersionRevision();
        String label = repoDescriptor.getVersionLabel();
        String build = repoDescriptor.getVersionBuild();
        String id = repoDescriptor.getId();
        String version = major + "." + minor + "." + revision;
        version = this.buildVersionString(version, label, build);
        DescriptorServiceTest.assertEquals((String)version, (String)repoDescriptor.getVersion());
        DescriptorServiceTest.assertNotNull((String)"repository id is null", (Object)id);
        DescriptorServiceTest.assertNotNull((String)"major is null", (Object)major);
        DescriptorServiceTest.assertNotNull((String)"minor is null", (Object)minor);
        DescriptorServiceTest.assertNotNull((String)"revision is null", (Object)revision);
        int schemaVersion = repoDescriptor.getSchema();
        DescriptorServiceTest.assertTrue((String)"Repository schema version must be greater than -1", (schemaVersion > -1 ? 1 : 0) != 0);
    }

    public void testCompareDescriptors() {
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        DescriptorService descriptorService = registry.getDescriptorService();
        Descriptor serverDescriptor = descriptorService.getServerDescriptor();
        Descriptor repoDescriptor = descriptorService.getCurrentRepositoryDescriptor();
        String major1 = repoDescriptor.getVersionMajor();
        String minor1 = repoDescriptor.getVersionMinor();
        String revision1 = repoDescriptor.getVersionRevision();
        String label1 = repoDescriptor.getVersionLabel();
        String build1 = repoDescriptor.getVersionBuild();
        String id1 = repoDescriptor.getId();
        String major2 = serverDescriptor.getVersionMajor();
        String minor2 = serverDescriptor.getVersionMinor();
        String revision2 = serverDescriptor.getVersionRevision();
        String label2 = serverDescriptor.getVersionLabel();
        String build2 = serverDescriptor.getVersionBuild();
        String id2 = serverDescriptor.getId();
        DescriptorServiceTest.assertEquals((String)"major version different", (String)major1, (String)major2);
        DescriptorServiceTest.assertEquals((String)"minor version different", (String)minor1, (String)minor2);
        DescriptorServiceTest.assertEquals((String)"revision version different", (String)revision1, (String)revision2);
        DescriptorServiceTest.assertEquals((String)"label version different", (String)label1, (String)label2);
        DescriptorServiceTest.assertEquals((String)"build version different", (String)build1, (String)build2);
    }

    public void testInstalledRepositoryDescriptor() {
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        DescriptorService descriptorService = registry.getDescriptorService();
        Descriptor repoDescriptor = descriptorService.getInstalledRepositoryDescriptor();
        String major = repoDescriptor.getVersionMajor();
        String minor = repoDescriptor.getVersionMinor();
        String revision = repoDescriptor.getVersionRevision();
        String label = repoDescriptor.getVersionLabel();
        String build = repoDescriptor.getVersionBuild();
        String version = major + "." + minor + "." + revision;
        version = this.buildVersionString(version, label, build);
        DescriptorServiceTest.assertEquals((String)version, (String)repoDescriptor.getVersion());
        int schemaVersion = repoDescriptor.getSchema();
        DescriptorServiceTest.assertTrue((String)"Repository schema version must be greater than -1", (schemaVersion > -1 ? 1 : 0) != 0);
    }

    private String buildVersionString(String version, String label, String build) {
        boolean hasBuild;
        StringBuilder builder = new StringBuilder(version);
        boolean hasLabel = label != null && label.length() > 0;
        boolean bl = hasBuild = build != null && build.length() > 0;
        if (hasLabel || hasBuild) {
            builder.append(" (");
        }
        if (hasLabel) {
            builder.append(label);
        }
        if (hasBuild) {
            if (hasLabel) {
                builder.append(" ");
            }
            builder.append(build);
        }
        if (hasLabel || hasBuild) {
            builder.append(")");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyLicenseLoad_ALF10110() throws Exception {
        this.setComplete();
        this.endTransaction();
        QName vetoName = QName.createQName((String)"{test}veto");
        TransactionServiceImpl txnService = (TransactionServiceImpl)this.applicationContext.getBean("TransactionService");
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        DescriptorService descriptorService = registry.getDescriptorService();
        try {
            txnService.setAllowWrite(false, vetoName);
            descriptorService.loadLicense();
            Object var6_5 = null;
            txnService.setAllowWrite(true, vetoName);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            txnService.setAllowWrite(true, vetoName);
            throw throwable;
        }
    }
}

