/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.EmptyContentReader;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageDeployer;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryRepositoryBootstrap
extends AbstractLifecycleBean
implements TenantDeployer,
DictionaryListener,
MessageDeployer {
    private static Log logger = LogFactory.getLog(DictionaryRepositoryBootstrap.class);
    private List<RepositoryLocation> repositoryModelsLocations = new ArrayList<RepositoryLocation>();
    private List<RepositoryLocation> repositoryMessagesLocations = new ArrayList<RepositoryLocation>();
    private DictionaryDAO dictionaryDAO = null;
    private ContentService contentService;
    private NodeService nodeService;
    private TenantAdminService tenantAdminService;
    private NamespaceService namespaceService;
    private MessageService messageService;
    private TransactionService transactionService;

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRepositoryModelsLocations(List<RepositoryLocation> repositoryLocations) {
        this.repositoryModelsLocations = repositoryLocations;
    }

    public void setRepositoryMessagesLocations(List<RepositoryLocation> repositoryLocations) {
        this.repositoryMessagesLocations = repositoryLocations;
    }

    public void init() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                DictionaryRepositoryBootstrap.this.onDictionaryInit();
                DictionaryRepositoryBootstrap.this.initMessages();
                return null;
            }
        }, this.transactionService.isReadOnly(), false);
    }

    public void destroy() {
    }

    public void onDictionaryInit() {
        Collection modelsAfter;
        int modelsAfterCnt;
        Collection modelsBefore;
        long startTime = System.currentTimeMillis();
        if (logger.isTraceEnabled()) {
            String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
            logger.trace((Object)("onDictionaryInit: [" + Thread.currentThread() + "]" + (tenantDomain.equals("") ? "" : " (Tenant: " + tenantDomain + ")")));
        }
        int modelsBeforeCnt = (modelsBefore = this.dictionaryDAO.getModels()) != null ? modelsBefore.size() : 0;
        ArrayList<String> loadedModels = new ArrayList<String>();
        if (this.repositoryModelsLocations != null) {
            HashMap<String, Pair<RepositoryLocation, M2Model>> modelMap = new HashMap<String, Pair<RepositoryLocation, M2Model>>();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("onDictionaryInit: locations=" + this.repositoryModelsLocations));
            }
            for (RepositoryLocation repositoryLocation : this.repositoryModelsLocations) {
                StoreRef storeRef = repositoryLocation.getStoreRef();
                if (!this.nodeService.exists(storeRef)) {
                    logger.warn((Object)("StoreRef '" + storeRef + "' does not exist"));
                    continue;
                }
                List<NodeRef> nodeRefs = null;
                if (repositoryLocation.getQueryLanguage().equals("path")) {
                    nodeRefs = this.getNodes(storeRef, repositoryLocation, ContentModel.TYPE_DICTIONARY_MODEL);
                    if (nodeRefs.size() <= 0) continue;
                    for (NodeRef dictionaryModel : nodeRefs) {
                        try {
                            M2Model model;
                            Boolean isActive;
                            if (this.nodeService.hasAspect(dictionaryModel, ContentModel.ASPECT_WORKING_COPY) || this.nodeService.hasAspect(dictionaryModel, ContentModel.ASPECT_ARCHIVED) || (isActive = (Boolean)this.nodeService.getProperty(dictionaryModel, ContentModel.PROP_MODEL_ACTIVE)) == null || !isActive.booleanValue() || (model = this.createM2Model(dictionaryModel)) == null) continue;
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("onDictionaryInit: " + model.getName() + " (" + dictionaryModel + ")"));
                            }
                            for (M2Namespace namespace : model.getNamespaces()) {
                                modelMap.put(namespace.getUri(), (Pair<RepositoryLocation, M2Model>)new Pair((Object)repositoryLocation, (Object)model));
                            }
                        }
                        catch (InvalidNodeRefException inre) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("onDictionaryInit: " + (Object)((Object)inre) + " (assume concurrently deleted)"));
                        }
                    }
                    continue;
                }
                logger.error((Object)("Unsupported query language for models location: " + repositoryLocation.getQueryLanguage()));
            }
            for (Map.Entry entry : modelMap.entrySet()) {
                RepositoryLocation importedLocation = (RepositoryLocation)((Pair)entry.getValue()).getFirst();
                M2Model importedModel = (M2Model)((Pair)entry.getValue()).getSecond();
                this.loadModel(modelMap, loadedModels, importedModel, importedLocation);
            }
        }
        int n = modelsAfterCnt = (modelsAfter = this.dictionaryDAO.getModels()) != null ? modelsAfter.size() : 0;
        if (logger.isDebugEnabled()) {
            String string = this.tenantAdminService.getCurrentUserDomain();
            logger.debug((Object)("Model count: before=" + modelsBeforeCnt + ", load/update=" + loadedModels.size() + ", after=" + modelsAfterCnt + " in " + (System.currentTimeMillis() - startTime) + " msecs [" + Thread.currentThread() + "] " + (string.equals("") ? "" : " (Tenant: " + string + ")")));
        }
    }

    public void afterDictionaryInit() {
    }

    public void afterDictionaryDestroy() {
    }

    @Override
    public void initMessages() {
        if (this.repositoryMessagesLocations != null) {
            for (RepositoryLocation repositoryLocation : this.repositoryMessagesLocations) {
                StoreRef storeRef = repositoryLocation.getStoreRef();
                if (!this.nodeService.exists(storeRef)) {
                    logger.warn((Object)("StoreRef '" + storeRef + "' does not exist"));
                    continue;
                }
                if (repositoryLocation.getQueryLanguage().equals("path")) {
                    List<NodeRef> nodeRefs = this.getNodes(storeRef, repositoryLocation, ContentModel.TYPE_CONTENT);
                    if (nodeRefs.size() <= 0) continue;
                    ArrayList<String> resourceBundleBaseNames = new ArrayList<String>();
                    for (NodeRef messageResource : nodeRefs) {
                        String resourceName = (String)((Object)this.nodeService.getProperty(messageResource, ContentModel.PROP_NAME));
                        String bundleBaseName = this.messageService.getBaseBundleName(resourceName);
                        if (resourceBundleBaseNames.contains(bundleBaseName)) continue;
                        resourceBundleBaseNames.add(bundleBaseName);
                    }
                    continue;
                }
                logger.error((Object)("Unsupported query language for messages location: " + repositoryLocation.getQueryLanguage()));
            }
        }
    }

    public List<NodeRef> getModelRefs() {
        ArrayList<NodeRef> modelRefs = new ArrayList<NodeRef>();
        for (RepositoryLocation repositoryLocation : this.repositoryModelsLocations) {
            StoreRef storeRef = repositoryLocation.getStoreRef();
            if (!this.nodeService.exists(storeRef)) {
                logger.warn((Object)("StoreRef '" + storeRef + "' does not exist"));
                continue;
            }
            if (repositoryLocation.getQueryLanguage().equals("path")) {
                List<NodeRef> nodeRefs = this.getNodes(storeRef, repositoryLocation, ContentModel.TYPE_DICTIONARY_MODEL);
                if (nodeRefs.size() <= 0) continue;
                for (NodeRef dictionaryModel : nodeRefs) {
                    try {
                        if (this.nodeService.hasAspect(dictionaryModel, ContentModel.ASPECT_WORKING_COPY) || this.nodeService.hasAspect(dictionaryModel, ContentModel.ASPECT_ARCHIVED)) continue;
                        modelRefs.add(dictionaryModel);
                    }
                    catch (InvalidNodeRefException inre) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("getModelRefs: " + (Object)((Object)inre) + " (assume concurrently deleted)"));
                    }
                }
                continue;
            }
            logger.error((Object)("Unsupported query language for models location: " + repositoryLocation.getQueryLanguage()));
        }
        return modelRefs;
    }

    protected List<NodeRef> getNodes(StoreRef storeRef, RepositoryLocation repositoryLocation, QName nodeType) {
        ArrayList<Object> nodeRefs = new ArrayList<NodeRef>();
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        String[] pathElements = repositoryLocation.getPathElements();
        NodeRef folderNodeRef = rootNodeRef;
        if (pathElements.length > 0) {
            folderNodeRef = this.resolveQNamePath(rootNodeRef, pathElements);
        }
        if (folderNodeRef != null) {
            HashSet<QName> types = new HashSet<QName>(1);
            types.add(nodeType);
            List childAssocRefs = this.nodeService.getChildAssocs(folderNodeRef, types);
            if (childAssocRefs.size() > 0) {
                nodeRefs = new ArrayList(childAssocRefs.size());
                for (ChildAssociationRef childAssocRef : childAssocRefs) {
                    nodeRefs.add(childAssocRef.getChildRef());
                }
            }
        }
        return nodeRefs;
    }

    private void loadModel(Map<String, Pair<RepositoryLocation, M2Model>> modelMap, List<String> loadedModels, M2Model model, RepositoryLocation modelLocation) {
        String modelName = model.getName();
        if (!loadedModels.contains(modelName)) {
            for (M2Namespace importNamespace : model.getImports()) {
                Pair<RepositoryLocation, M2Model> entry = modelMap.get(importNamespace.getUri());
                if (entry == null) continue;
                RepositoryLocation importedLocation = (RepositoryLocation)entry.getFirst();
                M2Model importedModel = (M2Model)entry.getSecond();
                this.loadModel(modelMap, loadedModels, importedModel, importedLocation);
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loading model: " + modelName + " (from [" + modelLocation.getStoreRef() + "]" + modelLocation.getPath() + ")"));
                }
                this.dictionaryDAO.putModel(model);
                loadedModels.add(modelName);
            }
            catch (AlfrescoRuntimeException e) {
                logger.warn((Object)("Failed to load model '" + modelName + "' : " + (Object)((Object)e)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public M2Model createM2Model(NodeRef nodeRef) {
        M2Model model = null;
        ContentReader contentReader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        if (contentReader == null) return model;
        if (contentReader instanceof EmptyContentReader) {
            logger.error((Object)("Failed to create model (due to EmptyContentReader): " + nodeRef));
            return model;
        }
        InputStream is = null;
        try {
            is = contentReader.getContentInputStream();
            model = M2Model.createModel((InputStream)is);
            Object var6_5 = null;
            if (is == null) return model;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                logger.error((Object)("Failed to close input stream for " + nodeRef));
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            logger.error((Object)("Failed to close input stream for " + nodeRef));
            return model;
        }
        is.close();
        return model;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.register();
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void register() {
        this.dictionaryDAO.destroy();
        this.dictionaryDAO.register((DictionaryListener)this);
        this.messageService.register(this);
        if (this.tenantAdminService.isEnabled()) {
            this.tenantAdminService.register(this);
            this.tenantAdminService.register(this.messageService);
        }
    }

    protected void unregister() {
        if (this.tenantAdminService.isEnabled()) {
            this.tenantAdminService.unregister(this);
            this.tenantAdminService.unregister(this.messageService);
        }
    }

    protected NodeRef resolveQNamePath(NodeRef rootNodeRef, String[] pathPrefixQNameStrings) {
        if (pathPrefixQNameStrings.length == 0) {
            throw new IllegalArgumentException("Path array is empty");
        }
        NodeRef parentNodeRef = rootNodeRef;
        for (int i = 0; i < pathPrefixQNameStrings.length; ++i) {
            String pathPrefixQNameString = pathPrefixQNameStrings[i];
            QName pathQName = null;
            if (this.tenantAdminService.isEnabled()) {
                String[] parts = QName.splitPrefixedQName((String)pathPrefixQNameString);
                if (parts.length == 2 && parts[0].equals("app")) {
                    String pathUriQNameString = new StringBuilder(64).append('{').append("http://www.alfresco.org/model/application/1.0").append('}').append(parts[1]).toString();
                    pathQName = QName.createQName((String)pathUriQNameString);
                } else {
                    pathQName = QName.createQName((String)pathPrefixQNameString, (NamespacePrefixResolver)this.namespaceService);
                }
            } else {
                pathQName = QName.createQName((String)pathPrefixQNameString, (NamespacePrefixResolver)this.namespaceService);
            }
            List childAssocRefs = this.nodeService.getChildAssocs(parentNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)pathQName);
            if (childAssocRefs.size() != 1) {
                return null;
            }
            parentNodeRef = ((ChildAssociationRef)childAssocRefs.get(0)).getChildRef();
        }
        return parentNodeRef;
    }
}

