/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.discussion.cannedqueries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.discussion.cannedqueries.GetDiscussionTopcisWithPostsCannedQueryParams;
import org.alfresco.repo.discussion.cannedqueries.NodeWithChildrenEntity;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDiscussionTopcisWithPostsCannedQuery
extends AbstractCannedQueryPermissions<NodeWithChildrenEntity> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String QUERY_NAMESPACE = "alfresco.query.discussion";
    private static final String QUERY_SELECT_GET_NODES = "select_GetDiscussionTopcisWithPosts";
    private final CannedQueryDAO cannedQueryDAO;

    public GetDiscussionTopcisWithPostsCannedQuery(CannedQueryDAO cannedQueryDAO, MethodSecurityBean<NodeWithChildrenEntity> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        this.cannedQueryDAO = cannedQueryDAO;
    }

    protected List<NodeWithChildrenEntity> queryAndFilter(CannedQueryParameters parameters) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        Object paramBeanObj = parameters.getParameterBean();
        if (paramBeanObj == null) {
            throw new NullPointerException("Null GetChildrenAuditable query params");
        }
        GetDiscussionTopcisWithPostsCannedQueryParams paramBean = (GetDiscussionTopcisWithPostsCannedQueryParams)paramBeanObj;
        boolean filterByTopicCreatedDate = paramBean.getTopicCreatedAfter() != null;
        boolean filterByPostCreatedDate = paramBean.getPostCreatedAfter() != null;
        List results = this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_NODES, paramBean, 0, Integer.MAX_VALUE);
        ArrayList<NodeWithChildrenEntity> filtered = new ArrayList<NodeWithChildrenEntity>(results.size());
        for (NodeWithChildrenEntity result : results) {
            ArrayList<NodeWithChildrenEntity.NameAndCreatedAt> wantedPosts;
            Date createdDate;
            if (filterByTopicCreatedDate && (createdDate = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)result.getCreatedDate())).before(paramBean.getTopicCreatedAfter())) continue;
            if (filterByPostCreatedDate) {
                wantedPosts = new ArrayList<NodeWithChildrenEntity.NameAndCreatedAt>();
                for (NodeWithChildrenEntity.NameAndCreatedAt post : result.getChildren()) {
                    Date createdDate2 = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)post.getCreatedAt());
                    if (createdDate2.before(paramBean.getPostCreatedAfter())) continue;
                    wantedPosts.add(post);
                }
                result.setChildren(wantedPosts);
            }
            if (paramBean.getExcludePrimaryPost()) {
                wantedPosts = new ArrayList();
                for (NodeWithChildrenEntity.NameAndCreatedAt post : result.getChildren()) {
                    if (post.getName().equals(result.getName())) continue;
                    wantedPosts.add(post);
                }
                result.setChildren(wantedPosts);
            }
            if (result.getChildren().size() == 0) continue;
            filtered.add(result);
        }
        Collections.sort(filtered, new Comparator<NodeWithChildrenEntity>(){

            @Override
            public int compare(NodeWithChildrenEntity o1, NodeWithChildrenEntity o2) {
                int res = o2.getChildren().size() - o1.getChildren().size();
                if (res == 0) {
                    res = o2.getCreatedDate().compareTo(o1.getCreatedDate());
                }
                return res;
            }
        });
        if (start != null) {
            this.logger.debug((Object)("Base query: " + filtered.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return filtered;
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }
}

