/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.NullCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.avm.AVMVersionLayeredNodeEntryEntity;
import org.alfresco.repo.domain.avm.AVMVersionRootDAO;
import org.alfresco.repo.domain.avm.AVMVersionRootEntity;
import org.alfresco.util.Pair;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAVMVersionRootDAOImpl
implements AVMVersionRootDAO {
    private SimpleCache<Serializable, Serializable> vrEntityCache = new NullCache<Serializable, Serializable>();

    public void setVersionRootEntityCache(SimpleCache<Serializable, Serializable> vrEntityCache) {
        this.vrEntityCache = vrEntityCache;
    }

    @Override
    public AVMVersionRootEntity createVersionRoot(long storeId, long rootNodeId, int version, String creator, String tag, String description) {
        ParameterCheck.mandatory((String)"creator", (Object)creator);
        AVMVersionRootEntity vrEntity = new AVMVersionRootEntity();
        vrEntity.setStoreId(storeId);
        vrEntity.setRootNodeId(rootNodeId);
        vrEntity.setVersion(version);
        vrEntity.setCreator(creator);
        vrEntity.setCreatedDate(new Date().getTime());
        vrEntity.setTag(tag);
        vrEntity.setDescription(description);
        vrEntity = this.createVersionRootEntity(vrEntity);
        this.vrEntityCache.put((Serializable)new Pair((Object)storeId, (Object)version), (Object)vrEntity.getId());
        this.vrEntityCache.put((Serializable)vrEntity.getId(), (Object)vrEntity);
        return vrEntity;
    }

    @Override
    public void updateVersionRoot(AVMVersionRootEntity vrEntity) {
        ParameterCheck.mandatory((String)"vrEntity", (Object)vrEntity);
        ParameterCheck.mandatory((String)"vrEntity.storeId", (Object)vrEntity.getStoreId());
        ParameterCheck.mandatory((String)"vrEntity.id", (Object)vrEntity.getId());
        ParameterCheck.mandatory((String)"vrEntity.version", (Object)vrEntity.getVersion());
        int updated = this.updateVersionRootEntity(vrEntity);
        if (updated != 1) {
            throw new ConcurrencyFailureException("Incorrect number of rows affected for updateVersionRoot: " + vrEntity + ": expected 1, actual " + updated);
        }
        this.vrEntityCache.put((Serializable)new Pair((Object)vrEntity.getStoreId(), (Object)vrEntity.getVersion()), (Object)vrEntity.getId());
        this.vrEntityCache.put((Serializable)vrEntity.getId(), (Object)vrEntity);
    }

    @Override
    public List<AVMVersionRootEntity> getAllInStore(long storeId) {
        return this.getAllVersionRootEntitiesByStoreId(storeId);
    }

    protected AVMVersionRootEntity getByID(long vrEntityId) {
        AVMVersionRootEntity vrEntity = (AVMVersionRootEntity)this.vrEntityCache.get((Serializable)Long.valueOf(vrEntityId));
        if (vrEntity != null) {
            return vrEntity;
        }
        vrEntity = this.getVersionRootEntityById(vrEntityId);
        if (vrEntity != null) {
            this.vrEntityCache.put((Serializable)new Pair((Object)vrEntity.getStoreId(), (Object)vrEntity.getVersion()), (Object)vrEntity.getId());
            this.vrEntityCache.put((Serializable)vrEntity.getId(), (Object)vrEntity);
        }
        return vrEntity;
    }

    @Override
    public AVMVersionRootEntity getByVersionID(long storeId, int version) {
        Long vrEntityId = (Long)this.vrEntityCache.get((Serializable)new Pair((Object)storeId, (Object)version));
        AVMVersionRootEntity vrEntity = null;
        if (vrEntityId != null && (vrEntity = (AVMVersionRootEntity)this.vrEntityCache.get((Serializable)vrEntityId)) != null) {
            return vrEntity;
        }
        vrEntity = this.getVersionRootEntityByStoreVersion(storeId, version);
        if (vrEntity != null) {
            this.vrEntityCache.put((Serializable)new Pair((Object)vrEntity.getStoreId(), (Object)vrEntity.getVersion()), (Object)vrEntity.getId());
            this.vrEntityCache.put((Serializable)vrEntity.getId(), (Object)vrEntity);
        }
        return vrEntity;
    }

    @Override
    public AVMVersionRootEntity getByRoot(long rootNodeId) {
        return this.getVersionRootEntityByRootNodeId(rootNodeId);
    }

    @Override
    public List<AVMVersionRootEntity> getByDates(long storeId, Date from, Date to) {
        if (from != null && to != null) {
            return this.getVersionRootEntitiesByBetween(storeId, from.getTime(), to.getTime());
        }
        if (from == null && to != null) {
            return this.getVersionRootEntitiesByTo(storeId, to.getTime());
        }
        if (to == null && from != null) {
            return this.getVersionRootEntitiesByFrom(storeId, from.getTime());
        }
        throw new AlfrescoRuntimeException("getByDates: from and to are both null for store id: " + storeId);
    }

    @Override
    public AVMVersionRootEntity getMaxVersion(long storeId) {
        return this.getVersionRootEntityMaxVersion(storeId);
    }

    @Override
    public Long getMaxVersionID(long storeId) {
        return this.getVersionRootEntityMaxVersionId(storeId);
    }

    @Override
    public void deleteVersionRoot(long vrEntityId) {
        AVMVersionRootEntity vrEntity = this.getByID(vrEntityId);
        if (vrEntity == null) {
            return;
        }
        int deleted = this.deleteVersionRootEntity(vrEntityId);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("AVMVersionRoot with ID " + vrEntityId + " no longer exists");
        }
        this.vrEntityCache.remove((Serializable)new Pair((Object)vrEntity.getStoreId(), (Object)vrEntity.getVersion()));
        this.vrEntityCache.remove((Serializable)Long.valueOf(vrEntityId));
    }

    protected abstract AVMVersionRootEntity createVersionRootEntity(AVMVersionRootEntity var1);

    protected abstract int updateVersionRootEntity(AVMVersionRootEntity var1);

    protected abstract int deleteVersionRootEntity(long var1);

    protected abstract AVMVersionRootEntity getVersionRootEntityMaxVersion(long var1);

    protected abstract Long getVersionRootEntityMaxVersionId(long var1);

    protected abstract AVMVersionRootEntity getVersionRootEntityById(long var1);

    protected abstract AVMVersionRootEntity getVersionRootEntityByStoreVersion(long var1, int var3);

    protected abstract AVMVersionRootEntity getVersionRootEntityByRootNodeId(long var1);

    protected abstract List<AVMVersionRootEntity> getAllVersionRootEntitiesByStoreId(long var1);

    protected abstract List<AVMVersionRootEntity> getVersionRootEntitiesByTo(long var1, long var3);

    protected abstract List<AVMVersionRootEntity> getVersionRootEntitiesByFrom(long var1, long var3);

    protected abstract List<AVMVersionRootEntity> getVersionRootEntitiesByBetween(long var1, long var3, long var5);

    @Override
    public AVMVersionLayeredNodeEntryEntity createVersionLayeredNodeEntry(long versionRootId, String md5sum, String path) {
        ParameterCheck.mandatory((String)"md5sum", (Object)md5sum);
        ParameterCheck.mandatory((String)"path", (Object)path);
        return this.createVersionLayeredNodeEntryEntity(versionRootId, md5sum, path);
    }

    @Override
    public void deleteVersionLayeredNodeEntries(long versionRootId) {
        List<AVMVersionLayeredNodeEntryEntity> vlneEntities = this.getVersionLayeredNodeEntries(versionRootId);
        if (vlneEntities.size() == 0) {
            return;
        }
        int deleted = this.deleteVersionLayeredNodeEntryEntities(versionRootId);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("AVMVersionLayeredNodeEntries with version root id " + versionRootId + " no longer exist");
        }
    }

    @Override
    public List<AVMVersionLayeredNodeEntryEntity> getVersionLayeredNodeEntries(long versionRootId) {
        return this.getVersionLayeredNodeEntryEntities(versionRootId);
    }

    protected abstract AVMVersionLayeredNodeEntryEntity createVersionLayeredNodeEntryEntity(long var1, String var3, String var4);

    protected abstract int deleteVersionLayeredNodeEntryEntities(long var1);

    protected abstract List<AVMVersionLayeredNodeEntryEntity> getVersionLayeredNodeEntryEntities(long var1);

    protected abstract List<AVMVersionRootEntity> getVersionRootEntitiesByVersionsTo(long var1, long var3);

    protected abstract List<AVMVersionRootEntity> getVersionRootEntitiesByVersionsFrom(long var1, long var3);

    protected abstract List<AVMVersionRootEntity> getVersionRootEntitiesByVersionsBetween(long var1, long var3, long var5);

    @Override
    public List<AVMVersionRootEntity> getByVersionsTo(long id, int version) {
        return this.getVersionRootEntitiesByVersionsTo(id, version);
    }

    @Override
    public List<AVMVersionRootEntity> getByVersionsFrom(long id, int version) {
        return this.getVersionRootEntitiesByVersionsFrom(id, version);
    }

    @Override
    public List<AVMVersionRootEntity> getByVersionsBetween(long id, int startVersion, int endVersion) {
        return this.getVersionRootEntitiesByVersionsBetween(id, startVersion, endVersion);
    }
}

