/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.control.ibatis;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.alfresco.repo.domain.control.AbstractControlDAOImpl;
import org.mybatis.spring.SqlSessionTemplate;

public class ControlDAOImpl
extends AbstractControlDAOImpl {
    protected SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    public void startBatch() {
    }

    public void executeBatch() {
    }

    public int setTransactionIsolationLevel(int isolationLevel) {
        Connection connection = this.template.getConnection();
        if (connection == null) {
            throw new NullPointerException("There is no current connection");
        }
        try {
            if (!connection.getMetaData().supportsTransactionIsolationLevel(isolationLevel)) {
                throw new IllegalStateException("Transaction isolation level not supported: " + isolationLevel);
            }
            int isolationLevelWas = connection.getTransactionIsolation();
            connection.setTransactionIsolation(isolationLevel);
            return isolationLevelWas;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to set transaction isolation level: " + isolationLevel, e);
        }
    }

    public static class PostgreSQL
    extends ControlDAOImpl {
        public Savepoint createSavepoint(String savepoint) {
            try {
                Connection connection = this.template.getConnection();
                return connection.setSavepoint(savepoint);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to create SAVEPOINT: " + savepoint, e);
            }
        }

        public void rollbackToSavepoint(Savepoint savepoint) {
            try {
                Connection connection = this.template.getConnection();
                connection.rollback(savepoint);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to create SAVEPOINT: " + savepoint, e);
            }
        }

        public void releaseSavepoint(Savepoint savepoint) {
            try {
                Connection connection = this.template.getConnection();
                connection.releaseSavepoint(savepoint);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to create SAVEPOINT: " + savepoint, e);
            }
        }
    }
}

