/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.mimetype.ibatis;

import org.alfresco.repo.domain.mimetype.AbstractMimetypeDAOImpl;
import org.alfresco.repo.domain.mimetype.MimetypeEntity;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.dao.DataIntegrityViolationException;

public class MimetypeDAOImpl
extends AbstractMimetypeDAOImpl {
    private static final String SELECT_MIMETYPE_BY_ID = "alfresco.content.select_MimetypeById";
    private static final String SELECT_MIMETYPE_BY_KEY = "alfresco.content.select_MimetypeByKey";
    private static final String INSERT_MIMETYPE = "alfresco.content.insert.insert_Mimetype";
    private static final String UPDATE_MIMETYPE = "alfresco.content.update_Mimetype";
    private SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    protected MimetypeEntity getMimetypeEntity(Long id) {
        MimetypeEntity mimetypeEntity = new MimetypeEntity();
        mimetypeEntity.setId(id);
        mimetypeEntity = (MimetypeEntity)this.template.selectOne(SELECT_MIMETYPE_BY_ID, (Object)mimetypeEntity);
        return mimetypeEntity;
    }

    protected MimetypeEntity getMimetypeEntity(String mimetype) {
        MimetypeEntity mimetypeEntity = new MimetypeEntity();
        mimetypeEntity.setMimetype(mimetype == null ? null : mimetype.toLowerCase());
        mimetypeEntity = (MimetypeEntity)this.template.selectOne(SELECT_MIMETYPE_BY_KEY, (Object)mimetypeEntity);
        return mimetypeEntity;
    }

    protected MimetypeEntity createMimetypeEntity(String mimetype) {
        MimetypeEntity mimetypeEntity = new MimetypeEntity();
        mimetypeEntity.setVersion(MimetypeEntity.CONST_LONG_ZERO);
        mimetypeEntity.setMimetype(mimetype == null ? null : mimetype.toLowerCase());
        this.template.insert(INSERT_MIMETYPE, (Object)mimetypeEntity);
        return mimetypeEntity;
    }

    protected int updateMimetypeEntity(Long id, String newMimetype) {
        MimetypeEntity mimetypeEntity = this.getMimetypeEntity(id);
        if (mimetypeEntity == null) {
            throw new DataIntegrityViolationException("Cannot update mimetype as ID doesn't exist: " + id);
        }
        mimetypeEntity.incrementVersion();
        mimetypeEntity.setMimetype(newMimetype);
        return this.template.update(UPDATE_MIMETYPE, (Object)mimetypeEntity);
    }
}

