/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node.ibatis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.alfresco.ibatis.IdsEntity;
import org.alfresco.repo.domain.node.AbstractNodeDAOImpl;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.ChildPropertyEntity;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeAspectsEntity;
import org.alfresco.repo.domain.node.NodeAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.domain.node.NodePropertyEntity;
import org.alfresco.repo.domain.node.NodePropertyKey;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.domain.node.NodeUpdateEntity;
import org.alfresco.repo.domain.node.NodeVersionKey;
import org.alfresco.repo.domain.node.PrimaryChildrenAclUpdateEntity;
import org.alfresco.repo.domain.node.ServerEntity;
import org.alfresco.repo.domain.node.StoreEntity;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.domain.node.TransactionEntity;
import org.alfresco.repo.domain.node.TransactionQueryEntity;
import org.alfresco.repo.domain.node.ibatis.NodeBatchLoadEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDAOImpl
extends AbstractNodeDAOImpl {
    private static final String SELECT_SERVER_BY_IPADDRESS = "alfresco.node.select_ServerByIpAddress";
    private static final String INSERT_SERVER = "alfresco.node.insert.insert_Server";
    private static final String INSERT_TRANSACTION = "alfresco.node.insert.insert_Transaction";
    private static final String UPDATE_TRANSACTION_COMMIT_TIME = "alfresco.node.update_TransactionCommitTime";
    private static final String DELETE_TRANSACTION_BY_ID = "alfresco.node.delete_TransactionById";
    private static final String INSERT_STORE = "alfresco.node.insert.insert_Store";
    private static final String UPDATE_STORE_ROOT = "alfresco.node.update_StoreRoot";
    private static final String UPDATE_STORE = "alfresco.node.update_Store";
    private static final String SELECT_STORE_ALL = "alfresco.node.select_StoreAll";
    private static final String SELECT_STORE_ROOT_NODE_BY_ID = "alfresco.node.select_StoreRootNodeById";
    private static final String SELECT_STORE_ROOT_NODE_BY_REF = "alfresco.node.select_StoreRootNodeByRef";
    private static final String INSERT_NODE = "alfresco.node.insert.insert_Node";
    private static final String UPDATE_NODE = "alfresco.node.update_Node";
    private static final String UPDATE_NODE_BULK_TOUCH = "alfresco.node.update_NodeBulkTouch";
    private static final String DELETE_NODE_BY_ID = "alfresco.node.delete_NodeById";
    private static final String DELETE_NODES_BY_TXN_COMMIT_TIME = "alfresco.node.delete_NodesByTxnCommitTime";
    private static final String SELECT_NODE_BY_ID = "alfresco.node.select_NodeById";
    private static final String SELECT_NODE_BY_NODEREF = "alfresco.node.select_NodeByNodeRef";
    private static final String SELECT_NODES_BY_UUIDS = "alfresco.node.select_NodesByUuids";
    private static final String SELECT_NODES_BY_IDS = "alfresco.node.select_NodesByIds";
    private static final String SELECT_NODE_PROPERTIES = "alfresco.node.select_NodeProperties";
    private static final String SELECT_PROPERTIES_BY_TYPES = "alfresco.node.select_PropertiesByTypes";
    private static final String SELECT_NODE_ASPECTS = "alfresco.node.select_NodeAspects";
    private static final String INSERT_NODE_PROPERTY = "alfresco.node.insert.insert_NodeProperty";
    private static final String UPDATE_PRIMARY_CHILDREN_SHARED_ACL = "alfresco.node.update.update_PrimaryChildrenSharedAcl";
    private static final String INSERT_NODE_ASPECT = "alfresco.node.insert.insert_NodeAspect";
    private static final String DELETE_NODE_ASPECTS = "alfresco.node.delete_NodeAspects";
    private static final String DELETE_NODE_PROPERTIES = "alfresco.node.delete_NodeProperties";
    private static final String SELECT_NODES_WITH_ASPECT_IDS = "alfresco.node.select_NodesWithAspectIds";
    private static final String INSERT_NODE_ASSOC = "alfresco.node.insert.insert_NodeAssoc";
    private static final String UPDATE_NODE_ASSOC = "alfresco.node.update_NodeAssoc";
    private static final String DELETE_NODE_ASSOC = "alfresco.node.delete_NodeAssoc";
    private static final String DELETE_NODE_ASSOCS_TO_AND_FROM = "alfresco.node.delete_NodeAssocsToAndFrom";
    private static final String DELETE_NODE_ASSOCS = "alfresco.node.delete_NodeAssocs";
    private static final String SELECT_NODE_ASSOCS_BY_SOURCE = "alfresco.node.select_NodeAssocsBySource";
    private static final String SELECT_NODE_ASSOCS_BY_TARGET = "alfresco.node.select_NodeAssocsByTarget";
    private static final String SELECT_NODE_ASSOC_BY_ID = "alfresco.node.select_NodeAssocById";
    private static final String SELECT_NODE_ASSOCS_MAX_INDEX = "alfresco.node.select_NodeAssocsMaxId";
    private static final String SELECT_CHILD_NODE_IDS = "alfresco.node.select.children.select_ChildNodeIds_Limited";
    private static final String SELECT_NODE_PRIMARY_CHILD_ACLS = "alfresco.node.select_NodePrimaryChildAcls";
    private static final String INSERT_CHILD_ASSOC = "alfresco.node.insert.insert_ChildAssoc";
    private static final String DELETE_CHILD_ASSOC_BY_ID = "alfresco.node.delete_ChildAssocById";
    private static final String UPDATE_CHILD_ASSOCS_INDEX = "alfresco.node.update_ChildAssocsIndex";
    private static final String UPDATE_CHILD_ASSOCS_UNIQUE_NAME = "alfresco.node.update_ChildAssocsUniqueName";
    private static final String DELETE_CHILD_ASSOCS_TO_AND_FROM = "alfresco.node.delete_ChildAssocsToAndFrom";
    private static final String SELECT_CHILD_ASSOC_BY_ID = "alfresco.node.select_ChildAssocById";
    private static final String SELECT_CHILD_ASSOCS_BY_PROPERTY_VALUE = "alfresco.node.select_ChildAssocsByPropertyValue";
    private static final String SELECT_CHILD_ASSOCS_OF_PARENT = "alfresco.node.select_ChildAssocsOfParent";
    private static final String SELECT_CHILD_ASSOCS_OF_PARENT_LIMITED = "alfresco.node.select.children.select_ChildAssocsOfParent_Limited";
    private static final String SELECT_CHILD_ASSOC_OF_PARENT_BY_NAME = "alfresco.node.select_ChildAssocOfParentByName";
    private static final String SELECT_CHILD_ASSOCS_OF_PARENT_WITHOUT_PARENT_ASSOCS_OF_TYPE = "alfresco.node.select_ChildAssocsOfParentWithoutParentAssocsOfType";
    private static final String SELECT_PARENT_ASSOCS_OF_CHILD = "alfresco.node.select_ParentAssocsOfChild";
    private static final String UPDATE_PARENT_ASSOCS_OF_CHILD = "alfresco.node.update_ParentAssocsOfChild";
    private static final String DELETE_SUBSCRIPTIONS = "alfresco.node.delete_NodeSubscriptions";
    private static final String UPDATE_MOVE_PARENT_ASSOCS = "alfresco.node.update_MoveParentAssocs";
    private static final String UPDATE_MOVE_CHILD_ASSOCS = "alfresco.node.update_MoveChildAssocs";
    private static final String UPDATE_MOVE_SOURCE_ASSOCS = "alfresco.node.update_MoveSourceAssocs";
    private static final String UPDATE_MOVE_TARGET_ASSOCS = "alfresco.node.update_MoveTargetAssocs";
    private static final String UPDATE_MOVE_PROPERTIES = "alfresco.node.update_MoveProperties";
    private static final String UPDATE_MOVE_ASPECTS = "alfresco.node.update_MoveAspects";
    private static final String SELECT_TXN_LAST = "alfresco.node.select_TxnLast";
    private static final String SELECT_TXN_NODES = "alfresco.node.select_TxnNodes";
    private static final String SELECT_TXNS = "alfresco.node.select_Txns";
    private static final String SELECT_TXN_COUNT = "alfresco.node.select_TxnCount";
    private static final String SELECT_TXN_NODE_COUNT = "alfresco.node.select_TxnNodeCount";
    private static final String SELECT_TXNS_UNUSED = "alfresco.node.select_TxnsUnused";
    private static final String SELECT_TXN_MIN_COMMIT_TIME = "alfresco.node.select_TxnMinCommitTime";
    private static final String SELECT_TXN_MAX_COMMIT_TIME = "alfresco.node.select_TxnMaxCommitTime";
    private QNameDAO qnameDAO;
    private DictionaryService dictionaryService;
    private SqlSessionTemplate template;

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
        super.setQnameDAO(qnameDAO);
    }

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
        super.setDictionaryService(dictionaryService);
    }

    public void startBatch() {
    }

    public void executeBatch() {
    }

    @Override
    protected ServerEntity selectServer(String ipAddress) {
        ServerEntity entity = new ServerEntity();
        entity.setIpAddress(ipAddress);
        List results = this.template.selectList(SELECT_SERVER_BY_IPADDRESS, (Object)entity);
        for (ServerEntity serverEntity : results) {
            if (!serverEntity.getIpAddress().equalsIgnoreCase(ipAddress)) continue;
            return serverEntity;
        }
        return null;
    }

    @Override
    protected Long insertServer(String ipAddress) {
        ServerEntity entity = new ServerEntity();
        entity.setVersion(1L);
        entity.setIpAddress(ipAddress);
        this.template.insert(INSERT_SERVER, (Object)entity);
        return entity.getId();
    }

    @Override
    protected Long insertTransaction(Long serverId, String changeTxnId, Long commitTimeMs) {
        ServerEntity server = new ServerEntity();
        server.setId(serverId);
        TransactionEntity transaction = new TransactionEntity();
        transaction.setServer(server);
        transaction.setVersion(1L);
        transaction.setChangeTxnId(changeTxnId);
        transaction.setCommitTimeMs(commitTimeMs);
        this.template.insert(INSERT_TRANSACTION, (Object)transaction);
        return transaction.getId();
    }

    @Override
    protected int updateTransaction(Long txnId, Long commitTimeMs) {
        TransactionEntity transaction = new TransactionEntity();
        transaction.setId(txnId);
        transaction.setCommitTimeMs(commitTimeMs);
        return this.template.update(UPDATE_TRANSACTION_COMMIT_TIME, (Object)transaction);
    }

    @Override
    protected int deleteTransaction(Long txnId) {
        TransactionEntity transaction = new TransactionEntity();
        transaction.setId(txnId);
        return this.template.delete(DELETE_TRANSACTION_BY_ID, (Object)transaction);
    }

    @Override
    protected List<StoreEntity> selectAllStores() {
        return this.template.selectList(SELECT_STORE_ALL);
    }

    @Override
    protected NodeEntity selectStoreRootNode(Long storeId) {
        StoreEntity store = new StoreEntity();
        store.setId(storeId);
        return (NodeEntity)this.template.selectOne(SELECT_STORE_ROOT_NODE_BY_ID, (Object)store);
    }

    @Override
    protected NodeEntity selectStoreRootNode(StoreRef storeRef) {
        StoreEntity store = new StoreEntity();
        store.setProtocol(storeRef.getProtocol());
        store.setIdentifier(storeRef.getIdentifier());
        return (NodeEntity)this.template.selectOne(SELECT_STORE_ROOT_NODE_BY_REF, (Object)store);
    }

    @Override
    protected Long insertStore(StoreEntity store) {
        store.setVersion(1L);
        this.template.insert(INSERT_STORE, (Object)store);
        return store.getId();
    }

    @Override
    protected int updateStoreRoot(StoreEntity store) {
        return this.template.update(UPDATE_STORE_ROOT, (Object)store);
    }

    @Override
    protected int updateStore(StoreEntity store) {
        return this.template.update(UPDATE_STORE, (Object)store);
    }

    @Override
    protected Long insertNode(NodeEntity node) {
        node.setVersion(1L);
        this.template.insert(INSERT_NODE, (Object)node);
        return node.getId();
    }

    @Override
    protected int updateNode(NodeUpdateEntity nodeUpdate) {
        nodeUpdate.incrementVersion();
        return this.template.update(UPDATE_NODE, (Object)nodeUpdate);
    }

    @Override
    protected int updateNodes(Long txnId, List<Long> nodeIds) {
        if (nodeIds.size() == 0) {
            return 0;
        }
        IdsEntity ids = new IdsEntity();
        ids.setIdOne(txnId);
        ids.setIds(nodeIds);
        return this.template.update(UPDATE_NODE_BULK_TOUCH, (Object)ids);
    }

    @Override
    protected void updatePrimaryChildrenSharedAclId(Long txnId, Long primaryParentNodeId, Long optionalOldSharedAlcIdInAdditionToNull, Long newSharedAlcId) {
        PrimaryChildrenAclUpdateEntity primaryChildrenAclUpdateEntity = new PrimaryChildrenAclUpdateEntity();
        primaryChildrenAclUpdateEntity.setTxnId(txnId);
        primaryChildrenAclUpdateEntity.setPrimaryParentNodeId(primaryParentNodeId);
        primaryChildrenAclUpdateEntity.setOptionalOldSharedAclIdInAdditionToNull(optionalOldSharedAlcIdInAdditionToNull);
        primaryChildrenAclUpdateEntity.setNewSharedAclId(newSharedAlcId);
        this.template.update(UPDATE_PRIMARY_CHILDREN_SHARED_ACL, (Object)primaryChildrenAclUpdateEntity);
    }

    @Override
    protected int deleteNodeById(Long nodeId, boolean deletedOnly) {
        NodeEntity node = new NodeEntity();
        node.setId(nodeId);
        node.setDeleted(deletedOnly);
        return this.template.delete(DELETE_NODE_BY_ID, (Object)node);
    }

    @Override
    protected int deleteNodesByCommitTime(boolean deletedOnly, long maxTxnCommitTimeMs) {
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setDeletedNodes(Boolean.TRUE);
        query.setMaxCommitTime(maxTxnCommitTimeMs);
        return this.template.delete(DELETE_NODES_BY_TXN_COMMIT_TIME, (Object)query);
    }

    @Override
    protected NodeEntity selectNodeById(Long id, Boolean deleted) {
        NodeEntity node = new NodeEntity();
        node.setId(id);
        if (deleted != null) {
            node.setDeleted(deleted);
        }
        return (NodeEntity)this.template.selectOne(SELECT_NODE_BY_ID, (Object)node);
    }

    @Override
    protected NodeEntity selectNodeByNodeRef(NodeRef nodeRef, Boolean deleted) {
        StoreEntity store = new StoreEntity();
        StoreRef storeRef = nodeRef.getStoreRef();
        store.setProtocol(storeRef.getProtocol());
        store.setIdentifier(storeRef.getIdentifier());
        NodeEntity node = new NodeEntity();
        node.setStore(store);
        String uuid = nodeRef.getId();
        if (uuid.length() > 36) {
            return null;
        }
        node.setUuid(uuid);
        if (deleted != null) {
            node.setDeleted(deleted);
        }
        return (NodeEntity)this.template.selectOne(SELECT_NODE_BY_NODEREF, (Object)node);
    }

    @Override
    protected List<Node> selectNodesByUuids(Long storeId, SortedSet<String> uuids, Boolean deleted) {
        NodeBatchLoadEntity nodeBatchLoadEntity = new NodeBatchLoadEntity();
        nodeBatchLoadEntity.setStoreId(storeId);
        nodeBatchLoadEntity.setUuids(new ArrayList<String>(uuids));
        if (deleted != null) {
            nodeBatchLoadEntity.setDeleted(deleted);
        }
        return this.template.selectList(SELECT_NODES_BY_UUIDS, (Object)nodeBatchLoadEntity);
    }

    @Override
    protected List<Node> selectNodesByIds(SortedSet<Long> ids, Boolean deleted) {
        NodeBatchLoadEntity nodeBatchLoadEntity = new NodeBatchLoadEntity();
        nodeBatchLoadEntity.setIds(new ArrayList<Long>(ids));
        if (deleted != null) {
            nodeBatchLoadEntity.setDeleted(deleted);
        }
        return this.template.selectList(SELECT_NODES_BY_IDS, (Object)nodeBatchLoadEntity);
    }

    private Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> makePersistentPropertiesMap(List<NodePropertyEntity> rows) {
        HashMap<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> results = new HashMap<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>>(3);
        for (NodePropertyEntity row : rows) {
            Long nodeId = row.getNodeId();
            Long nodeVersion = row.getNodeVersion();
            if (nodeId == null || nodeVersion == null) {
                throw new RuntimeException("Expect results with a Node and Version: " + row);
            }
            NodeVersionKey nodeTxnKey = new NodeVersionKey(nodeId, nodeVersion);
            HashMap<NodePropertyKey, NodePropertyValue> props = (HashMap<NodePropertyKey, NodePropertyValue>)results.get(nodeTxnKey);
            if (props == null) {
                props = new HashMap<NodePropertyKey, NodePropertyValue>(17);
                results.put(nodeTxnKey, props);
            }
            props.put(row.getKey(), row.getValue());
        }
        return results;
    }

    private List<NodePropertyEntity> makePersistentRows(Long nodeId, Map<NodePropertyKey, NodePropertyValue> map) {
        ArrayList<NodePropertyEntity> rows = new ArrayList<NodePropertyEntity>(map.size());
        for (Map.Entry<NodePropertyKey, NodePropertyValue> entry : map.entrySet()) {
            NodePropertyEntity row = new NodePropertyEntity();
            row.setNodeId(nodeId);
            row.setKey(entry.getKey());
            row.setValue(entry.getValue());
            rows.add(row);
        }
        return rows;
    }

    @Override
    protected Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Set<Long> nodeIds) {
        if (nodeIds.size() == 0) {
            return Collections.emptyMap();
        }
        NodePropertyEntity prop = new NodePropertyEntity();
        prop.setNodeIds(new ArrayList<Long>(nodeIds));
        List rows = this.template.selectList(SELECT_NODE_PROPERTIES, (Object)prop);
        return this.makePersistentPropertiesMap(rows);
    }

    @Override
    protected Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Long nodeId) {
        return this.selectNodeProperties(nodeId, Collections.<Long>emptySet());
    }

    @Override
    protected Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Long nodeId, Set<Long> qnameIds) {
        NodePropertyEntity prop = new NodePropertyEntity();
        prop.setNodeId(nodeId);
        switch (qnameIds.size()) {
            case 0: {
                break;
            }
            case 1: {
                prop.setKey(new NodePropertyKey());
                prop.getKey().setQnameId(qnameIds.iterator().next());
                break;
            }
            default: {
                prop.setQnameIds(new ArrayList<Long>(qnameIds));
            }
        }
        List rows = this.template.selectList(SELECT_NODE_PROPERTIES, (Object)prop);
        return this.makePersistentPropertiesMap(rows);
    }

    @Override
    protected int deleteNodeProperties(Long nodeId, Set<Long> qnameIds) {
        NodePropertyEntity prop = new NodePropertyEntity();
        prop.setNodeId(nodeId);
        if (qnameIds != null) {
            if (qnameIds.isEmpty()) {
                return 0;
            }
            prop.setQnameIds(new ArrayList<Long>(qnameIds));
        }
        return this.template.delete(DELETE_NODE_PROPERTIES, (Object)prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deleteNodeProperties(Long nodeId, List<NodePropertyKey> propKeys) {
        Assert.notNull((Object)nodeId, (String)"Must have 'nodeId'");
        Assert.notNull((Object)nodeId, (String)"Must have 'propKeys'");
        if (propKeys.size() == 0) {
            return 0;
        }
        NodePropertyEntity prop = new NodePropertyEntity();
        prop.setNodeId(nodeId);
        this.startBatch();
        int count = 0;
        try {
            for (NodePropertyKey propKey : propKeys) {
                prop.setKey(propKey);
                count += this.template.delete(DELETE_NODE_PROPERTIES, (Object)prop);
            }
            Object var8_7 = null;
            this.executeBatch();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.executeBatch();
            throw throwable;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertNodeProperties(Long nodeId, Map<NodePropertyKey, NodePropertyValue> persistableProps) {
        if (persistableProps.isEmpty()) {
            return;
        }
        List<NodePropertyEntity> rows = this.makePersistentRows(nodeId, persistableProps);
        this.startBatch();
        try {
            for (NodePropertyEntity row : rows) {
                this.template.insert(INSERT_NODE_PROPERTY, (Object)row);
            }
            Object var7_6 = null;
            this.executeBatch();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.executeBatch();
            throw throwable;
        }
    }

    @Override
    protected Map<NodeVersionKey, Set<QName>> selectNodeAspects(Set<Long> nodeIds) {
        if (nodeIds.size() == 0) {
            return Collections.emptyMap();
        }
        NodeAspectsEntity aspects = new NodeAspectsEntity();
        aspects.setNodeIds(new ArrayList<Long>(nodeIds));
        List rows = this.template.selectList(SELECT_NODE_ASPECTS, (Object)aspects);
        HashMap<NodeVersionKey, Set<QName>> results = new HashMap<NodeVersionKey, Set<QName>>(rows.size() * 2);
        for (NodeAspectsEntity nodeAspectsEntity : rows) {
            Long nodeVersion;
            Long nodeId = nodeAspectsEntity.getNodeId();
            NodeVersionKey nodeVersionKey = new NodeVersionKey(nodeId, nodeVersion = nodeAspectsEntity.getNodeVersion());
            if (results.containsKey(nodeVersionKey)) {
                throw new IllegalStateException("Found existing key while querying for node aspects: " + nodeIds);
            }
            HashSet<Long> aspectIds = new HashSet<Long>(nodeAspectsEntity.getAspectQNameIds());
            Set<QName> aspectQNames = this.qnameDAO.convertIdsToQNames(aspectIds);
            results.put(nodeVersionKey, aspectQNames);
        }
        return results;
    }

    @Override
    protected void insertNodeAspect(Long nodeId, Long qnameId) {
        HashMap<String, Long> aspectParameters = new HashMap<String, Long>(5);
        aspectParameters.put("nodeId", nodeId);
        aspectParameters.put("qnameId", qnameId);
        this.template.insert(INSERT_NODE_ASPECT, aspectParameters);
    }

    @Override
    protected int deleteNodeAspects(Long nodeId, Set<Long> qnameIds) {
        NodeAspectsEntity nodeAspects = new NodeAspectsEntity();
        nodeAspects.setNodeId(nodeId);
        if (qnameIds != null && !qnameIds.isEmpty()) {
            nodeAspects.setAspectQNameIds(new ArrayList<Long>(qnameIds));
        }
        return this.template.delete(DELETE_NODE_ASPECTS, (Object)nodeAspects);
    }

    @Override
    protected void selectNodesWithAspects(List<Long> qnameIds, Long minNodeId, Long maxNodeId, final NodeDAO.NodeRefQueryCallback resultsCallback) {
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResult(ResultContext context) {
                NodeEntity entity = (NodeEntity)context.getResultObject();
                Pair nodePair = new Pair((Object)entity.getId(), (Object)entity.getNodeRef());
                resultsCallback.handle((Pair<Long, NodeRef>)nodePair);
            }
        };
        IdsEntity parameters = new IdsEntity();
        parameters.setIdOne(minNodeId);
        parameters.setIdTwo(maxNodeId);
        parameters.setIds(qnameIds);
        this.template.select(SELECT_NODES_WITH_ASPECT_IDS, (Object)parameters, resultHandler);
    }

    @Override
    protected Long insertNodeAssoc(Long sourceNodeId, Long targetNodeId, Long assocTypeQNameId, int assocIndex) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        assoc.setVersion(1L);
        assoc.setTypeQNameId(assocTypeQNameId);
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(sourceNodeId);
        assoc.setSourceNode(sourceNode);
        NodeEntity targetNode = new NodeEntity();
        targetNode.setId(targetNodeId);
        assoc.setTargetNode(targetNode);
        assoc.setAssocIndex(assocIndex);
        this.template.insert(INSERT_NODE_ASSOC, (Object)assoc);
        return assoc.getId();
    }

    @Override
    protected int updateNodeAssoc(Long id, int assocIndex) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        assoc.setId(id);
        assoc.setAssocIndex(assocIndex);
        return this.template.update(UPDATE_NODE_ASSOC, (Object)assoc);
    }

    @Override
    protected int deleteNodeAssoc(Long sourceNodeId, Long targetNodeId, Long assocTypeQNameId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        assoc.setTypeQNameId(assocTypeQNameId);
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(sourceNodeId);
        assoc.setSourceNode(sourceNode);
        NodeEntity targetNode = new NodeEntity();
        targetNode.setId(targetNodeId);
        assoc.setTargetNode(targetNode);
        return this.template.delete(DELETE_NODE_ASSOC, (Object)assoc);
    }

    @Override
    protected int deleteNodeAssocsToAndFrom(Long nodeId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(nodeId);
        assoc.setSourceNode(sourceNode);
        NodeEntity targetNode = new NodeEntity();
        targetNode.setId(nodeId);
        assoc.setTargetNode(targetNode);
        return this.template.delete(DELETE_NODE_ASSOCS_TO_AND_FROM, (Object)assoc);
    }

    @Override
    protected int deleteNodeAssocsToAndFrom(Long nodeId, Set<Long> assocTypeQNameIds) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        assoc.setTypeQNameIds(new ArrayList<Long>(assocTypeQNameIds));
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(nodeId);
        assoc.setSourceNode(sourceNode);
        NodeEntity targetNode = new NodeEntity();
        targetNode.setId(nodeId);
        assoc.setTargetNode(targetNode);
        return this.template.delete(DELETE_NODE_ASSOCS_TO_AND_FROM, (Object)assoc);
    }

    @Override
    protected int deleteNodeAssocs(List<Long> ids) {
        IdsEntity param = new IdsEntity();
        param.setIds(ids);
        return this.template.delete(DELETE_NODE_ASSOCS, (Object)param);
    }

    @Override
    protected List<NodeAssocEntity> selectNodeAssocsBySource(Long sourceNodeId, Long typeQNameId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(sourceNodeId);
        assoc.setSourceNode(sourceNode);
        assoc.setTypeQNameId(typeQNameId);
        return this.template.selectList(SELECT_NODE_ASSOCS_BY_SOURCE, (Object)assoc);
    }

    @Override
    protected List<NodeAssocEntity> selectNodeAssocsByTarget(Long targetNodeId, Long typeQNameId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        NodeEntity targetNode = new NodeEntity();
        targetNode.setId(targetNodeId);
        assoc.setTargetNode(targetNode);
        assoc.setTypeQNameId(typeQNameId);
        return this.template.selectList(SELECT_NODE_ASSOCS_BY_TARGET, (Object)assoc);
    }

    @Override
    protected NodeAssocEntity selectNodeAssocById(Long assocId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        assoc.setId(assocId);
        return (NodeAssocEntity)this.template.selectOne(SELECT_NODE_ASSOC_BY_ID, (Object)assoc);
    }

    @Override
    protected int selectNodeAssocMaxIndex(Long sourceNodeId, Long assocTypeQNameId) {
        NodeAssocEntity assoc = new NodeAssocEntity();
        NodeEntity sourceNode = new NodeEntity();
        sourceNode.setId(sourceNodeId);
        assoc.setSourceNode(sourceNode);
        assoc.setTypeQNameId(assocTypeQNameId);
        Integer maxIndex = (Integer)this.template.selectOne(SELECT_NODE_ASSOCS_MAX_INDEX, (Object)assoc);
        return maxIndex == null ? 0 : maxIndex;
    }

    @Override
    protected Long insertChildAssoc(ChildAssocEntity assoc) {
        assoc.setVersion(1L);
        this.template.insert(INSERT_CHILD_ASSOC, (Object)assoc);
        return assoc.getId();
    }

    @Override
    protected int deleteChildAssocById(Long assocId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        assoc.setId(assocId);
        return this.template.delete(DELETE_CHILD_ASSOC_BY_ID, (Object)assoc);
    }

    @Override
    protected int updateChildAssocIndex(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, int index) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, true);
        assoc.setQNameAll(this.qnameDAO, assocQName, true);
        assoc.setAssocIndex(index);
        return this.template.update(UPDATE_CHILD_ASSOCS_INDEX, (Object)assoc);
    }

    @Override
    protected int updateChildAssocsUniqueName(Long childNodeId, String name) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        assoc.setChildNodeNameAll(null, null, name);
        return this.template.update(UPDATE_CHILD_ASSOCS_UNIQUE_NAME, (Object)assoc);
    }

    @Override
    protected int deleteChildAssocsToAndFrom(Long nodeId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(nodeId);
        assoc.setParentNode(parentNode);
        NodeEntity childNode = new NodeEntity();
        childNode.setId(nodeId);
        assoc.setChildNode(childNode);
        return this.template.delete(DELETE_CHILD_ASSOCS_TO_AND_FROM, (Object)assoc);
    }

    @Override
    protected ChildAssocEntity selectChildAssoc(Long assocId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        assoc.setId(assocId);
        return (ChildAssocEntity)this.template.selectOne(SELECT_CHILD_ASSOC_BY_ID, (Object)assoc);
    }

    @Override
    protected List<ChildAssocEntity> selectChildNodeIds(Long nodeId, Boolean isPrimary, Long minAssocIdInclusive, int maxResults) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(nodeId);
        assoc.setParentNode(parentNode);
        assoc.setPrimary(isPrimary);
        assoc.setId(minAssocIdInclusive);
        RowBounds rowBounds = new RowBounds(0, maxResults);
        return this.template.selectList(SELECT_CHILD_NODE_IDS, (Object)assoc, rowBounds);
    }

    @Override
    public List<NodeIdAndAclId> selectPrimaryChildAcls(Long nodeId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(nodeId);
        assoc.setParentNode(parentNode);
        assoc.setPrimary(true);
        return this.template.selectList(SELECT_NODE_PRIMARY_CHILD_ACLS, (Object)assoc);
    }

    @Override
    protected List<ChildAssocEntity> selectChildAssoc(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        if (!assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            return Collections.emptyList();
        }
        if (!assoc.setQNameAll(this.qnameDAO, assocQName, false)) {
            return Collections.emptyList();
        }
        assoc.setOrdered(false);
        return this.template.selectList(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc);
    }

    @Override
    protected void selectChildAssocs(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, Boolean sameStore, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (childNodeId != null) {
            NodeEntity childNode = new NodeEntity();
            childNode.setId(childNodeId);
            assoc.setChildNode(childNode);
        }
        if (assocTypeQName != null && !assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        if (assocQName != null && !assoc.setQNameAll(this.qnameDAO, assocQName, false)) {
            resultsCallback.done();
            return;
        }
        if (isPrimary != null) {
            assoc.setPrimary(isPrimary);
        }
        if (sameStore != null) {
            assoc.setSameStore(sameStore);
        }
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    public void selectChildAssocs(Long parentNodeId, QName assocTypeQName, QName assocQName, int maxResults, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (assocTypeQName != null && !assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        if (assocQName != null && !assoc.setQNameAll(this.qnameDAO, assocQName, false)) {
            resultsCallback.done();
            return;
        }
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        RowBounds rowBounds = new RowBounds(0, maxResults);
        List entities = this.template.selectList(SELECT_CHILD_ASSOCS_OF_PARENT_LIMITED, (Object)assoc, rowBounds);
        DefaultResultContext resultContext = new DefaultResultContext();
        for (Object entity : entities) {
            resultContext.nextResultObject(entity);
            resultHandler.handleResult((ResultContext)resultContext);
        }
        resultsCallback.done();
    }

    @Override
    protected void selectChildAssocs(Long parentNodeId, Set<QName> assocTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        Set<Long> assocTypeQNameIds = this.qnameDAO.convertQNamesToIds(assocTypeQNames, false);
        if (assocTypeQNameIds.size() == 0) {
            resultsCallback.done();
            return;
        }
        assoc.setTypeQNameIds(new ArrayList<Long>(assocTypeQNameIds));
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected ChildAssocEntity selectChildAssoc(Long parentNodeId, QName assocTypeQName, String childName) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (!assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            return null;
        }
        assoc.setChildNodeNameAll(null, assocTypeQName, childName);
        assoc.setOrdered(false);
        return (ChildAssocEntity)this.template.selectOne(SELECT_CHILD_ASSOC_OF_PARENT_BY_NAME, (Object)assoc);
    }

    @Override
    protected void selectChildAssocs(Long parentNodeId, QName assocTypeQName, Collection<String> childNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        if (childNames.size() == 0) {
            resultsCallback.done();
            return;
        }
        if (childNames.size() > 1000) {
            throw new IllegalArgumentException("Unable to process more than 1000 child names in getChildAssocs");
        }
        final HashSet<String> childNamesShort = new HashSet<String>(childNames.size());
        ArrayList<Long> childNamesCrc = new ArrayList<Long>(childNames.size());
        for (String childName : childNames) {
            String childNameLower = childName.toLowerCase();
            String childNameShort = ChildAssocEntity.getChildNodeNameShort(childNameLower);
            Long childNameCrc = ChildAssocEntity.getChildNodeNameCrc(childNameLower);
            childNamesShort.add(childNameShort);
            childNamesCrc.add(childNameCrc);
        }
        ChildAssocResultHandlerFilter filter = new ChildAssocResultHandlerFilter(){

            public boolean isResult(ChildAssocEntity assoc) {
                return childNamesShort.contains(assoc.getChildNodeName());
            }
        };
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (assocTypeQName != null && !assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        assoc.setChildNodeNameCrcs(childNamesCrc);
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(filter, resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected void selectChildAssocsByPropertyValue(Long parentNodeId, QName propertyQName, NodePropertyValue nodeValue, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildPropertyEntity assocProp = new ChildPropertyEntity();
        assocProp.setParentNodeId(parentNodeId);
        Pair<Long, QName> propName = this.qnameDAO.getQName(propertyQName);
        if (propName == null) {
            resultsCallback.done();
            return;
        }
        assocProp.setValue(nodeValue);
        assocProp.setPropertyQNameId((Long)propName.getFirst());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_BY_PROPERTY_VALUE, (Object)assocProp, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected void selectChildAssocsByChildTypes(Long parentNodeId, Set<QName> childNodeTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        Set<Long> childNodeTypeQNameIds = this.qnameDAO.convertQNamesToIds(childNodeTypeQNames, false);
        if (childNodeTypeQNameIds.size() == 0) {
            resultsCallback.done();
            return;
        }
        assoc.setChildNodeTypeQNameIds(new ArrayList<Long>(childNodeTypeQNameIds));
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected void selectChildAssocsWithoutParentAssocsOfType(Long parentNodeId, QName assocTypeQName, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        if (!assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        assoc.setOrdered(resultsCallback.orderResults());
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_CHILD_ASSOCS_OF_PARENT_WITHOUT_PARENT_ASSOCS_OF_TYPE, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected List<ChildAssocEntity> selectPrimaryParentAssocs(Long childNodeId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        assoc.setPrimary(Boolean.TRUE);
        return this.template.selectList(SELECT_PARENT_ASSOCS_OF_CHILD, (Object)assoc);
    }

    @Override
    protected void selectParentAssocs(Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        if (assocTypeQName != null && !assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, false)) {
            resultsCallback.done();
            return;
        }
        if (assocQName != null && !assoc.setQNameAll(this.qnameDAO, assocQName, false)) {
            resultsCallback.done();
            return;
        }
        if (isPrimary != null) {
            assoc.setPrimary(isPrimary);
        }
        ChildAssocResultHandler resultHandler = new ChildAssocResultHandler(resultsCallback);
        this.template.select(SELECT_PARENT_ASSOCS_OF_CHILD, (Object)assoc, (ResultHandler)resultHandler);
        resultsCallback.done();
    }

    @Override
    protected List<ChildAssocEntity> selectParentAssocs(Long childNodeId) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        return this.template.selectList(SELECT_PARENT_ASSOCS_OF_CHILD, (Object)assoc);
    }

    @Override
    protected int updatePrimaryParentAssocs(Long childNodeId, Long parentNodeId, QName assocTypeQName, QName assocQName, String childNodeName) {
        ChildAssocEntity assoc = new ChildAssocEntity();
        NodeEntity parentNode = new NodeEntity();
        parentNode.setId(parentNodeId);
        assoc.setParentNode(parentNode);
        NodeEntity childNode = new NodeEntity();
        childNode.setId(childNodeId);
        assoc.setChildNode(childNode);
        if (assocTypeQName != null) {
            assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, true);
            assoc.setChildNodeNameAll(this.dictionaryService, assocTypeQName, childNodeName);
        }
        if (assocQName != null) {
            assoc.setQNameAll(this.qnameDAO, assocQName, true);
        }
        assoc.setPrimary(Boolean.TRUE);
        return this.template.update(UPDATE_PARENT_ASSOCS_OF_CHILD, (Object)assoc);
    }

    @Override
    protected void moveNodeData(Long fromNodeId, Long toNodeId) {
        IdsEntity params = new IdsEntity();
        params.setIdOne(fromNodeId);
        params.setIdTwo(toNodeId);
        int countPA = this.template.update(UPDATE_MOVE_PARENT_ASSOCS, (Object)params);
        int countCA = this.template.update(UPDATE_MOVE_CHILD_ASSOCS, (Object)params);
        int countSA = this.template.update(UPDATE_MOVE_SOURCE_ASSOCS, (Object)params);
        int countTA = this.template.update(UPDATE_MOVE_TARGET_ASSOCS, (Object)params);
        int countP = this.template.update(UPDATE_MOVE_PROPERTIES, (Object)params);
        int countA = this.template.update(UPDATE_MOVE_ASPECTS, (Object)params);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Moved node data: \n   From: " + fromNodeId + "\n" + "   To:   " + toNodeId + "\n" + "   PA:   " + countPA + "\n" + "   CA:   " + countCA + "\n" + "   SA:   " + countSA + "\n" + "   TA:   " + countTA + "\n" + "   P:    " + countP + "\n" + "   A:    " + countA));
        }
    }

    @Override
    protected void deleteSubscriptions(Long nodeId) {
    }

    @Override
    protected Transaction selectLastTxnBeforeCommitTime(Long maxCommitTime) {
        Assert.notNull((Object)maxCommitTime, (String)"maxCommitTime");
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setMaxCommitTime(maxCommitTime);
        List txns = this.template.selectList(SELECT_TXN_LAST, (Object)query, new RowBounds(0, 1));
        if (txns.size() > 0) {
            return (Transaction)txns.get(0);
        }
        return null;
    }

    @Override
    protected int selectTransactionCount() {
        return (Integer)this.template.selectOne(SELECT_TXN_COUNT);
    }

    @Override
    protected Transaction selectTxnById(Long txnId) {
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setId(txnId);
        return (Transaction)this.template.selectOne(SELECT_TXNS, (Object)query);
    }

    @Override
    protected List<NodeEntity> selectTxnChanges(Long txnId, Long storeId) {
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setId(txnId);
        if (storeId != null) {
            query.setStoreId(storeId);
        }
        return this.template.selectList(SELECT_TXN_NODES, (Object)query);
    }

    @Override
    protected int selectTxnNodeChangeCount(Long txnId, Boolean updates) {
        NodeEntity node = new NodeEntity();
        if (updates != null) {
            node.setDeleted(updates == false);
        }
        TransactionEntity transaction = new TransactionEntity();
        transaction.setId(txnId);
        node.setTransaction(transaction);
        return (Integer)this.template.selectOne(SELECT_TXN_NODE_COUNT, (Object)node);
    }

    @Override
    protected List<Transaction> selectTxns(Long fromTimeInclusive, Long toTimeExclusive, Integer count, List<Long> includeTxnIds, List<Long> excludeTxnIds, Long excludeServerId, Boolean ascending) {
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setMinCommitTime(fromTimeInclusive);
        query.setMaxCommitTime(toTimeExclusive);
        if (includeTxnIds != null && includeTxnIds.size() > 0) {
            query.setIncludeTxnIds(includeTxnIds);
        }
        if (excludeTxnIds != null && excludeTxnIds.size() > 0) {
            query.setExcludeTxnIds(excludeTxnIds);
        }
        query.setExcludeServerId(excludeServerId);
        query.setAscending(ascending);
        if (count == null) {
            return this.template.selectList(SELECT_TXNS, (Object)query);
        }
        return this.template.selectList(SELECT_TXNS, (Object)query, new RowBounds(0, count.intValue()));
    }

    @Override
    protected List<Long> selectTxnsUnused(Long minTxnId, Long maxCommitTime, Integer count) {
        TransactionQueryEntity query = new TransactionQueryEntity();
        query.setMinId(minTxnId);
        query.setMaxCommitTime(maxCommitTime);
        if (count == null) {
            return this.template.selectList(SELECT_TXNS_UNUSED, (Object)query);
        }
        return this.template.selectList(SELECT_TXNS_UNUSED, (Object)query, new RowBounds(0, count.intValue()));
    }

    @Override
    protected Long selectMinTxnCommitTime() {
        return (Long)this.template.selectOne(SELECT_TXN_MIN_COMMIT_TIME);
    }

    @Override
    protected Long selectMaxTxnCommitTime() {
        return (Long)this.template.selectOne(SELECT_TXN_MAX_COMMIT_TIME);
    }

    @Override
    public List<NodePropertyEntity> selectProperties(Collection<PropertyDefinition> propertyDefs) {
        final ArrayList<NodePropertyEntity> properties = new ArrayList<NodePropertyEntity>();
        HashSet<QName> qnames = new HashSet<QName>();
        for (PropertyDefinition propDef : propertyDefs) {
            qnames.add(propDef.getName());
        }
        Set<Long> qnameIds = this.qnameDAO.convertQNamesToIds(qnames, false);
        if (qnameIds.size() > 0) {
            IdsEntity param = new IdsEntity();
            param.setIds(new ArrayList<Long>(qnameIds));
            this.template.select(SELECT_PROPERTIES_BY_TYPES, (Object)param, new ResultHandler(){

                public void handleResult(ResultContext context) {
                    properties.add((NodePropertyEntity)context.getResultObject());
                }
            });
        }
        return properties;
    }

    public static class MSSQL
    extends NodeDAOImpl {
        private SqlSessionTemplate template;

        public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
            super.setSqlSessionTemplate(sqlSessionTemplate);
            this.template = sqlSessionTemplate;
        }

        protected void deleteSubscriptions(Long nodeId) {
            this.template.delete(NodeDAOImpl.DELETE_SUBSCRIPTIONS, (Object)nodeId);
        }
    }

    private class ChildAssocResultHandler
    implements ResultHandler {
        private final ChildAssocResultHandlerFilter filter;
        private final NodeDAO.ChildAssocRefQueryCallback resultsCallback;
        private boolean more = true;

        private ChildAssocResultHandler(NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
            this(null, resultsCallback);
        }

        private ChildAssocResultHandler(ChildAssocResultHandlerFilter filter, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
            this.filter = filter;
            this.resultsCallback = resultsCallback;
        }

        public void handleResult(ResultContext context) {
            Pair<Long, NodeRef> childNodePair;
            Pair<Long, NodeRef> parentNodePair;
            if (!this.more) {
                return;
            }
            ChildAssocEntity assoc = (ChildAssocEntity)context.getResultObject();
            if (this.filter != null && !this.filter.isResult(assoc)) {
                return;
            }
            Pair<Long, ChildAssociationRef> childAssocPair = assoc.getPair(NodeDAOImpl.this.qnameDAO);
            boolean more = this.resultsCallback.handle(childAssocPair, parentNodePair = assoc.getParentNode().getNodePair(), childNodePair = assoc.getChildNode().getNodePair());
            if (!more) {
                this.more = false;
            }
        }
    }

    private static interface ChildAssocResultHandlerFilter {
        public boolean isResult(ChildAssocEntity var1);
    }
}

