/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.propval.PropertyTypeConverter;
import org.alfresco.repo.domain.propval.PropertyValueEntity;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyTypeConverter
implements PropertyTypeConverter {
    protected static final Map<Class<?>, PropertyValueEntity.PersistedType> defaultPersistedTypesByClass;
    private Map<Class<?>, PropertyValueEntity.PersistedType> persistenceMapping = new HashMap(defaultPersistedTypesByClass);

    protected void addTypeMapping(Class<?> clazz, PropertyValueEntity.PersistedType targetType) {
        this.persistenceMapping.put(clazz, targetType);
    }

    protected boolean isConstructable(Serializable value) {
        Class<?> valueClazz = value.getClass();
        try {
            valueClazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (value instanceof Map) {
            Map mapValue = (Map)((Object)value);
            return mapValue.isEmpty();
        }
        if (value instanceof Collection) {
            Collection collectionValue = (Collection)((Object)value);
            return collectionValue.isEmpty();
        }
        return false;
    }

    @Override
    public Serializable constructInstance(String clazzName) {
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (Serializable)constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new AlfrescoRuntimeException("The constructed property is not serializable: " + clazzName);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to construct property for class: " + clazzName);
        }
    }

    @Override
    public PropertyValueEntity.PersistedType getPersistentType(Serializable value) {
        ParameterCheck.mandatory((String)"value", (Object)value);
        Class<?> clazz = value.getClass();
        PropertyValueEntity.PersistedType type = this.persistenceMapping.get(clazz);
        if (type != null) {
            return type;
        }
        if (this.isConstructable(value)) {
            return PropertyValueEntity.PersistedType.CONSTRUCTABLE;
        }
        if (value instanceof Enum) {
            return PropertyValueEntity.PersistedType.ENUM;
        }
        if (DefaultTypeConverter.INSTANCE.getConverter(clazz, Long.class) != null && DefaultTypeConverter.INSTANCE.getConverter(Long.class, clazz) != null) {
            return PropertyValueEntity.PersistedType.LONG;
        }
        if (DefaultTypeConverter.INSTANCE.getConverter(clazz, String.class) != null && DefaultTypeConverter.INSTANCE.getConverter(String.class, clazz) != null) {
            return PropertyValueEntity.PersistedType.STRING;
        }
        return PropertyValueEntity.PersistedType.SERIALIZABLE;
    }

    @Override
    public <T> T convert(Class<T> targetClass, Serializable value) {
        if (targetClass.isEnum() && value != null && value instanceof String) {
            Class<T> enumClazz = targetClass;
            return Enum.valueOf(enumClazz, (String)((Object)value));
        }
        return (T)DefaultTypeConverter.INSTANCE.convert(targetClass, (Object)value);
    }

    static {
        HashMap<Class<ChildAssociationRef>, PropertyValueEntity.PersistedType> mapClass = new HashMap<Class<ChildAssociationRef>, PropertyValueEntity.PersistedType>(29);
        mapClass.put(Boolean.class, PropertyValueEntity.PersistedType.LONG);
        mapClass.put(Short.class, PropertyValueEntity.PersistedType.LONG);
        mapClass.put(Integer.class, PropertyValueEntity.PersistedType.LONG);
        mapClass.put(Long.class, PropertyValueEntity.PersistedType.LONG);
        mapClass.put(Date.class, PropertyValueEntity.PersistedType.LONG);
        mapClass.put(Float.class, PropertyValueEntity.PersistedType.DOUBLE);
        mapClass.put(Double.class, PropertyValueEntity.PersistedType.DOUBLE);
        mapClass.put(String.class, PropertyValueEntity.PersistedType.STRING);
        mapClass.put(Class.class, PropertyValueEntity.PersistedType.STRING);
        mapClass.put(NodeRef.class, PropertyValueEntity.PersistedType.STRING);
        mapClass.put(StoreRef.class, PropertyValueEntity.PersistedType.STRING);
        mapClass.put(Period.class, PropertyValueEntity.PersistedType.STRING);
        mapClass.put(Locale.class, PropertyValueEntity.PersistedType.STRING);
        mapClass.put(AssociationRef.class, PropertyValueEntity.PersistedType.STRING);
        mapClass.put(ChildAssociationRef.class, PropertyValueEntity.PersistedType.STRING);
        defaultPersistedTypesByClass = Collections.unmodifiableMap(mapClass);
    }
}

