/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.solr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.solr.SOLRDAO;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.solr.Acl;
import org.alfresco.repo.solr.AclChangeSet;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.repo.solr.Transaction;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOLRDAOTest
extends TestCase {
    private ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private SOLRDAO solrDAO;

    public void setUp() throws Exception {
        this.solrDAO = (SOLRDAO)this.ctx.getBean("solrDAO");
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    public void testQueryChangeSets_NoLimit() {
        long startTime = System.currentTimeMillis() - 300000L;
        try {
            this.solrDAO.getAclChangeSets(null, startTime, null, null, 0);
            SOLRDAOTest.fail((String)"Must have result limit");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testQueryChangeSets_Time() {
        long startTime = System.currentTimeMillis() + 300000L;
        List<AclChangeSet> results = this.solrDAO.getAclChangeSets(null, startTime, null, null, 50);
        SOLRDAOTest.assertTrue((String)"ChangeSet count not limited", (results.size() == 0 ? 1 : 0) != 0);
    }

    public void testQueryChangeSets_Limit() {
        List<AclChangeSet> results = this.solrDAO.getAclChangeSets(null, 0L, null, null, 50);
        SOLRDAOTest.assertTrue((String)"Transaction count not limited", (results.size() <= 50 ? 1 : 0) != 0);
    }

    public void testQueryAcls_Arguments() {
        try {
            this.solrDAO.getAcls(Collections.<Long>emptyList(), null, 50);
            SOLRDAOTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.solrDAO.getAcls(Collections.singletonList(1L), null, 0);
            SOLRDAOTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testQueryAcls_All() {
        List<AclChangeSet> aclChangeSets = this.solrDAO.getAclChangeSets(null, 0L, null, null, 50);
        int aclTotal = 0;
        Iterator<AclChangeSet> aclChangeSetsIterator = aclChangeSets.iterator();
        while (aclChangeSetsIterator.hasNext()) {
            AclChangeSet aclChangeSet = aclChangeSetsIterator.next();
            if (aclChangeSet.getAclCount() == 0) {
                aclChangeSetsIterator.remove();
                continue;
            }
            aclTotal += aclChangeSet.getAclCount();
        }
        if (aclTotal == 0) {
            return;
        }
        List<Long> aclChangeSetIds = this.toIds(aclChangeSets);
        List<Acl> acls = this.solrDAO.getAcls(aclChangeSetIds, null, 1000);
        HashSet<Long> aclChangeSetIdsSet = new HashSet<Long>(aclChangeSetIds);
        for (Acl acl : acls) {
            Long aclChangeSetId = acl.getAclChangeSetId();
            SOLRDAOTest.assertTrue((String)"ACL ChangeSet ID not in original list", (boolean)aclChangeSetIdsSet.contains(aclChangeSetId));
        }
    }

    public void testQueryAcls_Single() {
        List<Acl> acls;
        List<AclChangeSet> aclChangeSets = this.solrDAO.getAclChangeSets(null, 0L, null, null, 1000);
        AclChangeSet aclChangeSet = null;
        for (AclChangeSet aclChangeSetLoop : aclChangeSets) {
            if (aclChangeSetLoop.getAclCount() <= 1) continue;
            aclChangeSet = aclChangeSetLoop;
            break;
        }
        if (aclChangeSet == null) {
            return;
        }
        Long aclChangeSetId = aclChangeSet.getId();
        List<Long> aclChangeSetIds = Collections.singletonList(aclChangeSetId);
        int aclCount = aclChangeSet.getAclCount();
        int totalAclCount = 0;
        Long minAclId = null;
        while ((acls = this.solrDAO.getAcls(aclChangeSetIds, minAclId, 1)).size() != 0) {
            SOLRDAOTest.assertEquals((String)"Expected exactly one result", (int)1, (int)acls.size());
            ++totalAclCount;
            minAclId = acls.get(0).getId() + 1L;
        }
        SOLRDAOTest.assertEquals((String)"Expected to page to exact number of results", (int)aclCount, (int)totalAclCount);
    }

    private List<Long> toIds(List<AclChangeSet> aclChangeSets) {
        ArrayList<Long> ids = new ArrayList<Long>(aclChangeSets.size());
        for (AclChangeSet aclChangeSet : aclChangeSets) {
            ids.add(aclChangeSet.getId());
        }
        return ids;
    }

    public void testQueryTransactions_NoLimit() {
        long startTime = System.currentTimeMillis() - 300000L;
        try {
            this.solrDAO.getTransactions(null, startTime, null, null, 0);
            SOLRDAOTest.fail((String)"Must have result limit");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testQueryTransactions_Time() {
        long startTime = System.currentTimeMillis() + 300000L;
        List<Transaction> results = this.solrDAO.getTransactions(null, startTime, null, null, 50);
        SOLRDAOTest.assertTrue((String)"Transaction count not limited", (results.size() == 0 ? 1 : 0) != 0);
    }

    public void testQueryTransactions_Limit() {
        List<Transaction> results = this.solrDAO.getTransactions(null, 0L, null, null, 50);
        SOLRDAOTest.assertTrue((String)"Transaction count not limited", (results.size() <= 50 ? 1 : 0) != 0);
    }

    public void testGetNodesSimple() {
        long startTime = 0L;
        List<Transaction> txns = this.solrDAO.getTransactions(null, startTime, null, null, 500);
        List<Long> txnIds = this.toTxnIds(txns);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(txnIds);
        nodeParameters.setStoreProtocol("workspace");
        nodeParameters.setStoreIdentifier(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getIdentifier());
        List<Node> nodes = this.solrDAO.getNodes(nodeParameters);
        SOLRDAOTest.assertTrue((String)"Expect 'some' nodes associated with txns", (nodes.size() > 0 ? 1 : 0) != 0);
    }

    public void testGetNodesForStore() {
        List<Transaction> txns = this.solrDAO.getTransactions(null, null, null, null, 500);
        List<Long> txnIds = this.toTxnIds(txns);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(txnIds);
        List<Node> nodes = this.solrDAO.getNodes(nodeParameters);
        SOLRDAOTest.assertTrue((String)"Expect 'some' nodes associated with txns", (nodes.size() > 0 ? 1 : 0) != 0);
    }

    public void testGetNodesForTxnRange() {
        List<Transaction> txns = this.solrDAO.getTransactions(null, null, null, null, 500);
        List<Long> txnIds = this.toTxnIds(txns);
        if (txnIds.size() < 2) {
            return;
        }
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setFromTxnId(txnIds.get(0));
        nodeParameters.setToTxnId(txnIds.get(1));
        List<Node> nodes = this.solrDAO.getNodes(nodeParameters);
        SOLRDAOTest.assertTrue((String)"Expect 'some' nodes associated with txns", (nodes.size() > 0 ? 1 : 0) != 0);
    }

    private List<Long> toTxnIds(List<Transaction> txns) {
        ArrayList<Long> txnIds = new ArrayList<Long>(txns.size());
        for (Transaction txn : txns) {
            txnIds.add(txn.getId());
        }
        return txnIds;
    }
}

