/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.subscriptions;

import org.alfresco.query.PagingRequest;
import org.alfresco.repo.domain.subscriptions.SubscriptionsDAO;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.subscriptions.PagingFollowingResults;
import org.alfresco.service.cmr.subscriptions.PagingSubscriptionResults;
import org.alfresco.service.cmr.subscriptions.SubscriptionItemTypeEnum;

public abstract class AbstractSubscriptionsDAO
implements SubscriptionsDAO {
    protected NodeService nodeService;
    protected PersonService personService;

    public final void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public final void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public abstract PagingSubscriptionResults selectSubscriptions(String var1, SubscriptionItemTypeEnum var2, PagingRequest var3);

    public abstract int countSubscriptions(String var1, SubscriptionItemTypeEnum var2);

    public abstract void insertSubscription(String var1, NodeRef var2);

    public abstract void deleteSubscription(String var1, NodeRef var2);

    public abstract boolean hasSubscribed(String var1, NodeRef var2);

    public abstract PagingFollowingResults selectFollowers(String var1, PagingRequest var2);

    public abstract int countFollowers(String var1);

    protected NodeRef getUserNodeRef(String userId) {
        try {
            return this.personService.getPerson(userId, false);
        }
        catch (NoSuchPersonException nspe) {
            return null;
        }
    }
}

