/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.subscriptions.ibatis;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.subscriptions.AbstractSubscriptionsDAO;
import org.alfresco.repo.domain.subscriptions.SubscriptionEntity;
import org.alfresco.repo.domain.subscriptions.SubscriptionNodeEntity;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.subscriptions.PagingFollowingResults;
import org.alfresco.service.cmr.subscriptions.PagingFollowingResultsImpl;
import org.alfresco.service.cmr.subscriptions.PagingSubscriptionResults;
import org.alfresco.service.cmr.subscriptions.PagingSubscriptionResultsImpl;
import org.alfresco.service.cmr.subscriptions.SubscriptionItemTypeEnum;
import org.alfresco.service.namespace.QName;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;

public class SubscriptionsDAOImpl
extends AbstractSubscriptionsDAO {
    private static final QName PROP_SYS_NODE_DBID = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node-dbid");
    private SqlSessionTemplate template;
    private QNameDAO qnameDAO;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    public final void setQNameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public PagingSubscriptionResults selectSubscriptions(String userId, SubscriptionItemTypeEnum type, PagingRequest pagingRequest) {
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type may not be null!");
        }
        NodeRef userNodeRef = this.getUserNodeRef(userId);
        if (userNodeRef == null) {
            throw new IllegalArgumentException("User does not exist!");
        }
        Long dbid = (Long)this.nodeService.getProperty(userNodeRef, PROP_SYS_NODE_DBID);
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("userNodeId", dbid);
        map.put("false", Boolean.FALSE);
        int maxItems = pagingRequest.getMaxItems() < 0 || pagingRequest.getMaxItems() > 0x7FFFFFFE ? 0x7FFFFFFE : pagingRequest.getMaxItems() + 1;
        List nodeList = this.template.selectList("alfresco.subscriptions.select_Subscriptions", map, new RowBounds(pagingRequest.getSkipCount(), maxItems + 1));
        boolean hasMore = nodeList.size() > maxItems;
        ArrayList<NodeRef> result = new ArrayList<NodeRef>(nodeList.size());
        for (SubscriptionNodeEntity sne : nodeList) {
            result.add(sne.getNodeRef());
            if (result.size() != pagingRequest.getMaxItems()) continue;
            break;
        }
        Integer totalCount = null;
        if (pagingRequest.getRequestTotalCountMax() > 0) {
            totalCount = this.countSubscriptions(userId, type);
        }
        return new PagingSubscriptionResultsImpl(result, hasMore, totalCount);
    }

    public int countSubscriptions(String userId, SubscriptionItemTypeEnum type) {
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type may not be null!");
        }
        NodeRef userNodeRef = this.getUserNodeRef(userId);
        if (userNodeRef == null) {
            return 0;
        }
        Long dbid = (Long)this.nodeService.getProperty(userNodeRef, PROP_SYS_NODE_DBID);
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("userNodeId", dbid);
        map.put("false", Boolean.FALSE);
        Number count = (Number)this.template.selectOne("alfresco.subscriptions.select_countSubscriptions", map);
        return count == null ? 0 : count.intValue();
    }

    public void insertSubscription(String userId, NodeRef node) {
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        if (node == null) {
            throw new IllegalArgumentException("Node may not be null!");
        }
        NodeRef userNodeRef = this.getUserNodeRef(userId);
        if (userNodeRef == null) {
            throw new IllegalArgumentException("User does not exist!");
        }
        Long dbid = (Long)this.nodeService.getProperty(userNodeRef, PROP_SYS_NODE_DBID);
        Long nodedbid = (Long)this.nodeService.getProperty(node, PROP_SYS_NODE_DBID);
        SubscriptionEntity se = new SubscriptionEntity();
        se.setUserNodeId(dbid);
        se.setNodeId(nodedbid);
        Number count = (Number)this.template.selectOne("alfresco.subscriptions.select_hasSubscribed", (Object)se);
        if (count == null || count.intValue() == 0) {
            this.template.insert("alfresco.subscriptions.insert_Subscription", (Object)se);
        }
    }

    public void deleteSubscription(String userId, NodeRef node) {
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        if (node == null) {
            throw new IllegalArgumentException("Node may not be null!");
        }
        NodeRef userNodeRef = this.getUserNodeRef(userId);
        if (userNodeRef == null) {
            throw new IllegalArgumentException("User does not exist!");
        }
        Long dbid = (Long)this.nodeService.getProperty(userNodeRef, PROP_SYS_NODE_DBID);
        Long nodedbid = (Long)this.nodeService.getProperty(node, PROP_SYS_NODE_DBID);
        SubscriptionEntity se = new SubscriptionEntity();
        se.setUserNodeId(dbid);
        se.setNodeId(nodedbid);
        this.template.delete("alfresco.subscriptions.delete_Subscription", (Object)se);
    }

    public boolean hasSubscribed(String userId, NodeRef node) {
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        if (node == null) {
            throw new IllegalArgumentException("Node may not be null!");
        }
        NodeRef userNodeRef = this.getUserNodeRef(userId);
        if (userNodeRef == null) {
            throw new IllegalArgumentException("User does not exist!");
        }
        Long dbid = (Long)this.nodeService.getProperty(userNodeRef, PROP_SYS_NODE_DBID);
        Long nodedbid = (Long)this.nodeService.getProperty(node, PROP_SYS_NODE_DBID);
        SubscriptionEntity se = new SubscriptionEntity();
        se.setUserNodeId(dbid);
        se.setNodeId(nodedbid);
        Number count = (Number)this.template.selectOne("alfresco.subscriptions.select_hasSubscribed", (Object)se);
        return count == null ? false : count.intValue() > 0;
    }

    public PagingFollowingResults selectFollowing(String userId, PagingRequest pagingRequest) {
        boolean hasMore;
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        NodeRef userNodeRef = this.getUserNodeRef(userId);
        if (userNodeRef == null) {
            throw new IllegalArgumentException("User does not exist!");
        }
        Long dbid = (Long)this.nodeService.getProperty(userNodeRef, PROP_SYS_NODE_DBID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userIdQname", this.qnameDAO.getQName(ContentModel.PROP_USERNAME).getFirst());
        map.put("userNodeId", dbid);
        map.put("false", Boolean.FALSE);
        int maxItems = pagingRequest.getMaxItems() < 0 || pagingRequest.getMaxItems() > 0x7FFFFFFE ? 0x7FFFFFFE : pagingRequest.getMaxItems() + 1;
        List userList = this.template.selectList("alfresco.subscriptions.select_Following", map, new RowBounds(pagingRequest.getSkipCount(), maxItems + 1));
        boolean bl = hasMore = userList.size() > maxItems;
        if (hasMore && userList.size() > 0) {
            userList.remove(userList.size() - 1);
        }
        Integer totalCount = null;
        if (pagingRequest.getRequestTotalCountMax() > 0) {
            totalCount = this.countSubscriptions(userId, SubscriptionItemTypeEnum.USER);
        }
        return new PagingFollowingResultsImpl(userList, hasMore, totalCount);
    }

    public PagingFollowingResults selectFollowers(String userId, PagingRequest pagingRequest) {
        boolean hasMore;
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        NodeRef userNodeRef = this.getUserNodeRef(userId);
        if (userNodeRef == null) {
            throw new IllegalArgumentException("User does not exist!");
        }
        Long dbid = (Long)this.nodeService.getProperty(userNodeRef, PROP_SYS_NODE_DBID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userIdQname", this.qnameDAO.getQName(ContentModel.PROP_USERNAME).getFirst());
        map.put("userNodeId", dbid);
        map.put("false", Boolean.FALSE);
        int maxItems = pagingRequest.getMaxItems() < 0 || pagingRequest.getMaxItems() > 0x7FFFFFFE ? 0x7FFFFFFE : pagingRequest.getMaxItems() + 1;
        List userList = this.template.selectList("alfresco.subscriptions.select_Followers", map, new RowBounds(pagingRequest.getSkipCount(), maxItems + 1));
        boolean bl = hasMore = userList.size() > maxItems;
        if (hasMore && userList.size() > 0) {
            userList.remove(userList.size() - 1);
        }
        Integer totalCount = null;
        if (pagingRequest.getRequestTotalCountMax() > 0) {
            totalCount = this.countFollowers(userId);
        }
        return new PagingFollowingResultsImpl(userList, hasMore, totalCount);
    }

    public int countFollowers(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        NodeRef userNodeRef = this.getUserNodeRef(userId);
        if (userNodeRef == null) {
            return 0;
        }
        Long dbid = (Long)this.nodeService.getProperty(userNodeRef, PROP_SYS_NODE_DBID);
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("userNodeId", dbid);
        map.put("false", Boolean.FALSE);
        Number count = (Number)this.template.selectOne("alfresco.subscriptions.select_countFollowers", map);
        return count == null ? 0 : count.intValue();
    }
}

