/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedMap;
import java.util.zip.ZipException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.view.AVMZipExporterService;
import org.apache.poi.util.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class AVMZipExporterServiceImpl
implements AVMZipExporterService {
    private AVMService avmService;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void export(File output, int version, String path, boolean recurse) throws IOException, ZipException {
        ZipOutputStream out = new ZipOutputStream(output);
        this.export(out, version, path, recurse);
        out.close();
    }

    public void export(ZipOutputStream out, int version, String path, boolean recurse) throws IOException, ZipException {
        AVMNodeDescriptor node = this.avmService.lookup(version, path);
        this.export(out, node, recurse);
    }

    public void export(ZipOutputStream out, AVMNodeDescriptor node, boolean recurse) throws IOException, ZipException {
        String name = node.getPath().substring(node.getPath().indexOf(58) + 1).substring(1);
        ZipEntry entry = node.isDirectory() ? new ZipEntry(name + "/") : new ZipEntry(name);
        out.putNextEntry(entry);
        if (node.isDirectory()) {
            if (recurse) {
                SortedMap<String, AVMNodeDescriptor> contents = this.avmService.getDirectoryListing(node);
                for (AVMNodeDescriptor child : contents.values()) {
                    this.export(out, child, recurse);
                }
            }
        } else {
            InputStream stream = this.avmService.getFileInputStream(node);
            IOUtils.copy((InputStream)stream, (OutputStream)out);
        }
    }
}

