/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.RegisteredConstraint;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldGroup;
import org.alfresco.repo.forms.PropertyFieldDefinition;
import org.alfresco.repo.forms.processor.node.ContentModelField;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.node.PeriodDataTypeParameters;
import org.alfresco.repo.forms.processor.node.QNameFieldProcessor;
import org.alfresco.service.cmr.dictionary.ClassAttributeDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFieldProcessor
extends QNameFieldProcessor<PropertyDefinition> {
    private static final Log logger = LogFactory.getLog(PropertyFieldProcessor.class);

    public PropertyFieldProcessor() {
    }

    public PropertyFieldProcessor(NamespaceService namespaceService, DictionaryService dictionaryService) {
        super(namespaceService, dictionaryService);
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected PropertyDefinition getTypeDefinition(QName fullName, ContentModelItemData<?> itemData, boolean isForcedField) {
        PropertyDefinition propDef = itemData.getPropertyDefinition(fullName);
        if (propDef == null && isForcedField) {
            propDef = this.dictionaryService.getProperty(fullName);
        }
        return propDef;
    }

    @Override
    public Field makeField(PropertyDefinition propDef, Object value, FieldGroup group) {
        PropertyFieldDefinition fieldDef = this.makePropertyFieldDefinition(propDef, group);
        return new ContentModelField(propDef, fieldDef, value);
    }

    @Override
    protected FieldGroup getGroup(PropertyDefinition propDef) {
        return null;
    }

    @Override
    public Object getValue(QName name, ContentModelItemData<?> data) {
        Serializable value = data.getPropertyValue(name);
        if (value == null) {
            return this.getDefaultValue(name, data);
        }
        if (value instanceof Collection) {
            List list;
            Collection values = (Collection)((Object)value);
            if (value instanceof List && !values.isEmpty() && (list = (List)values).get(0) instanceof Date) {
                ArrayList<String> isoDates = new ArrayList<String>(list.size());
                for (Object date : list) {
                    isoDates.add(ISO8601DateFormat.format((Date)((Date)date)));
                }
                return StringUtils.collectionToCommaDelimitedString(isoDates);
            }
            return StringUtils.collectionToCommaDelimitedString((Collection)values);
        }
        if (value instanceof ContentData) {
            ContentData contentData = (ContentData)value;
            return contentData.getInfoUrl();
        }
        if (value instanceof NodeRef) {
            return ((NodeRef)value).toString();
        }
        return value;
    }

    private Object getDefaultValue(QName name, ContentModelItemData<?> data) {
        PropertyDefinition propDef = data.getPropertyDefinition(name);
        if (propDef != null) {
            return propDef.getDefaultValue();
        }
        return null;
    }

    private PropertyFieldDefinition makePropertyFieldDefinition(PropertyDefinition propDef, FieldGroup group) {
        String name = this.getPrefixedName((ClassAttributeDefinition)propDef);
        QName dataType = propDef.getDataType().getName();
        PropertyFieldDefinition fieldDef = new PropertyFieldDefinition(name, dataType.getLocalName());
        this.populateFieldDefinition(propDef, fieldDef, group, "prop_");
        fieldDef.setDefaultValue(propDef.getDefaultValue());
        fieldDef.setMandatory(propDef.isMandatory());
        fieldDef.setRepeating(propDef.isMultiValued());
        if ("http://www.alfresco.org/model/system/1.0".equals(propDef.getName().getNamespaceURI())) {
            fieldDef.setProtectedField(true);
        }
        if (dataType.equals((Object)DataTypeDefinition.PERIOD)) {
            PeriodDataTypeParameters periodOptions = this.getPeriodOptions();
            fieldDef.setDataTypeParameters(periodOptions);
        }
        List<PropertyFieldDefinition.FieldConstraint> fieldConstraints = this.makeFieldConstraints(propDef);
        fieldDef.setConstraints(fieldConstraints);
        return fieldDef;
    }

    private List<PropertyFieldDefinition.FieldConstraint> makeFieldConstraints(PropertyDefinition propDef) {
        ArrayList<PropertyFieldDefinition.FieldConstraint> fieldConstraints = null;
        List constraints = propDef.getConstraints();
        if (constraints != null && constraints.size() > 0) {
            fieldConstraints = new ArrayList<PropertyFieldDefinition.FieldConstraint>(constraints.size());
            for (ConstraintDefinition constraintDef : constraints) {
                Constraint constraint = constraintDef.getConstraint();
                String type = constraint.getType();
                Map params = constraint.getParameters();
                if (RegisteredConstraint.class.isAssignableFrom(constraint.getClass())) {
                    constraint = ((RegisteredConstraint)constraint).getRegisteredConstraint();
                }
                if (ListOfValuesConstraint.class.isAssignableFrom(constraint.getClass())) {
                    ListOfValuesConstraint lovConstraint = (ListOfValuesConstraint)constraint;
                    List allowedValues = lovConstraint.getAllowedValues();
                    ArrayList<String> localisedValues = new ArrayList<String>(allowedValues.size());
                    for (String value : allowedValues) {
                        String displayLabel = lovConstraint.getDisplayLabel(value);
                        localisedValues.add(value + "|" + displayLabel);
                    }
                    params.put("allowedValues", localisedValues);
                }
                PropertyFieldDefinition.FieldConstraint fieldConstraint = new PropertyFieldDefinition.FieldConstraint(type, params);
                fieldConstraints.add(fieldConstraint);
            }
        }
        return fieldConstraints;
    }

    private PeriodDataTypeParameters getPeriodOptions() {
        PeriodDataTypeParameters periodOptions = new PeriodDataTypeParameters();
        Set providers = Period.getProviderNames();
        for (String provider : providers) {
            periodOptions.addPeriodProvider(Period.getProvider((String)provider));
        }
        return periodOptions;
    }

    @Override
    protected String getRegistryKey() {
        return "prop";
    }
}

