/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.processor.FieldProcessorRegistry;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.workflow.AbstractWorkflowFormProcessor;
import org.alfresco.repo.forms.processor.workflow.ContentModelFormPersister;
import org.alfresco.repo.forms.processor.workflow.TaskFormPersister;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFormProcessor
extends AbstractWorkflowFormProcessor<WorkflowTask, WorkflowTask> {
    private static final Log LOGGER = LogFactory.getLog(TaskFormProcessor.class);
    protected AuthenticationService authenticationService;
    protected PersonService personService;

    public TaskFormProcessor() {
    }

    public TaskFormProcessor(WorkflowService workflowService, NamespaceService namespaceService, DictionaryService dictionaryService, AuthenticationService authenticationService, PersonService personService, FieldProcessorRegistry fieldProcessorRegistry) {
        this.workflowService = workflowService;
        this.namespaceService = namespaceService;
        this.dictionaryService = dictionaryService;
        this.authenticationService = authenticationService;
        this.personService = personService;
        this.fieldProcessorRegistry = fieldProcessorRegistry;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Override
    protected WorkflowTask getTypedItemForDecodedId(String itemId) {
        return this.workflowService.getTaskById(itemId);
    }

    @Override
    protected String getItemType(WorkflowTask item) {
        TypeDefinition typeDef = item.getDefinition().getMetadata();
        return typeDef.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
    }

    @Override
    protected String getItemURI(WorkflowTask item) {
        return "api/task-instances/" + item.getId();
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    @Override
    protected TypeDefinition getBaseType(WorkflowTask task) {
        return task.getDefinition().getMetadata();
    }

    @Override
    protected Map<QName, Serializable> getPropertyValues(WorkflowTask task) {
        return task.getProperties();
    }

    @Override
    protected Map<QName, Serializable> getAssociationValues(WorkflowTask item) {
        return item.getProperties();
    }

    @Override
    protected Map<String, Object> getTransientValues(WorkflowTask item) {
        HashMap<String, Object> values = new HashMap<String, Object>(2);
        values.put("transitions", this.getTransitionValues(item));
        values.put("packageItems", this.getPackageItemValues(item));
        values.put("message", this.getMessageValue(item));
        values.put("taskOwner", this.getTaskOwnerValue(item));
        return values;
    }

    private Object getPackageItemValues(WorkflowTask task) {
        List<NodeRef> items = this.workflowService.getPackageContents(task.getId());
        ArrayList<String> results = new ArrayList<String>(items.size());
        for (NodeRef item : items) {
            results.add(item.toString());
        }
        return results;
    }

    private String getMessageValue(WorkflowTask task) {
        String taskTitle;
        String message = I18NUtil.getMessage((String)"form_service.message.value.none");
        String description = (String)((Object)task.getProperties().get(WorkflowModel.PROP_DESCRIPTION));
        if (!(description == null || (taskTitle = task.getTitle()) != null && taskTitle.equals(description))) {
            message = description;
        }
        return message;
    }

    private String getTaskOwnerValue(WorkflowTask task) {
        String owner = (String)((Object)task.getProperties().get(ContentModel.PROP_OWNER));
        if (owner == null || owner.length() == 0) {
            return null;
        }
        return this.buildTaskOwnerString(owner);
    }

    private String buildTaskOwnerString(String ownerUsername) {
        StringBuilder builder = new StringBuilder(ownerUsername);
        NodeRef ownerNodeRef = null;
        try {
            ownerNodeRef = this.personService.getPerson(ownerUsername);
        }
        catch (NoSuchPersonException nspe) {
            // empty catch block
        }
        if (ownerNodeRef != null) {
            Map personProps = this.nodeService.getProperties(ownerNodeRef);
            builder.append("|");
            builder.append(personProps.containsKey(ContentModel.PROP_FIRSTNAME) ? (Serializable)personProps.get(ContentModel.PROP_FIRSTNAME) : "");
            builder.append("|");
            builder.append(personProps.containsKey(ContentModel.PROP_LASTNAME) ? (Serializable)personProps.get(ContentModel.PROP_LASTNAME) : "");
        }
        return builder.toString();
    }

    private String getTransitionValues(WorkflowTask item) {
        WorkflowTransition[] transitions = item.getDefinition().getNode().getTransitions();
        if (transitions == null || transitions.length == 0) {
            return "";
        }
        return this.buildTransitionString(item, transitions);
    }

    private String buildTransitionString(WorkflowTask item, WorkflowTransition[] transitions) {
        StringBuilder builder = new StringBuilder();
        List<String> hiddenStr = this.getHiddenTransitions(item);
        for (WorkflowTransition transition : transitions) {
            String transId = transition.getId();
            if (hiddenStr.contains(transId)) continue;
            builder.append(transId != null ? transId : "");
            builder.append("|");
            builder.append(transition.getTitle());
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private List<String> getHiddenTransitions(WorkflowTask task) {
        Serializable hiddenValues = task.getProperties().get(WorkflowModel.PROP_HIDDEN_TRANSITIONS);
        if (hiddenValues != null) {
            if (hiddenValues instanceof List) {
                return (List)((Object)hiddenValues);
            }
            if (hiddenValues instanceof String && ((String)((Object)hiddenValues)).length() > 0) {
                return Arrays.asList(((String)((Object)hiddenValues)).split(","));
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected ContentModelFormPersister<WorkflowTask> makeFormPersister(WorkflowTask item) {
        Object itemData = this.makeItemData(item);
        return new TaskFormPersister((ContentModelItemData<WorkflowTask>)itemData, this.namespaceService, this.dictionaryService, this.workflowService, this.nodeService, this.authenticationService, this.behaviourFilter, LOGGER);
    }
}

