/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.forms.FormException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.json.JSONArray;
import org.json.JSONException;
import org.springframework.extensions.surf.util.I18NUtil;

public class TypedPropertyValueGetter {
    public static final String ON = "on";

    public Serializable getValue(Object value, PropertyDefinition propDef) {
        if (value == null) {
            return null;
        }
        if (propDef.isMultiValued()) {
            return this.processMultiValuedType(value);
        }
        if (this.isBooleanProperty(propDef)) {
            return this.processBooleanValue(value);
        }
        if (this.isLocaleProperty(propDef)) {
            return this.processLocaleValue(value);
        }
        if (value instanceof String) {
            String valStr = (String)value;
            if (this.isTextProperty(propDef)) {
                return valStr;
            }
            if (valStr.isEmpty()) {
                return null;
            }
        }
        if (value instanceof Serializable) {
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(propDef.getDataType(), value);
        }
        throw new FormException("Property values must be of a Serializable type! Value type: " + value.getClass());
    }

    private boolean isTextProperty(PropertyDefinition propDef) {
        return propDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT);
    }

    private Boolean processBooleanValue(Object value) {
        if (value instanceof String) {
            if (ON.equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.valueOf((String)value);
        }
        return Boolean.FALSE;
    }

    private boolean isBooleanProperty(PropertyDefinition propDef) {
        return propDef.getDataType().getName().equals((Object)DataTypeDefinition.BOOLEAN);
    }

    private Serializable processLocaleValue(Object value) {
        if (value instanceof String) {
            return I18NUtil.parseLocale((String)((String)value));
        }
        throw new FormException("Locale property values must be represented as a String! Value is of type: " + value.getClass());
    }

    private boolean isLocaleProperty(PropertyDefinition propDef) {
        return propDef.getDataType().getName().equals((Object)DataTypeDefinition.LOCALE);
    }

    private Serializable processMultiValuedType(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            return this.processMultiValueString(stringValue);
        }
        if (value instanceof JSONArray) {
            JSONArray jsonArr = (JSONArray)value;
            return this.processJSONArray(jsonArr);
        }
        if (value instanceof List) {
            return (Serializable)value;
        }
        throw new FormException("The value is an unsupported multi-value type: " + value);
    }

    private Serializable processJSONArray(JSONArray jsonArr) {
        int arrLength = jsonArr.length();
        ArrayList<Object> list = new ArrayList<Object>(arrLength);
        try {
            for (int x = 0; x < arrLength; ++x) {
                list.add(jsonArr.get(x));
            }
        }
        catch (JSONException je) {
            throw new FormException("Failed to convert JSONArray to List", je);
        }
        return list;
    }

    private Serializable processMultiValueString(String stringValue) {
        if (stringValue.length() == 0) {
            return null;
        }
        String[] values = stringValue.split(",");
        List<String> valueList = Arrays.asList(values);
        return new ArrayList<String>(valueList);
    }
}

