/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.i18n;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageDeployer;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.i18n.MessageServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MessageServiceImplTest
extends TestCase
implements MessageDeployer {
    private static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    private MessageService messageService;
    private NodeService nodeService;
    private MutableAuthenticationService authenticationService;
    private ContentService contentService;
    private static final String BASE_BUNDLE_NAME = "testMessages";
    private static final String BASE_RESOURCE_CLASSPATH = "org/alfresco/repo/i18n/";
    private static final String PARAM_VALUE = "television";
    private static final String MSG_YES = "msg_yes";
    private static final String MSG_NO = "msg_no";
    private static final String MSG_PARAMS = "msg_params";
    private static final String VALUE_YES = "Yes";
    private static final String VALUE_NO = "No";
    private static final String VALUE_PARAMS = "What no television?";
    private static final String VALUE_FR_YES = "Oui";
    private static final String VALUE_FR_NO = "Non";
    private static final String VALUE_FR_PARAMS = "Que non television?";
    private static final String PWD = "admin";
    private StoreRef testStoreRef;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private UserTransaction testTX;

    protected void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            MessageServiceImplTest.fail((String)"Detected a leaked transaction from a previous test.");
        }
        this.messageService = (MessageService)applicationContext.getBean("messageService");
        this.nodeService = (NodeService)applicationContext.getBean("NodeService");
        this.authenticationService = (MutableAuthenticationService)applicationContext.getBean("AuthenticationService");
        this.contentService = (ContentService)applicationContext.getBean("ContentService");
        this.transactionService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        Locale.setDefault(Locale.ENGLISH);
        this.messageService.setLocale(Locale.getDefault());
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    protected void tearDown() throws Exception {
        if (this.testTX != null) {
            try {
                this.testTX.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    private void setupRepo() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        if (!this.authenticationService.authenticationExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), PWD.toCharArray());
        }
        this.authenticationService.authenticate(AuthenticationUtil.getAdminUserName(), PWD.toCharArray());
        String pattern = "classpath*:org/alfresco/repo/i18n/testMessages*";
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources(pattern);
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                String filename = resources[i].getFilename();
                this.addMessageResource(rootNodeRef, filename, resources[i].getInputStream());
            }
        }
    }

    private void addMessageResource(NodeRef rootNodeRef, String name, InputStream resourceStream) throws Exception {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef association = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(resourceStream);
        resourceStream.close();
    }

    public void testSetAndGet() {
        MessageServiceImplTest.assertEquals((Object)Locale.getDefault(), (Object)this.messageService.getLocale());
        this.messageService.setLocale(Locale.CANADA_FRENCH);
        MessageServiceImplTest.assertEquals((Object)Locale.CANADA_FRENCH, (Object)this.messageService.getLocale());
        this.messageService.setLocale(null);
        MessageServiceImplTest.assertEquals((Object)Locale.getDefault(), (Object)this.messageService.getLocale());
    }

    public void testGetMessagesLoadedFromRepo() throws Exception {
        this.setupRepo();
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_NO));
        this.messageService.registerResourceBundle(this.testStoreRef + "/cm:" + BASE_BUNDLE_NAME);
        this.getMessages();
        this.messageService.unregisterResourceBundle(this.testStoreRef + "/cm:" + BASE_BUNDLE_NAME);
    }

    public void testGetMessagesWithParamsLoadedFromRepo() throws Exception {
        this.setupRepo();
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_PARAMS, PARAM_VALUE));
        this.messageService.registerResourceBundle(this.testStoreRef + "/cm:" + BASE_BUNDLE_NAME);
        this.getMessagesWithParams();
        this.messageService.unregisterResourceBundle(this.testStoreRef + "/cm:" + BASE_BUNDLE_NAME);
    }

    public void testGetMessagesLoadedFromClasspath() throws Exception {
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_NO));
        this.messageService.registerResourceBundle("org/alfresco/repo/i18n/testMessages");
        this.getMessages();
        this.messageService.unregisterResourceBundle("org/alfresco/repo/i18n/testMessages");
    }

    public void testGetMessagesWithParamsLoadedFromClasspath() throws Exception {
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_PARAMS, PARAM_VALUE));
        this.messageService.registerResourceBundle("org/alfresco/repo/i18n/testMessages");
        this.getMessagesWithParams();
        this.messageService.unregisterResourceBundle("org/alfresco/repo/i18n/testMessages");
    }

    public void testRegisterBundleFromRepo() throws Exception {
        this.setupRepo();
        this.messageService.registerResourceBundle(this.testStoreRef + "/cm:" + BASE_BUNDLE_NAME);
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
        this.messageService.unregisterResourceBundle(this.testStoreRef + "/cm:" + BASE_BUNDLE_NAME);
    }

    public void testRegisterBundleFromClasspath() throws Exception {
        this.messageService.registerResourceBundle("org/alfresco/repo/i18n/testMessages");
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
        this.messageService.unregisterResourceBundle("org/alfresco/repo/i18n/testMessages");
    }

    public void testReset() throws Exception {
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage(MSG_YES));
        this.messageService.register(this);
        this.initMessages();
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
        ((MessageServiceImpl)this.messageService).reset();
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
    }

    public void initMessages() {
        this.messageService.registerResourceBundle("org/alfresco/repo/i18n/testMessages");
    }

    public void testLocaleMatching() {
        HashSet<Locale> options = new HashSet<Locale>(13);
        options.add(Locale.FRENCH);
        options.add(Locale.FRANCE);
        options.add(Locale.CANADA);
        options.add(Locale.CANADA_FRENCH);
        options.add(Locale.CHINESE);
        options.add(Locale.TRADITIONAL_CHINESE);
        options.add(Locale.SIMPLIFIED_CHINESE);
        Locale fr_FR_1 = new Locale("fr", "FR", "1");
        Locale zh_CN_1 = new Locale("zh", "CN", "1");
        Locale zh_CN_2 = new Locale("zh", "CN", "2");
        Locale zh_CN_3 = new Locale("zh", "CN", "3");
        options.add(zh_CN_1);
        options.add(zh_CN_2);
        HashSet<Locale> chineseMatches = new HashSet<Locale>(3);
        chineseMatches.add(Locale.SIMPLIFIED_CHINESE);
        chineseMatches.add(zh_CN_1);
        chineseMatches.add(zh_CN_2);
        HashSet<Locale> frenchMatches = new HashSet<Locale>(3);
        frenchMatches.add(Locale.FRANCE);
        MessageServiceImplTest.assertEquals((Object)Locale.CHINA, (Object)this.messageService.getNearestLocale(Locale.CHINA, options));
        MessageServiceImplTest.assertEquals((Object)Locale.CHINESE, (Object)this.messageService.getNearestLocale(Locale.CHINESE, options));
        MessageServiceImplTest.assertEquals((Object)zh_CN_1, (Object)this.messageService.getNearestLocale(zh_CN_1, options));
        MessageServiceImplTest.assertEquals((Object)zh_CN_2, (Object)this.messageService.getNearestLocale(zh_CN_2, options));
        MessageServiceImplTest.assertTrue((boolean)chineseMatches.contains(this.messageService.getNearestLocale(zh_CN_3, options)));
        MessageServiceImplTest.assertEquals((Object)Locale.FRANCE, (Object)this.messageService.getNearestLocale(fr_FR_1, options));
        Locale na_na_na = new Locale("", "", "");
        Locale check = this.messageService.getNearestLocale(na_na_na, options);
        MessageServiceImplTest.assertNotNull((String)"Expected some kind of value back", (Object)check);
    }

    public void testLocaleParsing() {
        MessageServiceImplTest.assertEquals((Object)Locale.FRANCE, (Object)this.messageService.parseLocale("fr_FR"));
        MessageServiceImplTest.assertEquals((Object)new Locale("en", "GB", "cockney"), (Object)this.messageService.parseLocale("en_GB_cockney"));
        MessageServiceImplTest.assertEquals((Object)new Locale("en", "GB", ""), (Object)this.messageService.parseLocale("en_GB"));
        MessageServiceImplTest.assertEquals((Object)new Locale("en", "", ""), (Object)this.messageService.parseLocale("en"));
        MessageServiceImplTest.assertEquals((Object)Locale.getDefault(), (Object)this.messageService.parseLocale(""));
    }

    private void getMessages() {
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES));
        MessageServiceImplTest.assertEquals((String)VALUE_NO, (String)this.messageService.getMessage(MSG_NO));
        MessageServiceImplTest.assertNull((Object)this.messageService.getMessage("bad_key"));
        this.messageService.setLocale(new Locale("fr", "FR"));
        MessageServiceImplTest.assertEquals((String)VALUE_FR_YES, (String)this.messageService.getMessage(MSG_YES));
        MessageServiceImplTest.assertEquals((String)VALUE_FR_NO, (String)this.messageService.getMessage(MSG_NO));
        MessageServiceImplTest.assertEquals((String)VALUE_YES, (String)this.messageService.getMessage(MSG_YES, Locale.getDefault()));
        MessageServiceImplTest.assertEquals((String)VALUE_NO, (String)this.messageService.getMessage(MSG_NO, Locale.getDefault()));
    }

    private void getMessagesWithParams() {
        MessageServiceImplTest.assertEquals((String)VALUE_PARAMS, (String)this.messageService.getMessage(MSG_PARAMS, PARAM_VALUE));
        this.messageService.setLocale(new Locale("fr", "FR"));
        MessageServiceImplTest.assertEquals((String)VALUE_FR_PARAMS, (String)this.messageService.getMessage(MSG_PARAMS, PARAM_VALUE));
        MessageServiceImplTest.assertEquals((String)VALUE_PARAMS, (String)this.messageService.getMessage(MSG_PARAMS, Locale.getDefault(), PARAM_VALUE));
    }
}

