/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.mail.Flags;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImapFolder
implements MailFolder {
    private List<FolderListener> listeners = new LinkedList<FolderListener>();
    protected ServiceRegistry serviceRegistry;
    protected static int MAX_RETRIES = 1;

    public AbstractImapFolder(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected void checkParameter(Object parameter, String name) {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " parameter is null.");
        }
    }

    public long appendMessage(final MimeMessage message, final Flags flags, final Date internalDate) throws FolderException {
        if (this.isReadOnly()) {
            throw new FolderException("Can't append message - Permission denied");
        }
        CommandCallback<Long> command = new CommandCallback<Long>(){

            @Override
            public Long command() throws Throwable {
                return AbstractImapFolder.this.appendMessageInternal(message, flags, internalDate);
            }
        };
        return (Long)command.runFeedback();
    }

    public void copyMessage(final long uid, final MailFolder toFolder) throws FolderException {
        AbstractImapFolder toImapMailFolder = (AbstractImapFolder)toFolder;
        if (toImapMailFolder.isReadOnly()) {
            throw new FolderException("Cannot perform action - Permission denied");
        }
        CommandCallback<Object> command = new CommandCallback<Object>(){

            @Override
            public Object command() throws Throwable {
                AbstractImapFolder.this.copyMessageInternal(uid, toFolder);
                return null;
            }
        };
        command.runFeedback();
    }

    public void deleteAllMessages() throws FolderException {
        CommandCallback<Object> command = new CommandCallback<Object>(){

            @Override
            public Object command() throws Throwable {
                AbstractImapFolder.this.deleteAllMessagesInternal();
                return null;
            }
        };
        command.runFeedback();
    }

    public void expunge() throws FolderException {
        if (this.isReadOnly()) {
            throw new FolderException("Can't expunge - Permission denied");
        }
        CommandCallback<Object> command = new CommandCallback<Object>(){

            @Override
            public Object command() throws Throwable {
                AbstractImapFolder.this.expungeInternal();
                return null;
            }
        };
        command.runFeedback();
    }

    public SimpleStoredMessage getMessage(final long uid) {
        CommandCallback<SimpleStoredMessage> command = new CommandCallback<SimpleStoredMessage>(){

            @Override
            public SimpleStoredMessage command() throws Throwable {
                return AbstractImapFolder.this.getMessageInternal(uid);
            }
        };
        return (SimpleStoredMessage)command.run();
    }

    public List<SimpleStoredMessage> getMessages() {
        CommandCallback<List<SimpleStoredMessage>> command = new CommandCallback<List<SimpleStoredMessage>>(){

            @Override
            public List<SimpleStoredMessage> command() throws Throwable {
                return AbstractImapFolder.this.getMessagesInternal();
            }
        };
        return (List)command.run();
    }

    public List<SimpleStoredMessage> getMessages(final MsgRangeFilter msgRangeFilter) {
        CommandCallback<List<SimpleStoredMessage>> command = new CommandCallback<List<SimpleStoredMessage>>(){

            @Override
            public List<SimpleStoredMessage> command() throws Throwable {
                return AbstractImapFolder.this.getMessagesInternal(msgRangeFilter);
            }
        };
        return (List)command.run();
    }

    public List<SimpleStoredMessage> getNonDeletedMessages() {
        CommandCallback<List<SimpleStoredMessage>> command = new CommandCallback<List<SimpleStoredMessage>>(){

            @Override
            public List<SimpleStoredMessage> command() throws Throwable {
                return AbstractImapFolder.this.getNonDeletedMessagesInternal();
            }
        };
        List result = (List)command.run();
        return result;
    }

    public void replaceFlags(final Flags flags, final long uid, final FolderListener silentListener, final boolean addUid) throws FolderException {
        CommandCallback<Object> command = new CommandCallback<Object>(){

            @Override
            public Object command() throws Throwable {
                AbstractImapFolder.this.replaceFlagsInternal(flags, uid, silentListener, addUid);
                return null;
            }
        };
        command.runFeedback();
    }

    public long[] search(SearchTerm searchTerm) {
        return this.getMessageUids();
    }

    public void setFlags(final Flags flags, final boolean value, final long uid, final FolderListener silentListener, final boolean addUid) throws FolderException {
        CommandCallback<Object> command = new CommandCallback<Object>(){

            @Override
            public Object command() throws Throwable {
                AbstractImapFolder.this.setFlagsInternal(flags, value, uid, silentListener, addUid);
                return null;
            }
        };
        command.runFeedback();
    }

    public void store(MovingMessage mail) throws Exception {
        throw new UnsupportedOperationException("Method store(MovingMessage) is not suppoted.");
    }

    public void store(MimeMessage message) throws Exception {
        throw new UnsupportedOperationException("Method store(MimeMessage) is not suppoted.");
    }

    public void addListener(FolderListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FolderListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalDeletion() {
        List<FolderListener> list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                FolderListener listener = this.listeners.get(i);
                listener.mailboxDeleted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFlagUpdate(int msn, Flags flags, Long uidNotification, FolderListener silentListener) {
        List<FolderListener> list = this.listeners;
        synchronized (list) {
            for (FolderListener listener : this.listeners) {
                if (listener == silentListener) continue;
                listener.flagsUpdated(msn, flags, uidNotification);
            }
        }
    }

    protected abstract boolean isReadOnly();

    protected abstract long appendMessageInternal(MimeMessage var1, Flags var2, Date var3) throws Exception;

    protected abstract void copyMessageInternal(long var1, MailFolder var3) throws Exception;

    protected abstract void deleteAllMessagesInternal() throws Exception;

    protected abstract void expungeInternal() throws Exception;

    protected abstract SimpleStoredMessage getMessageInternal(long var1) throws Exception;

    protected abstract List<SimpleStoredMessage> getMessagesInternal();

    protected abstract List<SimpleStoredMessage> getMessagesInternal(MsgRangeFilter var1);

    protected abstract List<SimpleStoredMessage> getNonDeletedMessagesInternal();

    protected abstract void replaceFlagsInternal(Flags var1, long var2, FolderListener var4, boolean var5) throws Exception;

    protected abstract void setFlagsInternal(Flags var1, boolean var2, long var3, FolderListener var5, boolean var6) throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class CommandCallback<T> {
        protected CommandCallback() {
        }

        public abstract T command() throws Throwable;

        public T runFeedback() throws FolderException {
            return this.runFeedback(false);
        }

        public T runFeedback(boolean readOnly) throws FolderException {
            try {
                RetryingTransactionHelper txHelper = AbstractImapFolder.this.serviceRegistry.getTransactionService().getRetryingTransactionHelper();
                txHelper.setMaxRetries(MAX_RETRIES);
                txHelper.setReadOnly(readOnly);
                Object result = txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<T>(){

                    @Override
                    public T execute() throws Throwable {
                        return CommandCallback.this.command();
                    }
                }, readOnly);
                return (T)result;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                String message = cause != null ? cause.getMessage() : e.getMessage();
                throw new FolderException(message);
            }
        }

        public T run() {
            return this.run(false);
        }

        public T run(boolean readOnly) {
            RetryingTransactionHelper txHelper = AbstractImapFolder.this.serviceRegistry.getTransactionService().getRetryingTransactionHelper();
            txHelper.setMaxRetries(MAX_RETRIES);
            txHelper.setReadOnly(readOnly);
            Object result = txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<T>(){

                @Override
                public T execute() throws Throwable {
                    return CommandCallback.this.command();
                }
            }, readOnly);
            return (T)result;
        }
    }
}

