/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.imap.AbstractImapFolder;
import org.alfresco.repo.imap.AbstractMimeMessage;
import org.alfresco.repo.imap.AlfrescoImapConst;
import org.alfresco.repo.imap.ImapModelMessage;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.IncomingImapMessage;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.GUID;
import org.alfresco.util.Utf7;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoImapFolder
extends AbstractImapFolder
implements Serializable {
    private static final long serialVersionUID = -7223111284066976111L;
    private static Log logger = LogFactory.getLog(AlfrescoImapFolder.class);
    private final FileInfo folderInfo;
    private final String folderName;
    private final String folderPath;
    private final String userName;
    private final int mountPointId;
    private final AlfrescoImapConst.ImapViewMode viewMode;
    private final ImapService imapService;
    private final boolean selectable;
    private final boolean extractAttachmentsEnabled;
    private ImapService.FolderStatus folderStatus;
    private static final Flags PERMANENT_FLAGS = new Flags();

    public boolean isExtractAttachmentsEnabled() {
        return this.extractAttachmentsEnabled;
    }

    AlfrescoImapFolder(String userName, ServiceRegistry serviceRegistry) {
        this(null, userName, "", "", null, serviceRegistry, false, false, 0);
    }

    public AlfrescoImapFolder(FileInfo folderInfo, String userName, String folderName, String folderPath, AlfrescoImapConst.ImapViewMode viewMode, boolean extractAttachmentsEnabled, ServiceRegistry serviceRegistry, int mountPointId) {
        this(folderInfo, userName, folderName, folderPath, viewMode, serviceRegistry, null, extractAttachmentsEnabled, mountPointId);
    }

    public AlfrescoImapFolder(FileInfo folderInfo, String userName, String folderName, String folderPath, AlfrescoImapConst.ImapViewMode viewMode, ServiceRegistry serviceRegistry, Boolean selectable, boolean extractAttachmentsEnabled, int mountPointId) {
        super(serviceRegistry);
        Boolean storedSelectable;
        this.folderInfo = folderInfo;
        this.userName = userName;
        this.folderName = folderName != null ? folderName : (folderInfo != null ? folderInfo.getName() : null);
        this.folderPath = folderPath;
        this.viewMode = viewMode != null ? viewMode : AlfrescoImapConst.ImapViewMode.ARCHIVE;
        this.extractAttachmentsEnabled = extractAttachmentsEnabled;
        this.imapService = serviceRegistry.getImapService();
        this.selectable = folderInfo != null ? (selectable == null ? ((storedSelectable = Boolean.valueOf(!serviceRegistry.getNodeService().hasAspect(folderInfo.getNodeRef(), ImapModel.ASPECT_IMAP_FOLDER_NONSELECTABLE))) == null ? true : storedSelectable) : selectable) : false;
        this.mountPointId = mountPointId;
    }

    public String getFullName() {
        return Utf7.encode("#mail/" + this.userName + '/' + this.getFolderPath(), "X-MODIFIED-UTF-7");
    }

    public String getName() {
        return this.folderName;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    private NavigableMap<Long, FileInfo> searchMails() {
        return this.getFolderStatus().search;
    }

    public boolean reset() {
        this.folderStatus = null;
        return (Boolean)new AbstractImapFolder.CommandCallback<Boolean>(){

            @Override
            public Boolean command() throws Throwable {
                return AlfrescoImapFolder.this.serviceRegistry.getNodeService().exists(AlfrescoImapFolder.this.folderInfo.getNodeRef());
            }
        }.run(true);
    }

    protected ImapService.FolderStatus getFolderStatus() {
        if (this.folderStatus == null) {
            AbstractImapFolder.CommandCallback<ImapService.FolderStatus> command = new AbstractImapFolder.CommandCallback<ImapService.FolderStatus>(){

                @Override
                public ImapService.FolderStatus command() throws Throwable {
                    return AlfrescoImapFolder.this.imapService.getFolderStatus(AlfrescoImapFolder.this.userName, AlfrescoImapFolder.this.folderInfo.getNodeRef(), AlfrescoImapFolder.this.viewMode);
                }
            };
            this.folderStatus = (ImapService.FolderStatus)command.run();
        }
        return this.folderStatus;
    }

    @Override
    protected long appendMessageInternal(MimeMessage message, Flags flags, Date internalDate) throws FileExistsException, FileNotFoundException, IOException, MessagingException {
        long uid = this.createMimeMessageInFolder(this.folderInfo, message, flags);
        this.folderStatus = null;
        return uid;
    }

    @Override
    protected void copyMessageInternal(long uid, MailFolder toFolder) throws MessagingException, FileExistsException, FileNotFoundException, IOException {
        AlfrescoImapFolder toImapMailFolder = (AlfrescoImapFolder)toFolder;
        NodeRef destFolderNodeRef = toImapMailFolder.getFolderInfo().getNodeRef();
        FileInfo sourceMessageFileInfo = (FileInfo)this.searchMails().get(uid);
        if (this.serviceRegistry.getNodeService().hasAspect(sourceMessageFileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) {
            ImapModelMessage newMessage = new ImapModelMessage(sourceMessageFileInfo, this.serviceRegistry, true);
            toImapMailFolder.appendMessageInternal(newMessage, this.imapService.getFlags(sourceMessageFileInfo), new Date());
        } else {
            this.serviceRegistry.getFileFolderService().copy(sourceMessageFileInfo.getNodeRef(), destFolderNodeRef, null);
        }
    }

    @Override
    public void deleteAllMessagesInternal() throws FolderException {
        if (this.isReadOnly()) {
            throw new FolderException("Can't delete all - Permission denied");
        }
        for (Map.Entry entry : this.searchMails().entrySet()) {
            this.imapService.setFlag((FileInfo)entry.getValue(), Flags.Flag.DELETED, true);
        }
    }

    @Override
    protected void expungeInternal() throws FolderException {
        if (this.isReadOnly()) {
            throw new FolderException("Can't expunge - Permission denied");
        }
        for (Map.Entry entry : this.searchMails().entrySet()) {
            this.imapService.expungeMessage((FileInfo)entry.getValue());
        }
    }

    public int getFirstUnseen() {
        return this.getFolderStatus().firstUnseen;
    }

    @Override
    protected SimpleStoredMessage getMessageInternal(long uid) throws MessagingException {
        FileInfo mesInfo;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[getMessageInternal] " + this));
        }
        if ((mesInfo = (FileInfo)this.searchMails().get(uid)) == null) {
            return null;
        }
        return this.imapService.getMessage(mesInfo);
    }

    public int getMessageCount() {
        return this.getFolderStatus().messageCount;
    }

    public long[] getMessageUids() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[getMessageUidsInternal] " + this));
        }
        Set uidSet = this.searchMails().keySet();
        long[] uids = new long[uidSet.size()];
        int i = 0;
        for (Long uid : uidSet) {
            uids[i++] = uid;
        }
        return uids;
    }

    @Override
    protected List<SimpleStoredMessage> getMessagesInternal() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[getMessagesInternal] " + this));
        }
        return this.convertToMessages(this.searchMails().values());
    }

    private List<SimpleStoredMessage> convertToMessages(Collection<FileInfo> fileInfos) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[convertToMessages] " + this));
        }
        if (fileInfos == null || fileInfos.size() == 0) {
            logger.debug((Object)"[convertToMessages] - fileInfos is empty or null");
            return Collections.emptyList();
        }
        LinkedList<SimpleStoredMessage> result = new LinkedList<SimpleStoredMessage>();
        for (FileInfo fileInfo : fileInfos) {
            try {
                result.add(this.imapService.createImapMessage(fileInfo, false));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("[convertToMessages] Message added: " + fileInfo.getName()));
            }
            catch (MessagingException e) {
                logger.warn((Object)("[convertToMessages] Invalid message! File name:" + fileInfo.getName()), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    protected List<SimpleStoredMessage> getMessagesInternal(MsgRangeFilter msgRangeFilter) {
        throw new UnsupportedOperationException("IMAP implementation doesn't support POP3 requests");
    }

    public int getMsn(long uid) throws FolderException {
        NavigableMap<Long, FileInfo> messages = this.searchMails();
        if (!messages.containsKey(uid)) {
            throw new FolderException("No such message.");
        }
        return messages.headMap(uid, true).size();
    }

    @Override
    protected List<SimpleStoredMessage> getNonDeletedMessagesInternal() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[getNonDeletedMessagesInternal] " + this));
        }
        ArrayList<SimpleStoredMessage> result = new ArrayList<SimpleStoredMessage>();
        List<SimpleStoredMessage> values = this.getMessagesInternal();
        for (SimpleStoredMessage message : values) {
            if (this.getFlags(message).contains(Flags.Flag.DELETED)) continue;
            result.add(message);
        }
        if (logger.isDebugEnabled() && this.folderInfo != null) {
            logger.debug((Object)(this.folderInfo.getName() + " - Non deleted messages count:" + result.size()));
        }
        return result;
    }

    public Flags getPermanentFlags() {
        return PERMANENT_FLAGS;
    }

    public int getRecentCount(boolean reset) {
        int recent = this.getFolderStatus().recentCount;
        if (reset && recent > 0) {
            AbstractImapFolder.CommandCallback<Void> command = new AbstractImapFolder.CommandCallback<Void>(){

                @Override
                public Void command() throws Throwable {
                    for (FileInfo fileInfo : ((AlfrescoImapFolder)AlfrescoImapFolder.this).folderStatus.search.values()) {
                        Flags flags = AlfrescoImapFolder.this.imapService.getFlags(fileInfo);
                        if (!flags.contains(Flags.Flag.RECENT)) continue;
                        AlfrescoImapFolder.this.imapService.setFlag(fileInfo, Flags.Flag.RECENT, false);
                    }
                    return null;
                }
            };
            command.run();
        }
        return recent;
    }

    public long getUidNext() {
        NavigableMap<Long, FileInfo> search = this.getFolderStatus().search;
        return search.isEmpty() ? 1L : (Long)search.lastKey() + 1L;
    }

    public long getUidValidity() {
        return this.getFolderStatus().uidValidity + (long)this.mountPointId;
    }

    public int getUnseenCount() {
        return this.getFolderStatus().unseenCount;
    }

    @Override
    protected void replaceFlagsInternal(Flags flags, long uid, FolderListener silentListener, boolean addUid) throws FolderException, MessagingException {
        int msn = this.getMsn(uid);
        FileInfo fileInfo = (FileInfo)this.searchMails().get(uid);
        this.imapService.setFlags(fileInfo, MessageFlags.ALL_FLAGS, false);
        this.imapService.setFlags(fileInfo, flags, true);
        Long uidNotification = addUid ? Long.valueOf(uid) : null;
        this.notifyFlagUpdate(msn, flags, uidNotification, silentListener);
    }

    @Override
    protected void setFlagsInternal(Flags flags, boolean value, long uid, FolderListener silentListener, boolean addUid) throws MessagingException, FolderException {
        int msn = this.getMsn(uid);
        FileInfo fileInfo = (FileInfo)this.searchMails().get(uid);
        this.imapService.setFlags(fileInfo, flags, value);
        Long uidNotification = null;
        if (addUid) {
            uidNotification = new Long(uid);
        }
        this.notifyFlagUpdate(msn, flags, uidNotification, silentListener);
    }

    private Flags getFlags(SimpleStoredMessage mess) {
        return ((AbstractMimeMessage)mess.getMimeMessage()).getFlags();
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public FileInfo getFolderInfo() {
        return this.folderInfo;
    }

    public boolean isMarked() {
        ImapService.FolderStatus folderStatus = this.getFolderStatus();
        return folderStatus.recentCount > 0 || folderStatus.unseenCount > 0;
    }

    @Override
    protected boolean isReadOnly() {
        AccessStatus status = this.serviceRegistry.getPublicServiceAccessService().hasAccess(ServiceRegistry.NODE_SERVICE.getLocalName(), "createNode", this.folderInfo.getNodeRef(), null, null, null);
        return status == AccessStatus.DENIED;
    }

    public AlfrescoImapConst.ImapViewMode getViewMode() {
        return this.viewMode;
    }

    private long createMimeMessageInFolder(FileInfo folderFileInfo, MimeMessage message, Flags flags) throws FileExistsException, FileNotFoundException, IOException, MessagingException {
        String name = "Message_" + GUID.generate();
        FileFolderService fileFolderService = this.serviceRegistry.getFileFolderService();
        FileInfo messageFile = fileFolderService.create(folderFileInfo.getNodeRef(), name, ContentModel.TYPE_CONTENT);
        long newMessageUid = (Long)messageFile.getProperties().get(ContentModel.PROP_NODE_DBID);
        name = "Message_" + newMessageUid + ".eml";
        fileFolderService.rename(messageFile.getNodeRef(), name);
        Flags newFlags = new Flags(flags);
        newFlags.add(Flags.Flag.RECENT);
        this.imapService.setFlags(messageFile, newFlags, true);
        if (this.extractAttachmentsEnabled) {
            this.imapService.extractAttachments(folderFileInfo.getNodeRef(), messageFile.getNodeRef(), message);
        }
        new IncomingImapMessage(messageFile, this.serviceRegistry, message);
        return newMessageUid;
    }

    static {
        PERMANENT_FLAGS.add(Flags.Flag.ANSWERED);
        PERMANENT_FLAGS.add(Flags.Flag.DELETED);
        PERMANENT_FLAGS.add(Flags.Flag.DRAFT);
        PERMANENT_FLAGS.add(Flags.Flag.FLAGGED);
        PERMANENT_FLAGS.add(Flags.Flag.SEEN);
    }
}

