/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;

public class ImapContentPolicy {
    private ActionService actionService;
    private PolicyComponent policyComponent;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"actionService", (Object)this.getActionService());
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.getPolicyComponent());
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, ImapModel.ASPECT_IMAP_CONTENT, (Behaviour)new JavaBehaviour(this, "onAddAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.getPolicyComponent().bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ImapModel.ASPECT_IMAP_CONTENT, (Behaviour)new JavaBehaviour(this, "getCopyCallback", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        Action action;
        if (aspectTypeQName.equals((Object)ImapModel.ASPECT_IMAP_CONTENT) && (action = this.getActionService().createAction("extract-metadata")) != null) {
            this.getActionService().executeAction(action, nodeRef);
        }
    }

    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return ImapContentCopyBehaviourCallback.INSTANCE;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public ActionService getActionService() {
        return this.actionService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImapContentCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new ImapContentCopyBehaviourCallback();

        private ImapContentCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            return Collections.emptyMap();
        }

        @Override
        public Pair<CopyBehaviourCallback.AssocCopySourceAction, CopyBehaviourCallback.AssocCopyTargetAction> getAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyAssociationDetails assocCopyDetails) {
            return new Pair((Object)CopyBehaviourCallback.AssocCopySourceAction.IGNORE, (Object)CopyBehaviourCallback.AssocCopyTargetAction.USE_COPIED_OTHERWISE_ORIGINAL_TARGET);
        }
    }
}

