/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.imap.AlfrescoImapConst;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ContentModelMessage;
import org.alfresco.repo.imap.ImapModelMessage;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.config.ImapConfigMountPointsBean;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.model.SubFolderFilter;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.MaxSizeMap;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.HMEFMessage;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapServiceImpl
implements ImapService,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteChildAssociationPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private Log logger = LogFactory.getLog(ImapServiceImpl.class);
    private static final String ERROR_FOLDER_ALREADY_EXISTS = "imap.server.error.folder_already_exist";
    private static final String ERROR_MAILBOX_NAME_IS_MANDATORY = "imap.server.error.mailbox_name_is_mandatory";
    private static final String ERROR_CANNOT_GET_A_FOLDER = "imap.server.error.cannot_get_a_folder";
    private static final String ERROR_CANNOT_PARSE_DEFAULT_EMAIL = "imap.server.error.cannot_parse_default_email";
    private static final String CHECKED_NODES = "imap.flaggable.aspect.checked.list";
    private static final String FAVORITE_SITES = "imap.favorite.sites.list";
    private static final String UIDVALIDITY_TRANSACTION_LISTENER = "imap.uidvalidity.txn.listener";
    private SysAdminParams sysAdminParams;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private PermissionService permissionService;
    private ServiceRegistry serviceRegistry;
    private BehaviourFilter policyBehaviourFilter;
    private MimetypeService mimetypeService;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private Map<Pair<String, String>, ImapService.FolderStatus> folderCache;
    private int folderCacheSize = 1000;
    private ReentrantReadWriteLock folderCacheLock = new ReentrantReadWriteLock();
    private SimpleCache<NodeRef, CacheItem> messageCache;
    private Map<String, ImapConfigMountPointsBean> imapConfigMountPoints;
    private Map<String, Integer> mountPointIds;
    private RepositoryFolderConfigBean[] ignoreExtractionFoldersBeans;
    private RepositoryFolderConfigBean imapHomeConfigBean;
    private NodeRef imapHomeNodeRef;
    private Set<NodeRef> ignoreExtractionFolders;
    private String defaultFromAddress;
    private String defaultToAddress;
    private String repositoryTemplatePath;
    private boolean extractAttachmentsEnabled = true;
    private Map<ImapService.EmailBodyFormat, String> defaultBodyTemplates;
    private static final Map<QName, Flags.Flag> qNameToFlag = new HashMap<QName, Flags.Flag>();
    private static final Map<Flags.Flag, QName> flagToQname;
    private boolean imapServerEnabled = false;

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setMessageCache(SimpleCache<NodeRef, CacheItem> messageCache) {
        this.messageCache = messageCache;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setPolicyFilter(BehaviourFilter policyFilter) {
        this.policyBehaviourFilter = policyFilter;
    }

    public void setImapHome(RepositoryFolderConfigBean imapHomeConfigBean) {
        this.imapHomeConfigBean = imapHomeConfigBean;
    }

    public void setFolderCacheSize(int folderCacheSize) {
        this.folderCacheSize = folderCacheSize;
    }

    @Override
    public String getDefaultFromAddress() {
        return this.defaultFromAddress;
    }

    public void setDefaultFromAddress(String defaultFromAddress) {
        this.defaultFromAddress = defaultFromAddress;
    }

    @Override
    public String getDefaultToAddress() {
        return this.defaultToAddress;
    }

    public void setDefaultToAddress(String defaultToAddress) {
        this.defaultToAddress = defaultToAddress;
    }

    @Override
    public String getWebApplicationContextUrl() {
        return this.sysAdminParams.getAlfrescoProtocol() + "://" + this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort() + "/" + this.sysAdminParams.getAlfrescoContext();
    }

    @Override
    public String getShareApplicationContextUrl() {
        return this.sysAdminParams.getShareProtocol() + "://" + this.sysAdminParams.getShareHost() + ":" + this.sysAdminParams.getSharePort() + "/" + this.sysAdminParams.getShareContext();
    }

    @Override
    public String getRepositoryTemplatePath() {
        return this.repositoryTemplatePath;
    }

    public void setRepositoryTemplatePath(String repositoryTemplatePath) {
        this.repositoryTemplatePath = repositoryTemplatePath;
    }

    public void setImapConfigMountPoints(ImapConfigMountPointsBean[] imapConfigMountPointsBeans) {
        this.imapConfigMountPoints = new LinkedHashMap<String, ImapConfigMountPointsBean>(imapConfigMountPointsBeans.length * 2);
        this.mountPointIds = new HashMap<String, Integer>(imapConfigMountPointsBeans.length * 2);
        for (int i = 0; i < imapConfigMountPointsBeans.length; ++i) {
            String name = imapConfigMountPointsBeans[i].getMountPointName();
            this.imapConfigMountPoints.put(name, imapConfigMountPointsBeans[i]);
            this.mountPointIds.put(name, i + 1);
        }
    }

    public void setIgnoreExtractionFolders(RepositoryFolderConfigBean[] ignoreExtractionFolders) {
        this.ignoreExtractionFoldersBeans = ignoreExtractionFolders;
    }

    public void setExtractAttachmentsEnabled(boolean extractAttachmentsEnabled) {
        this.extractAttachmentsEnabled = extractAttachmentsEnabled;
    }

    public void setImapServerEnabled(boolean enabled) {
        this.imapServerEnabled = enabled;
    }

    @Override
    public boolean getImapServerEnabled() {
        return this.imapServerEnabled;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"imapConfigMountPoints", this.imapConfigMountPoints);
        PropertyCheck.mandatory((Object)this, (String)"ignoreExtractionFoldersBeans", (Object)this.ignoreExtractionFoldersBeans);
        PropertyCheck.mandatory((Object)this, (String)"imapHome", (Object)this.imapHomeConfigBean);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        PropertyCheck.mandatory((Object)this, (String)"defaultFromAddress", (Object)this.defaultFromAddress);
        PropertyCheck.mandatory((Object)this, (String)"defaultToAddress", (Object)this.defaultToAddress);
        PropertyCheck.mandatory((Object)this, (String)"repositoryTemplatePath", (Object)this.repositoryTemplatePath);
        PropertyCheck.mandatory((Object)this, (String)"policyBehaviourFilter", (Object)this.policyBehaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"mimetypeService", (Object)this.mimetypeService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.getSearchService());
        this.folderCache = new MaxSizeMap(this.folderCacheSize, false);
        try {
            InternetAddress.parse((String)this.defaultFromAddress);
        }
        catch (AddressException ex) {
            throw new AlfrescoRuntimeException(ERROR_CANNOT_PARSE_DEFAULT_EMAIL, new Object[]{this.defaultFromAddress});
        }
        try {
            InternetAddress.parse((String)this.defaultToAddress);
        }
        catch (AddressException ex) {
            throw new AlfrescoRuntimeException(ERROR_CANNOT_PARSE_DEFAULT_EMAIL, new Object[]{this.defaultToAddress});
        }
    }

    public void startup() {
        this.bindBehaviour();
        this.ignoreExtractionFolders = new HashSet<NodeRef>(this.ignoreExtractionFoldersBeans.length * 2);
        for (RepositoryFolderConfigBean ignoreExtractionFoldersBean : this.ignoreExtractionFoldersBeans) {
            NodeRef nodeRef = ignoreExtractionFoldersBean.getFolderPath(this.namespaceService, this.nodeService, this.searchService, this.fileFolderService);
            if (this.ignoreExtractionFolders.add(nodeRef)) continue;
            throw new AlfrescoRuntimeException("The folder extraction path has been referenced already: \n   Folder: " + ignoreExtractionFoldersBean);
        }
        this.imapHomeNodeRef = this.imapHomeConfigBean.getOrCreateFolderPath(this.namespaceService, this.nodeService, this.searchService, this.fileFolderService);
    }

    public void shutdown() {
    }

    protected void startupInTxn(boolean force) {
        if (force || this.getImapServerEnabled()) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    List<AlfrescoImapFolder> mailboxes = ImapServiceImpl.this.serviceRegistry.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<AlfrescoImapFolder>>(){

                        @Override
                        public List<AlfrescoImapFolder> execute() throws Throwable {
                            ImapServiceImpl.this.startup();
                            LinkedList<AlfrescoImapFolder> result = new LinkedList<AlfrescoImapFolder>();
                            for (String mountPointName : ImapServiceImpl.this.imapConfigMountPoints.keySet()) {
                                result.addAll(ImapServiceImpl.this.listMailboxes(new AlfrescoImapUser(null, AuthenticationUtil.getSystemUserName(), null), mountPointName + "*", false));
                            }
                            return result;
                        }
                    });
                    for (AlfrescoImapFolder mailbox : mailboxes) {
                        mailbox.getUidNext();
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    protected void bindBehaviour() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"[bindBeahaviour] Binding behaviours");
        }
        PolicyComponent policyComponent = (PolicyComponent)this.serviceRegistry.getService(QName.createQName((String)"http://www.alfresco.org", (String)"policyComponent"));
        policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, ImapModel.ASPECT_IMAP_FOLDER, ContentModel.ASSOC_CONTAINS, new JavaBehaviour(this, "onCreateChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnDeleteChildAssociationPolicy.QNAME, ImapModel.ASPECT_IMAP_FOLDER, ContentModel.ASSOC_CONTAINS, new JavaBehaviour(this, "onDeleteChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onUpdateProperties", Behaviour.NotificationFrequency.EVERY_EVENT));
        policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    @Override
    public SimpleStoredMessage getMessage(FileInfo mesInfo) throws MessagingException {
        NodeRef nodeRef = mesInfo.getNodeRef();
        Date modified = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
        if (modified != null) {
            CacheItem cached = (CacheItem)this.messageCache.get((Serializable)nodeRef);
            if (cached != null && cached.getModified().equals(modified)) {
                return cached.getMessage();
            }
            SimpleStoredMessage message = this.createImapMessage(mesInfo, true);
            this.messageCache.put((Serializable)nodeRef, (Object)new CacheItem(modified, message));
            return message;
        }
        SimpleStoredMessage message = this.createImapMessage(mesInfo, true);
        return message;
    }

    @Override
    public SimpleStoredMessage createImapMessage(FileInfo fileInfo, boolean generateBody) throws MessagingException {
        Long key = (Long)fileInfo.getProperties().get(ContentModel.PROP_NODE_DBID);
        if (this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) {
            return new SimpleStoredMessage((MimeMessage)new ImapModelMessage(fileInfo, this.serviceRegistry, generateBody), new Date(), key.longValue());
        }
        return new SimpleStoredMessage((MimeMessage)new ContentModelMessage(fileInfo, this.serviceRegistry, generateBody), new Date(), key.longValue());
    }

    @Override
    public void expungeMessage(FileInfo fileInfo) {
        Flags flags = this.getFlags(fileInfo);
        if (flags.contains(Flags.Flag.DELETED)) {
            this.fileFolderService.delete(fileInfo.getNodeRef());
            this.messageCache.remove((Serializable)fileInfo.getNodeRef());
        }
    }

    @Override
    public AlfrescoImapFolder getOrCreateMailbox(AlfrescoImapUser user, String mailboxName, boolean mayExist, boolean mayCreate) {
        FileInfo mailFolder;
        List<String> pathElements;
        NodeRef root;
        if (mailboxName == null) {
            throw new IllegalArgumentException(I18NUtil.getMessage((String)ERROR_MAILBOX_NAME_IS_MANDATORY));
        }
        if (mailboxName.length() == 0) {
            return new AlfrescoImapFolder(user.getLogin(), this.serviceRegistry);
        }
        AlfrescoImapConst.ImapViewMode viewMode = AlfrescoImapConst.ImapViewMode.ARCHIVE;
        int index = mailboxName.indexOf(47);
        int mountPointId = 0;
        if (index < 0) {
            root = this.getUserImapHomeRef(user.getLogin());
            pathElements = Collections.singletonList(mailboxName);
        } else {
            String rootPath = mailboxName.substring(0, index);
            ImapConfigMountPointsBean imapConfigMountPoint = this.imapConfigMountPoints.get(rootPath);
            if (imapConfigMountPoint != null) {
                mountPointId = this.mountPointIds.get(rootPath);
                root = imapConfigMountPoint.getFolderPath(this.serviceRegistry.getNamespaceService(), this.nodeService, this.searchService, this.fileFolderService);
                pathElements = Arrays.asList(mailboxName.substring(index + 1).split(String.valueOf('/')));
                viewMode = imapConfigMountPoint.getMode();
            } else {
                root = this.getUserImapHomeRef(user.getLogin());
                pathElements = Arrays.asList(mailboxName.split(String.valueOf('/')));
            }
        }
        try {
            mailFolder = this.fileFolderService.resolveNamePath(root, pathElements, !mayCreate);
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException(ERROR_CANNOT_GET_A_FOLDER, (Object[])new String[]{mailboxName});
        }
        if (mailFolder == null) {
            if (!mayCreate) {
                throw new AlfrescoRuntimeException(ERROR_CANNOT_GET_A_FOLDER, (Object[])new String[]{mailboxName});
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating mailbox: " + mailboxName));
            }
            mailFolder = FileFolderUtil.makeFolders(this.fileFolderService, root, pathElements, ContentModel.TYPE_FOLDER);
        } else if (!mayExist) {
            throw new AlfrescoRuntimeException(ERROR_FOLDER_ALREADY_EXISTS);
        }
        return new AlfrescoImapFolder(mailFolder, user.getLogin(), pathElements.get(pathElements.size() - 1), mailboxName, viewMode, this.serviceRegistry, true, this.isExtractionEnabled(mailFolder.getNodeRef()), mountPointId);
    }

    @Override
    public void deleteMailbox(AlfrescoImapUser user, String mailboxName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleting mailbox: mailboxName=" + mailboxName));
        }
        if (mailboxName == null) {
            throw new IllegalArgumentException(I18NUtil.getMessage((String)ERROR_MAILBOX_NAME_IS_MANDATORY));
        }
        AlfrescoImapFolder folder = this.getOrCreateMailbox(user, mailboxName, true, false);
        NodeRef nodeRef = folder.getFolderInfo().getNodeRef();
        List<FileInfo> childFolders = this.fileFolderService.listFolders(nodeRef);
        if (childFolders.isEmpty()) {
            folder.signalDeletion();
            this.fileFolderService.delete(nodeRef);
        } else if (folder.isSelectable()) {
            List<FileInfo> messages = this.fileFolderService.listFiles(nodeRef);
            for (FileInfo message : messages) {
                this.fileFolderService.delete(message.getNodeRef());
            }
            this.nodeService.addAspect(nodeRef, ImapModel.ASPECT_IMAP_FOLDER_NONSELECTABLE, null);
        } else {
            throw new AlfrescoRuntimeException(mailboxName + " - Can't delete a non-selectable store with children.");
        }
    }

    @Override
    public void renameMailbox(AlfrescoImapUser user, String oldMailboxName, String newMailboxName) {
        String newMailName;
        NodeRef newMailParent;
        int index;
        if (oldMailboxName == null || newMailboxName == null) {
            throw new IllegalArgumentException(ERROR_MAILBOX_NAME_IS_MANDATORY);
        }
        AlfrescoImapFolder sourceNode = this.getOrCreateMailbox(user, oldMailboxName, true, false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Renaming folder oldMailboxName=" + oldMailboxName + " newMailboxName=" + newMailboxName));
        }
        if ((index = newMailboxName.lastIndexOf(47)) < 0) {
            newMailParent = this.getUserImapHomeRef(user.getLogin());
            newMailName = newMailboxName;
        } else {
            newMailParent = this.getOrCreateMailbox(user, newMailboxName.substring(0, index), true, true).getFolderInfo().getNodeRef();
            newMailName = newMailboxName.substring(index + 1);
        }
        try {
            if (oldMailboxName.equalsIgnoreCase("INBOX")) {
                this.fileFolderService.copy(sourceNode.getFolderInfo().getNodeRef(), newMailParent, "INBOX");
            } else {
                this.fileFolderService.move(sourceNode.getFolderInfo().getNodeRef(), newMailParent, newMailName);
            }
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (FileExistsException e) {
            throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImapService.FolderStatus getFolderStatus(String userName, final NodeRef contextNodeRef, AlfrescoImapConst.ImapViewMode viewMode) {
        ImapService.FolderStatus result;
        TreeMap<Long, FileInfo> currentSearch;
        Pair cacheKey;
        String changeToken;
        block26: {
            Long uidValidity;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("getFolderStatus contextNodeRef=" + contextNodeRef + ", viewMode=" + (Object)((Object)viewMode)));
            }
            changeToken = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                public String doWork() throws Exception {
                    return (String)((Object)ImapServiceImpl.this.nodeService.getProperty(contextNodeRef, ImapModel.PROP_CHANGE_TOKEN));
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            cacheKey = null;
            if (changeToken != null) {
                block25: {
                    cacheKey = new Pair((Object)userName, (Object)changeToken);
                    this.folderCacheLock.readLock().lock();
                    try {
                        ImapService.FolderStatus result2 = this.folderCache.get(cacheKey);
                        if (result2 == null) break block25;
                        ImapService.FolderStatus folderStatus = result2;
                        Object var9_9 = null;
                        this.folderCacheLock.readLock().unlock();
                        return folderStatus;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        this.folderCacheLock.readLock().unlock();
                        throw throwable;
                    }
                }
                Object var9_10 = null;
                this.folderCacheLock.readLock().unlock();
            }
            List<FileInfo> fileInfos = null;
            FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.imap);
            try {
                fileInfos = this.fileFolderService.listFiles(contextNodeRef);
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                FileFilterMode.clearClient();
                throw throwable;
            }
            FileFilterMode.clearClient();
            currentSearch = new TreeMap<Long, FileInfo>();
            switch (viewMode) {
                case MIXED: {
                    for (FileInfo fileInfo : fileInfos) {
                        currentSearch.put((Long)fileInfo.getProperties().get(ContentModel.PROP_NODE_DBID), fileInfo);
                    }
                    break;
                }
                case ARCHIVE: {
                    for (FileInfo fileInfo : fileInfos) {
                        if (!this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) continue;
                        currentSearch.put((Long)fileInfo.getProperties().get(ContentModel.PROP_NODE_DBID), fileInfo);
                    }
                    break;
                }
                case VIRTUAL: {
                    for (FileInfo fileInfo : fileInfos) {
                        if (this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) continue;
                        currentSearch.put((Long)fileInfo.getProperties().get(ContentModel.PROP_NODE_DBID), fileInfo);
                    }
                    break;
                }
            }
            int messageCount = currentSearch.size();
            int recentCount = 0;
            int unseenCount = 0;
            int firstUnseen = 0;
            int i = 1;
            for (FileInfo fileInfo : currentSearch.values()) {
                Flags flags = this.getFlags(fileInfo);
                if (flags.contains(Flags.Flag.RECENT)) {
                    ++recentCount;
                }
                if (!flags.contains(Flags.Flag.SEEN)) {
                    if (firstUnseen == 0) {
                        firstUnseen = i;
                    }
                    ++unseenCount;
                }
                ++i;
            }
            if (changeToken == null) {
                changeToken = GUID.generate();
                cacheKey = new Pair((Object)userName, (Object)changeToken);
                final String finalToken = changeToken;
                this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        ImapServiceImpl.this.nodeService.setProperty(contextNodeRef, ImapModel.PROP_CHANGE_TOKEN, (Serializable)((Object)finalToken));
                        ImapServiceImpl.this.nodeService.setProperty(contextNodeRef, ImapModel.PROP_MAXUID, (Serializable)Long.valueOf(currentSearch.isEmpty() ? 0L : (Long)currentSearch.lastKey()));
                        return null;
                    }
                });
            }
            result = new ImapService.FolderStatus(messageCount, recentCount, firstUnseen, unseenCount, (uidValidity = (Long)this.nodeService.getProperty(contextNodeRef, ImapModel.PROP_UIDVALIDITY)) == null ? 0L : uidValidity, changeToken, currentSearch);
            this.folderCacheLock.writeLock().lock();
            try {
                ImapService.FolderStatus oldResult = this.folderCache.get(cacheKey);
                if (oldResult == null) break block26;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("At end of getFolderStatus. Found info in cache, changeToken:" + changeToken));
                }
                ImapService.FolderStatus folderStatus = oldResult;
                Object var18_27 = null;
                this.folderCacheLock.writeLock().unlock();
                return folderStatus;
            }
            catch (Throwable throwable) {
                Object var18_29 = null;
                this.folderCacheLock.writeLock().unlock();
                throw throwable;
            }
        }
        this.folderCache.put((Pair<String, String>)cacheKey, result);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("At end of getFolderStatus. Found files:" + currentSearch.size() + ", changeToken:" + changeToken));
        }
        ImapService.FolderStatus folderStatus = result;
        Object var18_28 = null;
        this.folderCacheLock.writeLock().unlock();
        return folderStatus;
    }

    @Override
    public void subscribe(AlfrescoImapUser user, String mailbox) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Subscribing: " + user + ", " + mailbox));
        }
        AlfrescoImapFolder mailFolder = this.getOrCreateMailbox(user, mailbox, true, false);
        this.nodeService.removeAspect(mailFolder.getFolderInfo().getNodeRef(), ImapModel.ASPECT_IMAP_FOLDER_NONSUBSCRIBED);
    }

    @Override
    public void unsubscribe(AlfrescoImapUser user, String mailbox) {
        AlfrescoImapFolder mailFolder;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unsubscribing: " + user + ", " + mailbox));
        }
        if ((mailFolder = this.getOrCreateMailbox(user, mailbox, true, false)).getFolderInfo() != null) {
            this.logger.debug((Object)"Unsubscribing by ASPECT_IMAP_FOLDER_NONSUBSCRIBED");
            this.nodeService.addAspect(mailFolder.getFolderInfo().getNodeRef(), ImapModel.ASPECT_IMAP_FOLDER_NONSUBSCRIBED, null);
        } else {
            this.logger.debug((Object)"Unable to find folder to unsubscribe");
        }
    }

    @Override
    public Flags getFlags(FileInfo messageInfo) {
        Flags flags = new Flags();
        Map props = this.nodeService.getProperties(messageInfo.getNodeRef());
        for (QName key : qNameToFlag.keySet()) {
            Boolean value = (Boolean)props.get(key);
            if (value == null || !value.booleanValue()) continue;
            flags.add(qNameToFlag.get(key));
        }
        return flags;
    }

    @Override
    public void setFlags(FileInfo messageInfo, Flags flags, boolean value) {
        this.checkForFlaggableAspect(messageInfo.getNodeRef());
        for (Flags.Flag flag : flags.getSystemFlags()) {
            this.setFlag(messageInfo, flag, value);
        }
    }

    @Override
    public void setFlag(FileInfo messageInfo, Flags.Flag flag, boolean value) {
        this.setFlag(messageInfo.getNodeRef(), flag, value);
    }

    private void setFlag(NodeRef nodeRef, Flags.Flag flag, boolean value) {
        this.checkForFlaggableAspect(nodeRef);
        AccessStatus status = this.permissionService.hasPermission(nodeRef, "WriteProperties");
        if (status == AccessStatus.DENIED) {
            this.logger.debug((Object)("[setFlag] Access denied to add FLAG to " + nodeRef));
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("set flag nodeRef:" + nodeRef + ",flag:" + flagToQname.get(flag) + ", value:" + value));
            }
            this.nodeService.setProperty(nodeRef, flagToQname.get(flag), (Serializable)Boolean.valueOf(value));
        }
        this.messageCache.remove((Serializable)nodeRef);
    }

    @Override
    public List<AlfrescoImapFolder> listMailboxes(AlfrescoImapUser user, String mailboxPattern, boolean listSubscribed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[listMailboxes] user:" + user.getLogin() + ", mailboxPattern:" + mailboxPattern + ", listSubscribed:" + listSubscribed));
        }
        LinkedList<AlfrescoImapFolder> result = new LinkedList<AlfrescoImapFolder>();
        int index = mailboxPattern.indexOf(47);
        String rootPath = index == -1 ? mailboxPattern : mailboxPattern.substring(0, index);
        boolean found = false;
        for (String mountPointName : this.imapConfigMountPoints.keySet()) {
            if (!mountPointName.matches(rootPath.replaceAll("[%\\*]", ".*"))) continue;
            NodeRef mountPoint = this.getMountPoint(mountPointName);
            if (mountPoint != null) {
                int mountPointId = this.mountPointIds.get(mountPointName);
                FileInfo mountPointFileInfo = this.fileFolderService.getFileInfo(mountPoint);
                AlfrescoImapConst.ImapViewMode viewMode = this.imapConfigMountPoints.get(mountPointName).getMode();
                if (index < 0) {
                    String userName = user.getLogin();
                    if (!listSubscribed || this.isSubscribed(mountPointFileInfo, userName)) {
                        result.add(new AlfrescoImapFolder(mountPointFileInfo, userName, mountPointName, mountPointName, viewMode, this.isExtractionEnabled(mountPointFileInfo.getNodeRef()), this.serviceRegistry, mountPointId));
                    } else if (rootPath.endsWith("%") && !this.expandFolder(mountPoint, user, mountPointName, "%", true, viewMode, mountPointId).isEmpty()) {
                        result.add(new AlfrescoImapFolder(mountPointFileInfo, userName, mountPointName, mountPointName, viewMode, this.serviceRegistry, false, this.isExtractionEnabled(mountPointFileInfo.getNodeRef()), mountPointId));
                    }
                    if (rootPath.endsWith("*")) {
                        result.addAll(this.expandFolder(mountPoint, user, mountPointName, "*", listSubscribed, viewMode, mountPointId));
                    }
                } else {
                    result.addAll(this.expandFolder(mountPoint, user, mountPointName, mailboxPattern.substring(index + 1), listSubscribed, viewMode, mountPointId));
                }
            }
            if (!mountPointName.equals(rootPath)) continue;
            found = true;
            break;
        }
        if (!found) {
            NodeRef root = this.getUserImapHomeRef(user.getLogin());
            result.addAll(this.expandFolder(root, user, "", mailboxPattern, listSubscribed, AlfrescoImapConst.ImapViewMode.ARCHIVE, 0));
        }
        this.logger.debug((Object)("listMailboxes returning size:" + result.size()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AlfrescoImapFolder> expandFolder(NodeRef root, AlfrescoImapUser user, String rootPath, String mailboxPattern, boolean listSubscribed, AlfrescoImapConst.ImapViewMode viewMode, int mountPointId) {
        List<FileInfo> list;
        ImapSubFolderFilter filter;
        LinkedList<AlfrescoImapFolder> fullList;
        String rootPathPrefix;
        String name;
        int index;
        block13: {
            FileInfo fileInfo;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("expand folder: root:" + root + " user: " + user + " :mailboxPattern=" + mailboxPattern));
            }
            if (mailboxPattern == null) {
                return null;
            }
            index = mailboxPattern.indexOf(47);
            name = null;
            name = index < 0 ? mailboxPattern : mailboxPattern.substring(0, index);
            String string = rootPathPrefix = rootPath.length() == 0 ? "" : rootPath + '/';
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Listing mailboxes: name=" + name));
            }
            fullList = new LinkedList<AlfrescoImapFolder>();
            filter = new ImapSubFolderFilter(viewMode, name.replace('%', '*'));
            if (name.contains("*") || name.contains("%")) {
                FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.imap);
                try {
                    list = this.fileFolderService.listFolders(root);
                    Object var15_14 = null;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    FileFilterMode.clearClient();
                    throw throwable;
                }
                FileFilterMode.clearClient();
                {
                    break block13;
                }
            }
            NodeRef nodeRef = this.fileFolderService.searchSimple(root, name);
            List<Object> list2 = list = nodeRef == null || !(fileInfo = this.fileFolderService.getFileInfo(nodeRef)).isFolder() ? Collections.emptyList() : Collections.singletonList(fileInfo);
        }
        if (index < 0) {
            for (FileInfo fileInfo : list) {
                if (!filter.isEnterSubfolder(fileInfo.getNodeRef())) continue;
                String folderPath = rootPathPrefix + fileInfo.getName();
                String userName = user.getLogin();
                if (!listSubscribed || this.isSubscribed(fileInfo, userName)) {
                    fullList.add(new AlfrescoImapFolder(fileInfo, userName, fileInfo.getName(), folderPath, viewMode, this.isExtractionEnabled(fileInfo.getNodeRef()), this.serviceRegistry, mountPointId));
                } else if (name.endsWith("%") && !this.expandFolder(fileInfo.getNodeRef(), user, folderPath, "%", true, viewMode, mountPointId).isEmpty()) {
                    fullList.add(new AlfrescoImapFolder(fileInfo, userName, fileInfo.getName(), folderPath, viewMode, this.serviceRegistry, false, this.isExtractionEnabled(fileInfo.getNodeRef()), mountPointId));
                }
                if (!name.endsWith("*")) continue;
                fullList.addAll(this.expandFolder(fileInfo.getNodeRef(), user, folderPath, "*", listSubscribed, viewMode, mountPointId));
            }
        } else {
            for (FileInfo folder : list) {
                if (!filter.isEnterSubfolder(folder.getNodeRef())) continue;
                fullList.addAll(this.expandFolder(folder.getNodeRef(), user, rootPathPrefix + folder.getName(), mailboxPattern.substring(index + 1), listSubscribed, viewMode, mountPointId));
            }
        }
        return fullList;
    }

    private NodeRef getMountPoint(String rootFolder) {
        final ImapConfigMountPointsBean config = this.imapConfigMountPoints.get(rootFolder);
        try {
            return this.serviceRegistry.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Exception {
                    try {
                        return config.getFolderPath(ImapServiceImpl.this.namespaceService, ImapServiceImpl.this.nodeService, ImapServiceImpl.this.searchService, ImapServiceImpl.this.fileFolderService);
                    }
                    catch (AccessDeniedException e) {
                        if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                            ImapServiceImpl.this.logger.debug((Object)("A mount point is skipped due to Access Dennied. \n   Mount point: " + config + "\n" + "   User: " + AuthenticationUtil.getFullyAuthenticatedUser()));
                        }
                        return null;
                    }
                }
            }, true, true);
        }
        catch (AccessDeniedException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("A mount point is skipped due to Access Dennied. \n   Mount point: " + config + "\n" + "   User: " + AuthenticationUtil.getFullyAuthenticatedUser()));
            }
            return null;
        }
    }

    @Override
    public NodeRef getUserImapHomeRef(final String userName) {
        NodeRef userHome = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef userHome = ImapServiceImpl.this.fileFolderService.searchSimple(ImapServiceImpl.this.imapHomeNodeRef, userName);
                if (userHome == null) {
                    NodeRef result = ImapServiceImpl.this.fileFolderService.create(ImapServiceImpl.this.imapHomeNodeRef, userName, ContentModel.TYPE_FOLDER).getNodeRef();
                    ImapServiceImpl.this.nodeService.setProperty(result, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)userName));
                    ImapServiceImpl.this.fileFolderService.create(result, "INBOX", ContentModel.TYPE_FOLDER);
                    ImapServiceImpl.this.permissionService.setInheritParentPermissions(result, false);
                    ImapServiceImpl.this.permissionService.setPermission(result, "ROLE_OWNER", "All", true);
                    return result;
                }
                return userHome;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return userHome;
    }

    private boolean isSubscribed(FileInfo fileInfo, String userName) {
        return !this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_FOLDER_NONSUBSCRIBED);
    }

    private String getCurrentUser() {
        return AuthenticationUtil.getFullyAuthenticatedUser();
    }

    private List<NodeRef> getFavouriteSites(final String userName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getFavouriteSites] entry for user: " + userName));
        }
        LinkedList<NodeRef> favSites = (LinkedList<NodeRef>)AlfrescoTransactionSupport.getResource(FAVORITE_SITES);
        if (this.logger.isDebugEnabled()) {
            if (favSites == null) {
                this.logger.debug((Object)("[getFavouriteSites] There is no Favorite sites' list bound to transaction " + AlfrescoTransactionSupport.getTransactionId()));
            } else {
                this.logger.debug((Object)("[getFavouriteSites] Found Favorite sites' list bound to transaction " + AlfrescoTransactionSupport.getTransactionId()));
            }
        }
        if (favSites == null) {
            favSites = new LinkedList<NodeRef>();
            PreferenceService preferenceService = (PreferenceService)this.serviceRegistry.getService(ServiceRegistry.PREFERENCE_SERVICE);
            Map<String, Serializable> prefs = preferenceService.getPreferences(userName, "org.alfresco.share.sites.imapFavourites");
            List<SiteInfo> sites = this.serviceRegistry.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<SiteInfo>>(){

                @Override
                public List<SiteInfo> execute() throws Exception {
                    ArrayList<SiteInfo> res;
                    block4: {
                        res = new ArrayList();
                        try {
                            res = ImapServiceImpl.this.serviceRegistry.getSiteService().listSites(userName);
                        }
                        catch (SiteServiceException e) {
                            if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                                ImapServiceImpl.this.logger.warn((Object)"[getFavouriteSites] Root sites folder was not created.");
                            }
                        }
                        catch (InvalidNodeRefException e) {
                            if (!ImapServiceImpl.this.logger.isDebugEnabled()) break block4;
                            ImapServiceImpl.this.logger.warn((Object)"[getFavouriteSites] Root sites folder was deleted.");
                        }
                    }
                    return res;
                }
            }, false, true);
            for (SiteInfo siteInfo : sites) {
                String key = "org.alfresco.share.sites.imapFavourites." + siteInfo.getShortName();
                Boolean isImapFavourite = (Boolean)prefs.get(key);
                if (isImapFavourite == null || !isImapFavourite.booleanValue()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("[getFavouriteSites] User: " + userName + " Favourite site: " + siteInfo.getShortName()));
                }
                favSites.add(siteInfo.getNodeRef());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[getFavouriteSites] Bind new Favorite sites' list to transaction " + AlfrescoTransactionSupport.getTransactionId()));
            }
            AlfrescoTransactionSupport.bindResource(FAVORITE_SITES, favSites);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getFavouriteSites] end for user: " + userName));
        }
        return favSites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForFlaggableAspect(NodeRef nodeRef) {
        HashSet<NodeRef> alreadyChecked = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource(CHECKED_NODES);
        if (alreadyChecked == null) {
            alreadyChecked = new HashSet<NodeRef>();
        }
        if (alreadyChecked.contains(nodeRef)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[checkForFlaggableAspect] Flaggable aspect has been already checked for {" + nodeRef + "}"));
            }
            return;
        }
        try {
            this.serviceRegistry.getLockService().checkForLock(nodeRef);
        }
        catch (NodeLockedException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[checkForFlaggableAspect] Node {" + nodeRef + "} is locked"));
            }
            alreadyChecked.add(nodeRef);
            return;
        }
        if (!this.nodeService.hasAspect(nodeRef, ImapModel.ASPECT_FLAGGABLE)) {
            AccessStatus status = this.permissionService.hasPermission(nodeRef, "WriteProperties");
            if (status == AccessStatus.DENIED) {
                this.logger.debug((Object)("[checkForFlaggableAspect] No permissions to add FLAGGABLE aspect" + nodeRef));
            } else {
                try {
                    this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                    this.logger.debug((Object)("[checkForFlaggableAspect] Adding flaggable aspect to nodeRef: " + nodeRef));
                    HashMap aspectProperties = new HashMap();
                    this.nodeService.addAspect(nodeRef, ImapModel.ASPECT_FLAGGABLE, aspectProperties);
                    Object var6_6 = null;
                    this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                    throw throwable;
                }
            }
        }
        alreadyChecked.add(nodeRef);
        AlfrescoTransactionSupport.bindResource(CHECKED_NODES, alreadyChecked);
    }

    private boolean isExtractionEnabled(NodeRef nodeRef) {
        return this.extractAttachmentsEnabled && !this.ignoreExtractionFolders.contains(nodeRef);
    }

    @Override
    public String getDefaultEmailBodyTemplate(ImapService.EmailBodyFormat type) {
        if (this.defaultBodyTemplates == null) {
            this.defaultBodyTemplates = new HashMap<ImapService.EmailBodyFormat, String>(4);
            for (ImapService.EmailBodyFormat onetype : ImapService.EmailBodyFormat.values()) {
                String result = onetype.getClasspathTemplatePath();
                try {
                    StoreRef storeRef;
                    NodeRef rootNode;
                    List templates;
                    StringBuilder templateName = new StringBuilder("emailbody").append("_").append(onetype.getTypeSubtype()).append("_").append(onetype.getWebApp()).append(".ftl");
                    String repositoryTemplatePath = this.getRepositoryTemplatePath();
                    int indexOfStoreDelim = repositoryTemplatePath.indexOf("://");
                    if (indexOfStoreDelim == -1) {
                        throw new IllegalArgumentException("Bad path format, :// not found");
                    }
                    int indexOfPathDelim = repositoryTemplatePath.indexOf("/", indexOfStoreDelim += "://".length());
                    if (indexOfPathDelim == -1) {
                        throw new IllegalArgumentException("Bad path format, '/' not found");
                    }
                    String storePath = repositoryTemplatePath.substring(0, indexOfPathDelim);
                    String rootPathInStore = repositoryTemplatePath.substring(indexOfPathDelim);
                    String query = rootPathInStore + "/" + "cm" + ":" + templateName;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("[getDefaultEmailBodyTemplate] Query: " + query));
                    }
                    if ((templates = this.searchService.selectNodes(rootNode = this.nodeService.getRootNode(storeRef = new StoreRef(storePath)), query, null, (NamespacePrefixResolver)this.namespaceService, true)) == null || templates.size() == 0) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("template not found:" + templateName));
                        }
                        throw new AlfrescoRuntimeException(String.format("[getDefaultEmailBodyTemplate] IMAP message template '%1$s' does not exist in the path '%2$s'.", templateName, repositoryTemplatePath));
                    }
                    NodeRef defaultLocaleTemplate = (NodeRef)templates.get(0);
                    NodeRef localisedSibling = this.serviceRegistry.getFileFolderService().getLocalizedSibling(defaultLocaleTemplate);
                    result = localisedSibling.toString();
                }
                catch (Exception e) {
                    this.logger.error((Object)"ImapServiceImpl [getDefaultEmailBodyTemplate]", (Throwable)e);
                }
                this.defaultBodyTemplates.put(onetype, result);
            }
        }
        return this.defaultBodyTemplates.get((Object)type);
    }

    public String getAlfrescoServerUID() {
        return "Not-Implemented";
    }

    private UidValidityTransactionListener getUidValidityTransactionListener(NodeRef folderRef) {
        String key = UIDVALIDITY_TRANSACTION_LISTENER + folderRef.toString();
        UidValidityTransactionListener txnListener = (UidValidityTransactionListener)AlfrescoTransactionSupport.getResource(key);
        if (txnListener == null) {
            txnListener = new UidValidityTransactionListener(folderRef, this.nodeService);
            AlfrescoTransactionSupport.bindListener(txnListener);
            AlfrescoTransactionSupport.bindResource(key, txnListener);
        }
        return txnListener;
    }

    @Override
    public void onCreateChildAssociation(final ChildAssociationRef childAssocRef, boolean isNewNode) {
        this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                NodeRef childNodeRef = childAssocRef.getChildRef();
                if (ImapServiceImpl.this.serviceRegistry.getDictionaryService().isSubClass(ImapServiceImpl.this.nodeService.getType(childNodeRef), ContentModel.TYPE_CONTENT)) {
                    long newId = (Long)ImapServiceImpl.this.nodeService.getProperty(childNodeRef, ContentModel.PROP_NODE_DBID);
                    ImapServiceImpl.this.getUidValidityTransactionListener(childAssocRef.getParentRef()).recordNewUid(newId);
                    ImapServiceImpl.this.setFlag(childNodeRef, Flags.Flag.RECENT, true);
                }
                if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                    ImapServiceImpl.this.logger.debug((Object)("[onCreateChildAssociation] Association " + childAssocRef + " created. CHANGETOKEN will be changed."));
                }
                return null;
            }
        });
    }

    @Override
    public void onDeleteChildAssociation(final ChildAssociationRef childAssocRef) {
        this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                NodeRef childNodeRef = childAssocRef.getChildRef();
                if (ImapServiceImpl.this.serviceRegistry.getDictionaryService().isSubClass(ImapServiceImpl.this.nodeService.getType(childNodeRef), ContentModel.TYPE_CONTENT)) {
                    ImapServiceImpl.this.getUidValidityTransactionListener(childAssocRef.getParentRef());
                    ImapServiceImpl.this.messageCache.remove((Serializable)childNodeRef);
                }
                if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                    ImapServiceImpl.this.logger.debug((Object)("[onDeleteChildAssociation] Association " + childAssocRef + " created. CHANGETOKEN will be changed."));
                }
                return null;
            }
        });
    }

    @Override
    public void onUpdateProperties(final NodeRef nodeRef, final Map<QName, Serializable> before, final Map<QName, Serializable> after) {
        this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                boolean hasChanged = false;
                if (!hasChanged) {
                    boolean bl = hasChanged = !EqualsHelper.nullSafeEquals(before.get(ContentModel.PROP_NAME), after.get(ContentModel.PROP_NAME));
                }
                if (!hasChanged) {
                    boolean bl = hasChanged = !EqualsHelper.nullSafeEquals(before.get(ContentModel.PROP_AUTHOR), after.get(ContentModel.PROP_AUTHOR));
                }
                if (!hasChanged) {
                    boolean bl = hasChanged = !EqualsHelper.nullSafeEquals(before.get(ContentModel.PROP_TITLE), after.get(ContentModel.PROP_TITLE));
                }
                if (!hasChanged) {
                    boolean bl = hasChanged = !EqualsHelper.nullSafeEquals(before.get(ContentModel.PROP_DESCRIPTION), after.get(ContentModel.PROP_DESCRIPTION));
                }
                if (!hasChanged) {
                    Serializable s1 = (Serializable)before.get(ContentModel.PROP_CONTENT);
                    Serializable s2 = (Serializable)after.get(ContentModel.PROP_CONTENT);
                    if (s1 != null && s2 != null) {
                        ContentData c1 = (ContentData)s1;
                        ContentData c2 = (ContentData)s2;
                        hasChanged = !EqualsHelper.nullSafeEquals((Object)c1.getContentUrl(), (Object)c2.getContentUrl());
                    }
                }
                for (ChildAssociationRef parentAssoc : ImapServiceImpl.this.nodeService.getParentAssocs(nodeRef)) {
                    NodeRef folderRef = parentAssoc.getParentRef();
                    if (!ImapServiceImpl.this.nodeService.hasAspect(folderRef, ImapModel.ASPECT_IMAP_FOLDER)) continue;
                    ImapServiceImpl.this.messageCache.remove((Serializable)nodeRef);
                    UidValidityTransactionListener listener = ImapServiceImpl.this.getUidValidityTransactionListener(folderRef);
                    if (!hasChanged) continue;
                    ImapServiceImpl.this.logger.debug((Object)"message has changed - force new uidvalidity for the parent folder");
                    listener.forceNewUidvalidity();
                }
                return null;
            }
        });
    }

    @Override
    public void beforeDeleteNode(final NodeRef nodeRef) {
        this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                for (ChildAssociationRef parentAssoc : ImapServiceImpl.this.nodeService.getParentAssocs(nodeRef)) {
                    NodeRef folderRef = parentAssoc.getParentRef();
                    if (!ImapServiceImpl.this.nodeService.hasAspect(folderRef, ImapModel.ASPECT_IMAP_FOLDER)) continue;
                    ImapServiceImpl.this.messageCache.remove((Serializable)nodeRef);
                    ImapServiceImpl.this.getUidValidityTransactionListener(folderRef);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R doAsSystem(AuthenticationUtil.RunAsWork<R> work) {
        Object object;
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            object = AuthenticationUtil.runAs(work, (String)AuthenticationUtil.getSystemUserName());
            Object var4_3 = null;
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
            throw throwable;
        }
        return (R)object;
    }

    @Override
    public boolean isNodeInSitesLibrary(NodeRef nodeRef) {
        boolean isInDocLibrary = false;
        NodeRef parent = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        while (parent != null && !this.nodeService.getType(parent).equals((Object)SiteModel.TYPE_SITE)) {
            String parentName = (String)((Object)this.nodeService.getProperty(parent, ContentModel.PROP_NAME));
            if (parentName.equalsIgnoreCase("documentlibrary")) {
                isInDocLibrary = true;
            }
            if (this.nodeService.getPrimaryParent(nodeRef = parent) == null) continue;
            parent = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        }
        if (parent == null) {
            return false;
        }
        return this.nodeService.getType(parent).equals((Object)SiteModel.TYPE_SITE) && isInDocLibrary;
    }

    @Override
    public NodeRef extractAttachments(NodeRef parentFolder, NodeRef messageFile, MimeMessage originalMessage) throws IOException, MessagingException {
        String messageName = (String)((Object)this.nodeService.getProperty(messageFile, ContentModel.PROP_NAME));
        String attachmentsFolderName = messageName + "-attachments";
        FileInfo attachmentsFolderFileInfo = null;
        Object content = originalMessage.getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                if (!"attachment".equalsIgnoreCase(part.getDisposition())) continue;
                if (attachmentsFolderFileInfo == null) {
                    attachmentsFolderFileInfo = this.fileFolderService.create(parentFolder, attachmentsFolderName, ContentModel.TYPE_FOLDER);
                    this.nodeService.createAssociation(messageFile, attachmentsFolderFileInfo.getNodeRef(), ImapModel.ASSOC_IMAP_ATTACHMENTS_FOLDER);
                }
                this.createAttachment(messageFile, attachmentsFolderFileInfo.getNodeRef(), (Part)part);
            }
        }
        if (attachmentsFolderFileInfo != null) {
            return attachmentsFolderFileInfo.getNodeRef();
        }
        return null;
    }

    private void createAttachment(NodeRef messageFile, NodeRef destinationFolder, Part part) throws MessagingException, IOException {
        String fileName;
        block8: {
            fileName = part.getFileName();
            try {
                fileName = MimeUtility.decodeText((String)fileName);
            }
            catch (UnsupportedEncodingException e) {
                if (!this.logger.isWarnEnabled()) break block8;
                this.logger.warn((Object)("Cannot decode file name '" + fileName + "'"), (Throwable)e);
            }
        }
        ContentType contentType = new ContentType(part.getContentType());
        if (contentType.getBaseType().equalsIgnoreCase("application/ms-tnef")) {
            HMEFMessage hmef = new HMEFMessage(part.getInputStream());
            List attachments = hmef.getAttachments();
            for (Attachment attachment : attachments) {
                String subName = attachment.getLongFilename();
                NodeRef attachmentNode = this.fileFolderService.searchSimple(destinationFolder, subName);
                if (attachmentNode != null) continue;
                FileInfo createdFile = this.fileFolderService.create(destinationFolder, subName, ContentModel.TYPE_CONTENT);
                attachmentNode = createdFile.getNodeRef();
                this.serviceRegistry.getNodeService().createAssociation(messageFile, attachmentNode, ImapModel.ASSOC_IMAP_ATTACHMENT);
                byte[] bytes = attachment.getContents();
                ContentWriter writer = this.fileFolderService.getWriter(attachmentNode);
                String extension = attachment.getExtension();
                String mimetype = this.mimetypeService.getMimetype(extension);
                if (mimetype != null) {
                    writer.setMimetype(mimetype);
                }
                OutputStream os = writer.getContentOutputStream();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                FileCopyUtils.copy((InputStream)is, (OutputStream)os);
            }
        } else {
            NodeRef attachmentNode = this.fileFolderService.searchSimple(destinationFolder, fileName);
            if (attachmentNode == null) {
                FileInfo createdFile = this.fileFolderService.create(destinationFolder, fileName, ContentModel.TYPE_CONTENT);
                attachmentNode = createdFile.getNodeRef();
                this.serviceRegistry.getNodeService().createAssociation(messageFile, attachmentNode, ImapModel.ASSOC_IMAP_ATTACHMENT);
                ContentWriter writer = this.fileFolderService.getWriter(attachmentNode);
                writer.setMimetype(contentType.getBaseType());
                String charset = contentType.getParameter("charset");
                if (charset != null) {
                    writer.setEncoding(charset);
                }
                OutputStream os = writer.getContentOutputStream();
                FileCopyUtils.copy((InputStream)part.getInputStream(), (OutputStream)os);
            }
        }
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    static {
        qNameToFlag.put(ImapModel.PROP_FLAG_ANSWERED, Flags.Flag.ANSWERED);
        qNameToFlag.put(ImapModel.PROP_FLAG_DELETED, Flags.Flag.DELETED);
        qNameToFlag.put(ImapModel.PROP_FLAG_DRAFT, Flags.Flag.DRAFT);
        qNameToFlag.put(ImapModel.PROP_FLAG_SEEN, Flags.Flag.SEEN);
        qNameToFlag.put(ImapModel.PROP_FLAG_RECENT, Flags.Flag.RECENT);
        qNameToFlag.put(ImapModel.PROP_FLAG_FLAGGED, Flags.Flag.FLAGGED);
        flagToQname = new HashMap<Flags.Flag, QName>();
        flagToQname.put(Flags.Flag.ANSWERED, ImapModel.PROP_FLAG_ANSWERED);
        flagToQname.put(Flags.Flag.DELETED, ImapModel.PROP_FLAG_DELETED);
        flagToQname.put(Flags.Flag.DRAFT, ImapModel.PROP_FLAG_DRAFT);
        flagToQname.put(Flags.Flag.SEEN, ImapModel.PROP_FLAG_SEEN);
        flagToQname.put(Flags.Flag.RECENT, ImapModel.PROP_FLAG_RECENT);
        flagToQname.put(Flags.Flag.FLAGGED, ImapModel.PROP_FLAG_FLAGGED);
    }

    static class CacheItem {
        private Date modified;
        private SimpleStoredMessage message;

        public CacheItem(Date modified, SimpleStoredMessage message) {
            this.setMessage(message);
            this.setModified(modified);
        }

        public void setModified(Date modified) {
            this.modified = modified;
        }

        public Date getModified() {
            return this.modified;
        }

        public void setMessage(SimpleStoredMessage message) {
            this.message = message;
        }

        public SimpleStoredMessage getMessage() {
            return this.message;
        }
    }

    private class UidValidityTransactionListener
    extends TransactionListenerAdapter {
        private String changeToken = GUID.generate();
        private NodeService nodeService;
        private NodeRef folderNodeRef;
        private Long minUid;
        private Long maxUid;
        private boolean forceNewUidValidity = false;

        public UidValidityTransactionListener(NodeRef folderNodeRef, NodeService nodeService) {
            this.folderNodeRef = folderNodeRef;
            this.nodeService = nodeService;
        }

        public void forceNewUidvalidity() {
            this.forceNewUidValidity = true;
        }

        public void recordNewUid(long newUid) {
            if (this.minUid == null) {
                this.minUid = this.maxUid = Long.valueOf(newUid);
            } else if (newUid < this.minUid) {
                this.minUid = newUid;
            } else if (newUid > this.maxUid) {
                this.maxUid = newUid;
            }
        }

        public void beforeCommit(boolean readOnly) {
            if (readOnly) {
                return;
            }
            ImapServiceImpl.this.doAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    if (UidValidityTransactionListener.this.forceNewUidValidity || UidValidityTransactionListener.this.minUid != null) {
                        long modifDate = System.currentTimeMillis();
                        Long oldMax = (Long)UidValidityTransactionListener.this.nodeService.getProperty(UidValidityTransactionListener.this.folderNodeRef, ImapModel.PROP_MAXUID);
                        if (UidValidityTransactionListener.this.forceNewUidValidity || oldMax == null || UidValidityTransactionListener.this.minUid < oldMax) {
                            UidValidityTransactionListener.this.nodeService.setProperty(UidValidityTransactionListener.this.folderNodeRef, ImapModel.PROP_UIDVALIDITY, (Serializable)Long.valueOf(modifDate));
                            if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                                ImapServiceImpl.this.logger.debug((Object)("UIDVALIDITY was modified for folder, nodeRef:" + UidValidityTransactionListener.this.folderNodeRef));
                            }
                        }
                        if (UidValidityTransactionListener.this.maxUid != null) {
                            UidValidityTransactionListener.this.nodeService.setProperty(UidValidityTransactionListener.this.folderNodeRef, ImapModel.PROP_MAXUID, (Serializable)UidValidityTransactionListener.this.maxUid);
                            if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                                ImapServiceImpl.this.logger.debug((Object)("MAXUID was modified for folder, nodeRef:" + UidValidityTransactionListener.this.folderNodeRef));
                            }
                        }
                    }
                    UidValidityTransactionListener.this.nodeService.setProperty(UidValidityTransactionListener.this.folderNodeRef, ImapModel.PROP_CHANGE_TOKEN, (Serializable)((Object)UidValidityTransactionListener.this.changeToken));
                    return null;
                }
            });
        }
    }

    private class ImapSubFolderFilter
    implements SubFolderFilter {
        private Collection<QName> typesToExclude;
        private List<NodeRef> favs;
        private String mailboxPattern;
        private AlfrescoImapConst.ImapViewMode imapViewMode;

        ImapSubFolderFilter(AlfrescoImapConst.ImapViewMode imapViewMode) {
            this.imapViewMode = imapViewMode;
            this.typesToExclude = ImapServiceImpl.this.serviceRegistry.getDictionaryService().getSubTypes(SiteModel.TYPE_SITE, true);
            this.favs = ImapServiceImpl.this.getFavouriteSites(ImapServiceImpl.this.getCurrentUser());
        }

        ImapSubFolderFilter(AlfrescoImapConst.ImapViewMode imapViewMode, String mailboxPattern) {
            this(imapViewMode);
            this.mailboxPattern = mailboxPattern.replaceAll("\\*", "(.)*");
        }

        public boolean isEnterSubfolder(ChildAssociationRef subfolderRef) {
            return this.isEnterSubfolder(subfolderRef.getChildRef());
        }

        public boolean isEnterSubfolder(NodeRef folder) {
            QName typeOfFolder;
            String name = (String)((Object)ImapServiceImpl.this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
            if (this.mailboxPattern != null) {
                ImapServiceImpl.this.logger.debug((Object)("Child name: " + name));
                if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                    ImapServiceImpl.this.logger.debug((Object)("Folder name: " + name + ". Pattern: " + this.mailboxPattern + ". Matches: " + name.matches(this.mailboxPattern)));
                }
                if (!name.matches(this.mailboxPattern)) {
                    return false;
                }
            }
            if (this.typesToExclude.contains(typeOfFolder = ImapServiceImpl.this.nodeService.getType(folder))) {
                if (this.imapViewMode == AlfrescoImapConst.ImapViewMode.VIRTUAL || this.imapViewMode == AlfrescoImapConst.ImapViewMode.MIXED) {
                    if (this.favs.contains(folder)) {
                        ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] (VIRTUAL) including fav site folder :" + name));
                        return true;
                    }
                    ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] (VIRTUAL) excluding non fav site folder :" + name));
                    return false;
                }
                ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] (ARCHIVE) excluding site folder :" + name));
                return false;
            }
            return true;
        }
    }

    public static class ImapServiceBootstrap
    extends AbstractLifecycleBean {
        private ImapServiceImpl service;

        public void setService(ImapServiceImpl service) {
            this.service = service;
        }

        protected void onBootstrap(ApplicationEvent event) {
            this.service.startupInTxn(false);
        }

        protected void onShutdown(ApplicationEvent event) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    if (ImapServiceBootstrap.this.service.getImapServerEnabled()) {
                        ImapServiceBootstrap.this.service.shutdown();
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }
}

