/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipException;
import org.alfresco.repo.importer.AVMImporter;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.AVMWrongTypeException;
import org.apache.poi.util.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class AVMZipImporter
implements AVMImporter {
    private AVMService avmService;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void importNodes(ZipFile zip, String storePath) throws IOException, ZipException {
        AVMStoreDescriptor avmStore;
        String store = storePath;
        String path = null;
        int splitAt = storePath.indexOf(58);
        if (splitAt != -1) {
            store = storePath.substring(0, splitAt);
            path = storePath.substring(splitAt + 1);
        }
        if ((avmStore = this.avmService.getStore(store)) == null) {
            throw new IllegalArgumentException("No AVM store found with name " + store);
        }
        this.importNodes(zip, avmStore, path);
    }

    public void importNodes(ZipFile zip, AVMStoreDescriptor avmStore, String storePath) throws IOException, ZipException {
        if (avmStore == null) {
            throw new IllegalArgumentException("An AVM Store must be supplied");
        }
        if (storePath == null) {
            storePath = "/";
        }
        if (!storePath.startsWith("/")) {
            storePath = "/" + storePath;
        }
        if (!storePath.endsWith("/")) {
            storePath = storePath + "/";
        }
        Enumeration entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            String relativeName = entry.getName();
            if (relativeName.startsWith("/")) {
                relativeName = relativeName.substring(1);
            }
            String avmName = storePath + relativeName;
            if (entry.isDirectory()) {
                this.ensureDirectory(avmStore, avmName);
                continue;
            }
            String dir = avmName.substring(0, avmName.lastIndexOf(47) + 1);
            this.ensureDirectory(avmStore, dir);
            String avmPath = avmStore.getName() + ":" + avmName;
            this.importNode(zip.getInputStream(entry), avmPath);
        }
    }

    protected void ensureDirectory(AVMStoreDescriptor store, String name) {
        if (!name.endsWith("/")) {
            throw new IllegalArgumentException(name + " isn't a directory");
        }
        if (!(name = name.substring(0, name.length() - 1)).startsWith("/")) {
            name = "/" + name;
        }
        if (name.equals("/")) {
            throw new IllegalArgumentException("Can't create a store");
        }
        int splitAt = name.lastIndexOf(47);
        String avmPath = store.getName() + ":" + name.substring(0, splitAt);
        String avmName = name.substring(splitAt + 1);
        try {
            this.avmService.createDirectory(avmPath, avmName);
        }
        catch (AVMNotFoundException nfe) {
            String parent = name.substring(0, splitAt + 1);
            this.ensureDirectory(store, parent);
            this.avmService.createDirectory(avmPath, avmName);
        }
        catch (AVMExistsException exists) {
        }
        catch (AVMWrongTypeException wte) {
            throw wte;
        }
    }

    public void importNode(InputStream input, String path) throws IOException {
        try {
            OutputStream out = this.avmService.getFileOutputStream(path);
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        catch (AVMNotFoundException e) {
            int splitAt = path.lastIndexOf(47);
            String avmPath = path.substring(0, splitAt);
            String avmName = path.substring(splitAt + 1);
            this.avmService.createFile(avmPath, avmName, input);
        }
    }

    public void importNode(InputStream input, AVMNodeDescriptor node) throws IOException {
        OutputStream out = this.avmService.getFileOutputStream(node.getPath());
        IOUtils.copy((InputStream)input, (OutputStream)out);
    }
}

