/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.site;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.invitation.InvitationException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ModelUtil;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.extensions.surf.util.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InviteSender {
    public static final String WF_INSTANCE_ID = "wf_instanceId";
    public static final String WF_PACKAGE = "wf_package";
    private static final List<String> expectedProperties = Arrays.asList("inwf_inviteeUserName", "inwf_resourceName", "inwf_inviterUserName", "inwf_inviteeUserName", "inwf_inviteeRole", "inwf_inviteeGenPassword", "inwf_resourceName", "inwf_inviteTicket", "inwf_serverPath", "inwf_acceptUrl", "inwf_rejectUrl", "wf_instanceId", "wf_package");
    private final ActionService actionService;
    private final NodeService nodeService;
    private final PersonService personService;
    private final SearchService searchService;
    private final SiteService siteService;
    private final Repository repository;
    private final MessageService messageService;
    private final FileFolderService fileFolderService;
    private final RepoAdminService repoAdminService;
    private final NamespaceService namespaceService;

    public InviteSender(ServiceRegistry services, Repository repository, MessageService messageService) {
        this.actionService = services.getActionService();
        this.nodeService = services.getNodeService();
        this.personService = services.getPersonService();
        this.searchService = services.getSearchService();
        this.siteService = services.getSiteService();
        this.fileFolderService = services.getFileFolderService();
        this.repoAdminService = services.getRepoAdminService();
        this.namespaceService = services.getNamespaceService();
        this.repository = repository;
        this.messageService = messageService;
    }

    public void sendMail(Map<String, String> properties) {
        this.checkProperties(properties);
        ParameterCheck.mandatory((String)"Properties", properties);
        NodeRef inviter = this.personService.getPerson(properties.get("inwf_inviterUserName"));
        String inviteeName = properties.get("inwf_inviteeUserName");
        NodeRef invitee = this.personService.getPerson(inviteeName);
        Action mail = this.actionService.createAction("mail");
        mail.setParameterValue("from", (Serializable)((Object)this.getEmail(inviter)));
        mail.setParameterValue("to", (Serializable)((Object)this.getEmail(invitee)));
        mail.setParameterValue("subject", (Serializable)((Object)this.buildSubject(properties)));
        mail.setParameterValue("template", (Serializable)this.getEmailTemplateNodeRef());
        mail.setParameterValue("template_model", (Serializable)((Object)this.buildMailTextModel(properties, inviter, invitee)));
        mail.setParameterValue("ignore_send_failure", Boolean.valueOf(true));
        this.actionService.executeAction(mail, this.getWorkflowPackage(properties));
    }

    private void checkProperties(Map<String, String> properties) {
        Set<String> keys = properties.keySet();
        if (!keys.containsAll(expectedProperties)) {
            LinkedList<String> missingProperties = new LinkedList<String>(expectedProperties);
            missingProperties.removeAll(keys);
            throw new InvitationException("The following mandatory properties are missing:\n" + missingProperties, new Object[0]);
        }
    }

    private String buildSubject(Map<String, String> properties) {
        return this.messageService.getMessage("invitation.invitesender.email.subject", ModelUtil.getProductName(this.repoAdminService), this.getSiteName(properties));
    }

    private Map<String, Serializable> buildMailTextModel(Map<String, String> properties, NodeRef inviter, NodeRef invitee) {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("companyhome", (Serializable)this.repository.getCompanyHome());
        model.put("userhome", (Serializable)this.repository.getUserHome(this.repository.getPerson()));
        model.put("productName", (Serializable)((Object)ModelUtil.getProductName(this.repoAdminService)));
        Map<String, String> args = this.buildArgs(properties, inviter, invitee);
        model.put("args", (Serializable)((Object)args));
        return model;
    }

    private Map<String, String> buildArgs(Map<String, String> properties, NodeRef inviter, NodeRef invitee) {
        String params = this.buildUrlParamString(properties);
        String acceptLink = this.makeLink(properties.get("inwf_serverPath"), properties.get("inwf_acceptUrl"), params);
        String rejectLink = this.makeLink(properties.get("inwf_serverPath"), properties.get("inwf_rejectUrl"), params);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("inviteePersonRef", invitee.toString());
        args.put("inviterPersonRef", inviter.toString());
        args.put("siteName", this.getSiteName(properties));
        args.put("inviteeSiteRole", this.getRoleName(properties));
        args.put("inviteeUserName", properties.get("inwf_inviteeUserName"));
        args.put("inviteeGenPassword", properties.get("inwf_inviteeGenPassword"));
        args.put("acceptLink", acceptLink);
        args.put("rejectLink", rejectLink);
        return args;
    }

    protected String makeLink(String location, String endpoint, String queryParams) {
        location = location.endsWith("/") ? location : location + "/";
        endpoint = endpoint.startsWith("/") ? endpoint.substring(1) : endpoint;
        queryParams = queryParams.startsWith("?") ? queryParams : "?" + queryParams;
        return location + endpoint + queryParams;
    }

    private String getRoleName(Map<String, String> properties) {
        String roleName = properties.get("inwf_inviteeRole");
        String role = this.messageService.getMessage("invitation.invitesender.email.role." + roleName);
        if (role == null) {
            role = roleName;
        }
        return role;
    }

    private String getEmail(NodeRef person) {
        return (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
    }

    private NodeRef getWorkflowPackage(Map<String, String> properties) {
        String packageRef = properties.get(WF_PACKAGE);
        return new NodeRef(packageRef);
    }

    private NodeRef getEmailTemplateNodeRef() {
        List nodeRefs = this.searchService.selectNodes(this.repository.getRootHome(), "app:company_home/app:dictionary/app:email_templates/cm:invite/cm:invite-email.html.ftl", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 1) {
            NodeRef base = (NodeRef)nodeRefs.get(0);
            NodeRef local = this.fileFolderService.getLocalizedSibling(base);
            return local;
        }
        throw new InvitationException("Cannot find the email template!", new Object[0]);
    }

    private String buildUrlParamString(Map<String, String> properties) {
        StringBuilder params = new StringBuilder("?inviteId=");
        params.append(properties.get(WF_INSTANCE_ID));
        params.append("&inviteeUserName=");
        params.append(URLEncoder.encode((String)properties.get("inwf_inviteeUserName")));
        params.append("&siteShortName=");
        params.append(properties.get("inwf_resourceName"));
        params.append("&inviteTicket=");
        params.append(properties.get("inwf_inviteTicket"));
        return params.toString();
    }

    private String getSiteName(Map<String, String> properties) {
        String siteFullName = properties.get("inwf_resourceName");
        SiteInfo site = this.siteService.getSite(siteFullName);
        if (site == null) {
            throw new InvitationException("The site " + siteFullName + " could not be found.", new Object[0]);
        }
        String siteName = site.getShortName();
        String siteTitle = site.getTitle();
        if (siteTitle != null && siteTitle.length() > 0) {
            siteName = siteTitle;
        }
        return siteName;
    }
}

