/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jgroups;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.TimeoutException;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.protocols.LOOPBACK;
import org.jgroups.stack.ProtocolStack;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoJGroupsChannelFactory
extends AbstractLifecycleBean {
    public static final String APP_REGION_DEFAULT = "DEFAULT";
    public static final String APP_REGION_EHCACHE_HEARTBEAT = "EHCACHE_HEARTBEAT";
    public static final String DEFAULT_CONFIG_UDP = "classpath:alfresco/jgroups/alfresco-jgroups-UDP.xml";
    public static final String DEFAULT_CONFIG_TCP = "classpath:alfresco/jgroups/alfresco-jgroups-TCP.xml";
    private static Log logger = LogFactory.getLog(AlfrescoJGroupsChannelFactory.class);
    private static ReentrantReadWriteLock.ReadLock readLock;
    private static ReentrantReadWriteLock.WriteLock writeLock;
    private static String clusterNamePrefix;
    private static Map<String, String> configUrlsByAppRegion;
    private static final Map<String, ChannelProxy> channelsByAppRegion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isClusterActive() {
        readLock.lock();
        try {
            boolean bl = clusterNamePrefix != null;
            Object var2_1 = null;
            readLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    private static void closeChannels() {
        for (Map.Entry<String, ChannelProxy> entry : channelsByAppRegion.entrySet()) {
            ChannelProxy channelProxy = entry.getValue();
            try {
                channelProxy.close();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("\nClosed channel: " + (Object)((Object)channelProxy)));
            }
            catch (Throwable e) {
                logger.warn((Object)("Unable to close channel: \n   Channel: " + (Object)((Object)channelProxy)), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getConfigUrl(String appRegion) {
        readLock.lock();
        try {
            String configUrlStr = configUrlsByAppRegion.get(appRegion);
            if (!PropertyCheck.isValidPropertyString((String)configUrlStr)) {
                configUrlStr = configUrlsByAppRegion.get(APP_REGION_DEFAULT);
            }
            if (configUrlStr == null) {
                throw new AlfrescoRuntimeException("No protocol configuration was found for application region: \n   Cluster prefix:  " + clusterNamePrefix + "\n" + "   App region:      " + appRegion + "\n" + "   Regions defined: " + configUrlsByAppRegion);
            }
            String string = configUrlStr;
            Object var4_3 = null;
            readLock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Channel getChannel(String appRegion) {
        ChannelProxy channelProxy;
        block7: {
            block6: {
                readLock.lock();
                try {
                    channelProxy = channelsByAppRegion.get(appRegion);
                    if (channelProxy == null) break block6;
                    ChannelProxy channelProxy2 = channelProxy;
                    Object var4_5 = null;
                    readLock.unlock();
                    return channelProxy2;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    readLock.unlock();
                    throw throwable;
                }
            }
            Object var4_6 = null;
            readLock.unlock();
            writeLock.lock();
            try {
                channelProxy = channelsByAppRegion.get(appRegion);
                if (channelProxy == null) break block7;
                ChannelProxy channelProxy3 = channelProxy;
                Object var6_10 = null;
                writeLock.unlock();
                return channelProxy3;
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                writeLock.unlock();
                throw throwable;
            }
        }
        Channel channel = AlfrescoJGroupsChannelFactory.getChannelInternal(appRegion);
        channelProxy = new ChannelProxy(channel);
        channelsByAppRegion.put(appRegion, channelProxy);
        ChannelProxy channelProxy4 = channelProxy;
        Object var6_11 = null;
        writeLock.unlock();
        return channelProxy4;
    }

    private static Channel getChannelInternal(String appRegion) {
        DummyJChannel channel;
        URL configUrl = null;
        if (clusterNamePrefix == null) {
            try {
                channel = new DummyJChannel();
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to create dummy JGroups channel: \n   Cluster prefix:    " + clusterNamePrefix + "\n" + "   App region:        " + appRegion, e);
            }
        }
        String configUrlStr = AlfrescoJGroupsChannelFactory.getConfigUrl(appRegion);
        try {
            configUrl = ResourceUtils.getURL((String)configUrlStr);
            channel = new JChannel(configUrl);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to create JGroups channel: \n   Cluster prefix:    " + clusterNamePrefix + "\n" + "   App region:        " + appRegion + "\n" + "   Regions defined: " + configUrlsByAppRegion + "\n" + "   Configuration URL: " + configUrlStr, e);
        }
        try {
            String clusterName = clusterNamePrefix + ":" + appRegion;
            channel.setOpt(3, Boolean.FALSE);
            channel.connect(clusterName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\nCreated JGroups channel: \n   Cluster prefix:    " + clusterNamePrefix + "\n" + "   App region:        " + appRegion + "\n" + "   Regions defined: " + configUrlsByAppRegion + "\n" + "   Channel:           " + (Object)((Object)channel) + "\n" + "   Configuration URL: " + configUrl));
            }
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to initialise JGroups channel: \n   Cluster prefix:    " + clusterNamePrefix + "\n" + "   App region:        " + appRegion + "\n" + "   Channel:           " + (Object)((Object)channel) + "\n" + "   Configuration URL: " + configUrl, e);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildChannels() {
        writeLock.lock();
        try {
            AlfrescoJGroupsChannelFactory.rebuildChannelsInternal();
            Object var1 = null;
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            writeLock.unlock();
            throw throwable;
        }
    }

    private static void rebuildChannelsInternal() {
        for (Map.Entry<String, ChannelProxy> entry : channelsByAppRegion.entrySet()) {
            String appRegion = entry.getKey();
            ChannelProxy channelProxy = entry.getValue();
            Channel oldChannel = channelProxy.getDelegate();
            try {
                oldChannel.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\nClosed old channel during channel rebuild: \n   Old channel: " + oldChannel));
                }
            }
            catch (Throwable e) {
                logger.warn((Object)("Unable to close old channel during channel rebuild: \n   Old channel: " + oldChannel), e);
            }
            Channel newChannel = AlfrescoJGroupsChannelFactory.getChannelInternal(appRegion);
            channelProxy.swap(newChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeClusterNamePrefix(String clusterNamePrefix) {
        writeLock.lock();
        try {
            AlfrescoJGroupsChannelFactory.clusterNamePrefix = !PropertyCheck.isValidPropertyString((String)clusterNamePrefix) ? null : clusterNamePrefix;
            Object var2_1 = null;
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void changeConfigUrlsMapping(Map<String, String> configUrlsByAppRegion) {
        writeLock.lock();
        try {
            if (!configUrlsByAppRegion.containsKey(APP_REGION_DEFAULT)) {
                throw new AlfrescoRuntimeException("A configuration URL must be defined for 'DEFAULT'");
            }
            AlfrescoJGroupsChannelFactory.configUrlsByAppRegion = configUrlsByAppRegion;
            Object var2_1 = null;
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            writeLock.unlock();
            throw throwable;
        }
    }

    public void setClusterName(String clusterName) {
        AlfrescoJGroupsChannelFactory.changeClusterNamePrefix(clusterName);
    }

    public void setConfigUrlsByAppRegion(Map<String, String> configUrlsByAppRegion) {
        AlfrescoJGroupsChannelFactory.changeConfigUrlsMapping(configUrlsByAppRegion);
    }

    public void setProtocolStackMapping(Map<String, String> unused) {
        throw new AlfrescoRuntimeException("Properties 'protocolStackMapping' and 'jgroupsConfigurationUrl' have been deprecated in favour of 'configUrlsByAppRegion'.");
    }

    public void setJgroupsConfigurationUrl(String configUrl) {
        throw new AlfrescoRuntimeException("Properties 'protocolStackMapping' and 'jgroupsConfigurationUrl' have been deprecated in favour of 'configUrlsByAppRegion'.");
    }

    protected void onBootstrap(ApplicationEvent event) {
        AlfrescoJGroupsChannelFactory.rebuildChannels();
    }

    protected void onShutdown(ApplicationEvent event) {
        AlfrescoJGroupsChannelFactory.closeChannels();
    }

    static {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
        readLock = readWriteLock.readLock();
        writeLock = readWriteLock.writeLock();
        channelsByAppRegion = new HashMap<String, ChannelProxy>(5);
        clusterNamePrefix = null;
        configUrlsByAppRegion = new HashMap<String, String>(5);
        configUrlsByAppRegion.put(APP_REGION_DEFAULT, DEFAULT_CONFIG_UDP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChannelProxy
    extends Channel {
        private Channel delegate;
        private UpHandler delegateUpHandler;
        private Set<ChannelListener> delegateChannelListeners;
        private Receiver delegateReceiver;

        public ChannelProxy(Channel delegate) {
            this.delegate = delegate;
            this.delegateChannelListeners = new HashSet<ChannelListener>(7);
        }

        public Channel getDelegate() {
            return this.delegate;
        }

        public synchronized Channel swap(Channel channel) {
            this.delegate.setReceiver(null);
            for (ChannelListener delegateChannelListener : this.delegateChannelListeners) {
                this.delegate.removeChannelListener(delegateChannelListener);
            }
            this.delegate.setUpHandler(null);
            Channel oldDelegate = this.delegate;
            this.delegate = channel;
            this.delegate.setReceiver(this.delegateReceiver);
            for (ChannelListener delegateChannelListener : this.delegateChannelListeners) {
                this.delegate.addChannelListener(delegateChannelListener);
            }
            this.delegate.setUpHandler(this.delegateUpHandler);
            return oldDelegate;
        }

        protected org.jgroups.logging.Log getLog() {
            throw new UnsupportedOperationException();
        }

        public Address getAddress() {
            return this.delegate.getAddress();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public ProtocolStack getProtocolStack() {
            return this.delegate.getProtocolStack();
        }

        public synchronized void setReceiver(Receiver r) {
            this.delegateReceiver = r;
            this.delegate.setReceiver(r);
        }

        public synchronized void addChannelListener(ChannelListener listener) {
            if (listener == null) {
                return;
            }
            this.delegateChannelListeners.add(listener);
            this.delegate.addChannelListener(listener);
        }

        public synchronized void removeChannelListener(ChannelListener listener) {
            if (listener != null) {
                this.delegateChannelListeners.remove(listener);
            }
            this.delegate.removeChannelListener(listener);
        }

        public synchronized void clearChannelListeners() {
            this.delegateChannelListeners.clear();
            this.delegate.clearChannelListeners();
        }

        public synchronized void setUpHandler(UpHandler up_handler) {
            this.delegateUpHandler = up_handler;
            this.delegate.setUpHandler(up_handler);
        }

        public void blockOk() {
            this.delegate.blockOk();
        }

        public void close() {
            this.delegate.close();
        }

        public void connect(String cluster_name, Address target, String state_id, long timeout) throws ChannelException {
            this.delegate.connect(cluster_name, target, state_id, timeout);
        }

        public void connect(String cluster_name) throws ChannelException {
            this.delegate.connect(cluster_name);
        }

        public void disconnect() {
            this.delegate.disconnect();
        }

        public void down(Event evt) {
            this.delegate.down(evt);
        }

        public Object downcall(Event evt) {
            return this.delegate.downcall(evt);
        }

        public String dumpQueue() {
            return this.delegate.dumpQueue();
        }

        public Map dumpStats() {
            return this.delegate.dumpStats();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public boolean flushSupported() {
            return this.delegate.flushSupported();
        }

        public boolean getAllStates(Vector targets, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
            return this.delegate.getAllStates(targets, timeout);
        }

        public String getChannelName() {
            return this.delegate.getChannelName();
        }

        public String getClusterName() {
            return this.delegate.getClusterName();
        }

        public Map<String, Object> getInfo() {
            return this.delegate.getInfo();
        }

        public Address getLocalAddress() {
            return this.delegate.getLocalAddress();
        }

        public int getNumMessages() {
            return this.delegate.getNumMessages();
        }

        public Object getOpt(int option) {
            return this.delegate.getOpt(option);
        }

        public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
            return this.delegate.getState(target, timeout);
        }

        public boolean getState(Address target, String state_id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
            return this.delegate.getState(target, state_id, timeout);
        }

        public View getView() {
            return this.delegate.getView();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isConnected() {
            return this.delegate.isConnected();
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public void open() throws ChannelException {
            this.delegate.open();
        }

        public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
            return this.delegate.peek(timeout);
        }

        public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
            return this.delegate.receive(timeout);
        }

        public void returnState(byte[] state, String state_id) {
            this.delegate.returnState(state, state_id);
        }

        public void returnState(byte[] state) {
            this.delegate.returnState(state);
        }

        public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
            this.delegate.send(dst, src, obj);
        }

        public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
            this.delegate.send(msg);
        }

        public void setChannelListener(ChannelListener channel_listener) {
            this.delegate.setChannelListener(channel_listener);
        }

        public void setInfo(String key, Object value) {
            this.delegate.setInfo(key, value);
        }

        public void setOpt(int option, Object value) {
            this.delegate.setOpt(option, value);
        }

        public void shutdown() {
            this.delegate.shutdown();
        }

        public boolean startFlush(boolean automatic_resume) {
            return this.delegate.startFlush(automatic_resume);
        }

        public boolean startFlush(List<Address> flushParticipants, boolean automatic_resume) {
            return this.delegate.startFlush(flushParticipants, automatic_resume);
        }

        public boolean startFlush(long timeout, boolean automatic_resume) {
            return this.delegate.startFlush(timeout, automatic_resume);
        }

        public void stopFlush() {
            this.delegate.stopFlush();
        }

        public void stopFlush(List<Address> flushParticipants) {
            this.delegate.stopFlush(flushParticipants);
        }

        public synchronized String toString() {
            if (this.delegate instanceof DummyJChannel) {
                return this.delegate.toString() + "(dummy)";
            }
            return this.delegate.toString();
        }

        public String getName(Address member) {
            return this.delegate.getName(member);
        }

        public void send(Address dst, Address src, byte[] buf) throws ChannelNotConnectedException, ChannelClosedException {
            this.delegate.send(dst, src, buf);
        }

        public void send(Address dst, Address src, byte[] buf, int offset, int length) throws ChannelNotConnectedException, ChannelClosedException {
            this.delegate.send(dst, src, buf, offset, length);
        }

        public void setName(String name) {
            this.delegate.setName(name);
        }
    }

    public static class DummyProtocol
    extends LOOPBACK {
        public DummyProtocol() {
            this.enable_diagnostics = false;
        }

        public String getName() {
            return "ALF_DUMMY";
        }

        public Object down(Event evt) {
            return null;
        }

        public Object up(Event evt) {
            return null;
        }
    }

    private static class DummyJChannel
    extends JChannel {
        public DummyJChannel() throws ChannelException {
            super("org.alfresco.repo.jgroups.AlfrescoJGroupsChannelFactory$DummyProtocol");
        }
    }
}

