/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript.app;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.app.PropertyDecorator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CategoryPropertyDecorator
implements PropertyDecorator {
    private static Log logger = LogFactory.getLog(CategoryPropertyDecorator.class);
    private ServiceRegistry services;
    private NodeService nodeService = null;
    private PermissionService permissionService = null;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
        this.nodeService = serviceRegistry.getNodeService();
        this.permissionService = serviceRegistry.getPermissionService();
    }

    public Serializable decorate(NodeRef nodeRef, String propertyName, Serializable value) {
        Collection collection = (Collection)((Object)value);
        Object[] array = new Object[collection.size()];
        int index = 0;
        for (NodeRef obj : collection) {
            try {
                LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(4);
                jsonObj.put("name", this.nodeService.getProperty(obj, ContentModel.PROP_NAME));
                jsonObj.put("path", this.getPath(obj));
                jsonObj.put("nodeRef", obj.toString());
                array[index++] = jsonObj;
            }
            catch (InvalidNodeRefException e) {
                logger.warn((Object)("Category with nodeRef " + obj.toString() + " does not exist."));
            }
        }
        return array;
    }

    public String getPath(NodeRef nodeRef) {
        String displayPath = this.nodeService.getPath(nodeRef).toDisplayPath(this.nodeService, this.permissionService);
        return displayPath.replaceFirst("/categories/General", "");
    }
}

