/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import junit.framework.TestCase;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class JobLockServiceTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/JobLockServiceTest";
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private JobLockService jobLockService;
    private QName lockA;
    private QName lockAA;
    private QName lockAAA;
    private QName lockAAB;
    private QName lockAAC;
    private QName lockAB;
    private QName lockABA;
    private QName lockABB;
    private QName lockABC;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.jobLockService = (JobLockService)this.ctx.getBean("jobLockService");
        String testName = this.getName();
        this.lockA = QName.createQName((String)NAMESPACE, (String)("a-" + testName));
        this.lockAA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName));
        this.lockAAA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".a-" + testName));
        this.lockAAB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".b-" + testName));
        this.lockAAC = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".a-" + testName + ".c-" + testName));
        this.lockAB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName));
        this.lockABA = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".a-" + testName));
        this.lockABB = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".b-" + testName));
        this.lockABC = QName.createQName((String)NAMESPACE, (String)("a-" + testName + ".b-" + testName + ".c-" + testName));
    }

    public void testSetUp() {
        JobLockServiceTest.assertNotNull((Object)this.jobLockService);
    }

    public void testSimpleLock() {
        String lockToken = this.jobLockService.getLock(this.lockAAA, 20L);
        this.jobLockService.refreshLock(lockToken, this.lockAAA, 20L);
        this.jobLockService.releaseLock(lockToken, this.lockAAA);
        try {
            this.jobLockService.refreshLock(lockToken, this.lockAAA, 20L);
            JobLockServiceTest.fail((String)"Lock refresh should have failed after release");
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            // empty catch block
        }
        lockToken = this.jobLockService.getLock(this.lockAAA, 20L, 5L, 0);
        this.jobLockService.refreshLock(lockToken, this.lockAAA, 20L);
        this.jobLockService.releaseLock(lockToken, this.lockAAA);
    }

    public void testEnforceTxn() {
        try {
            this.jobLockService.getTransactionalLock(this.lockAAA, 50L);
            JobLockServiceTest.fail((String)"Service did not enforce the presence of a transaction");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testLockInReadOnly() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 500L);
                return null;
            }
        };
        this.txnHelper.doInTransaction(lockCallback, true, true);
    }

    public void testLockReleaseOnCommit() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 5000L);
                return null;
            }
        };
        this.txnHelper.doInTransaction(lockCallback, true, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCheckCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 50L);
                return null;
            }
        };
        this.txnHelper.doInTransaction(lockCheckCallback, true, true);
    }

    public void testLockReleaseOnRollback() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 5000L);
                throw new UnsupportedOperationException("ALERT!");
            }
        };
        try {
            this.txnHelper.doInTransaction(lockCallback, true, true);
            JobLockServiceTest.fail((String)"Expected transaction failure");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Object> lockCheckCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                JobLockServiceTest.this.jobLockService.getTransactionalLock(JobLockServiceTest.this.lockAAA, 50L);
                return null;
            }
        };
        this.txnHelper.doInTransaction(lockCheckCallback, true, true);
    }

    public synchronized void testDeadlockPrevention() throws Throwable {
        DeadlockingThread t1 = new DeadlockingThread(new QName[]{this.lockAAA, this.lockAAB});
        DeadlockingThread t2 = new DeadlockingThread(new QName[]{this.lockAAB, this.lockAAA});
        t1.start();
        t2.start();
        t1.incrementNextLock();
        t2.incrementNextLock();
        try {
            ((Object)((Object)this)).wait(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        t1.incrementNextLock();
        t2.incrementNextLock();
        try {
            ((Object)((Object)this)).wait(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        t1.incrementNextLock();
        t2.incrementNextLock();
        try {
            ((Object)((Object)this)).wait(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t1.otherFailure != null) {
            throw t1.otherFailure;
        }
        if (t2.otherFailure != null) {
            throw t2.otherFailure;
        }
        JobLockServiceTest.assertNull((String)("T1 should have succeeded as the ordered locker: " + (Object)((Object)t1.lockFailure)), (Object)((Object)t1.lockFailure));
        JobLockServiceTest.assertNotNull((String)"T2 should have failed as the unordered locker.", (Object)((Object)t2.lockFailure));
    }

    public synchronized void testLockCallbackReleaseInactive() throws Exception {
        QName lockQName = QName.createQName((String)NAMESPACE, (String)this.getName());
        long lockTTL = 1000L;
        String lockToken = this.jobLockService.getLock(lockQName, 1000L);
        final int[] checked = new int[1];
        final int[] released = new int[1];
        JobLockService.JobLockRefreshCallback callback = new JobLockService.JobLockRefreshCallback(){

            public boolean isActive() {
                checked[0] = checked[0] + 1;
                return false;
            }

            public void lockReleased() {
                released[0] = released[0] + 1;
            }
        };
        this.jobLockService.refreshLock(lockToken, lockQName, 1000L, callback);
        ((Object)((Object)this)).wait(1000L);
        JobLockServiceTest.assertTrue((String)"Expected lockReleased to have been called", (released[0] > 0 ? 1 : 0) != 0);
        try {
            this.jobLockService.getLock(lockQName, 1000L);
        }
        catch (LockAcquisitionException e) {
            JobLockServiceTest.fail((String)"Lock should have been released by callback infrastructure");
        }
        int checkedCount = checked[0];
        int releasedCount = released[0];
        ((Object)((Object)this)).wait(2000L);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)checkedCount, (int)checked[0]);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)releasedCount, (int)released[0]);
    }

    public synchronized void testLockCallbackReleaseSelf() throws Exception {
        final QName lockQName = QName.createQName((String)NAMESPACE, (String)this.getName());
        long lockTTL = 1000L;
        final String lockToken = this.jobLockService.getLock(lockQName, 1000L);
        final int[] checked = new int[1];
        final int[] released = new int[1];
        JobLockService.JobLockRefreshCallback callback = new JobLockService.JobLockRefreshCallback(){

            public boolean isActive() {
                checked[0] = checked[0] + 1;
                JobLockServiceTest.this.jobLockService.releaseLock(lockToken, lockQName);
                return false;
            }

            public void lockReleased() {
                released[0] = released[0] + 1;
            }
        };
        this.jobLockService.refreshLock(lockToken, lockQName, 1000L, callback);
        ((Object)((Object)this)).wait(1000L);
        JobLockServiceTest.assertFalse((String)"DID NOT expect lockReleased to have been called", (released[0] > 0 ? 1 : 0) != 0);
        try {
            this.jobLockService.getLock(lockQName, 1000L);
        }
        catch (LockAcquisitionException e) {
            JobLockServiceTest.fail((String)"Lock should have been released by callback infrastructure");
        }
        int checkedCount = checked[0];
        int releasedCount = released[0];
        ((Object)((Object)this)).wait(2000L);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)checkedCount, (int)checked[0]);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)releasedCount, (int)released[0]);
    }

    public synchronized void testLockCallbackReleaseTimed() throws Exception {
        QName lockQName = QName.createQName((String)NAMESPACE, (String)this.getName());
        long lockTTL = 1000L;
        final long lockNow = System.currentTimeMillis();
        String lockToken = this.jobLockService.getLock(lockQName, 1000L);
        final int[] checked = new int[1];
        final int[] released = new int[1];
        JobLockService.JobLockRefreshCallback callback = new JobLockService.JobLockRefreshCallback(){

            public boolean isActive() {
                checked[0] = checked[0] + 1;
                return System.currentTimeMillis() - lockNow <= 3000L;
            }

            public void lockReleased() {
                released[0] = released[0] + 1;
            }
        };
        this.jobLockService.refreshLock(lockToken, lockQName, 1000L, callback);
        ((Object)((Object)this)).wait(2000L);
        JobLockServiceTest.assertTrue((String)("Expected at least 2 active checks; only got " + checked[0]), (checked[0] >= 2 ? 1 : 0) != 0);
        JobLockServiceTest.assertFalse((String)"lockReleased should NOT have been called", (released[0] > 0 ? 1 : 0) != 0);
        try {
            this.jobLockService.getLock(lockQName, 1000L);
            JobLockServiceTest.fail((String)"Lock should still be held");
        }
        catch (LockAcquisitionException e) {
            // empty catch block
        }
        ((Object)((Object)this)).wait(2000L);
        int checkedCount = checked[0];
        int releasedCount = released[0];
        ((Object)((Object)this)).wait(2000L);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)checkedCount, (int)checked[0]);
        JobLockServiceTest.assertEquals((String)"Lock callback timer was not terminated", (int)releasedCount, (int)released[0]);
    }

    private class DeadlockingThread
    extends Thread {
        private final QName[] lockQNames;
        private volatile int nextLock;
        private LockAcquisitionException lockFailure;
        private Throwable otherFailure;

        private DeadlockingThread(QName ... lockQNames) {
            super("DeadlockingThread");
            this.nextLock = -1;
            this.lockQNames = lockQNames;
            this.setDaemon(true);
        }

        private void incrementNextLock() {
            ++this.nextLock;
        }

        public void run() {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> runCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public synchronized Object execute() throws Throwable {
                    int currentLock = -1;
                    while (currentLock < DeadlockingThread.this.lockQNames.length - 1) {
                        if (DeadlockingThread.this.nextLock > currentLock) {
                            JobLockServiceTest.this.jobLockService.getTransactionalLock(DeadlockingThread.this.lockQNames[++currentLock], 5000L);
                            continue;
                        }
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return null;
                }
            };
            try {
                JobLockServiceTest.this.txnHelper.doInTransaction(runCallback, true);
            }
            catch (LockAcquisitionException e) {
                this.lockFailure = e;
            }
            catch (Throwable e) {
                this.otherFailure = e;
            }
        }
    }
}

