/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.context.ApplicationContext;

public class SubsystemProxyFactory
extends ProxyFactoryBean {
    private static final long serialVersionUID = -4186421942840611218L;
    private ApplicationContextFactory sourceApplicationContextFactory;
    private String sourceBeanName;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ApplicationContext context;
    private Object sourceBean;
    private Map<Class<?>, Object> typedBeans = new HashMap(7);

    public SubsystemProxyFactory() {
        this.addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation mi) throws Throwable {
                Method method = mi.getMethod();
                try {
                    return method.invoke(SubsystemProxyFactory.this.locateBean(mi), mi.getArguments());
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        }));
    }

    public void setInterfaces(Class[] interfaces) {
        super.setInterfaces(interfaces);
        this.setTargetClass(this.getObjectType());
    }

    public void setSourceApplicationContextFactory(ApplicationContextFactory sourceApplicationContextFactory) {
        this.sourceApplicationContextFactory = sourceApplicationContextFactory;
    }

    public void setSourceBeanName(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object locateBean(MethodInvocation mi) {
        boolean haveWriteLock;
        block15: {
            haveWriteLock = false;
            this.lock.readLock().lock();
            try {
                ApplicationContext newContext = this.sourceApplicationContextFactory.getApplicationContext();
                if (this.context != newContext) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    haveWriteLock = true;
                    this.context = newContext = this.sourceApplicationContextFactory.getApplicationContext();
                    this.typedBeans.clear();
                    this.sourceBean = null;
                    if (this.sourceBeanName != null) {
                        this.sourceBean = newContext.getBean(this.sourceBeanName);
                    }
                }
                if (this.sourceBean != null) break block15;
                Method method = mi.getMethod();
                Class<?> type = method.getDeclaringClass();
                Object bean = this.typedBeans.get(type);
                if (bean == null) {
                    if (!haveWriteLock) {
                        this.lock.readLock().unlock();
                        this.lock.writeLock().lock();
                        haveWriteLock = true;
                    }
                    if ((bean = this.typedBeans.get(type)) == null) {
                        Map beans = this.context.getBeansOfType(type);
                        if (beans.size() != 1) {
                            throw new RuntimeException("Don't know where to route call to method " + method);
                        }
                        bean = beans.values().iterator().next();
                        this.typedBeans.put(type, bean);
                    }
                }
                Object object = bean;
                Object var9_9 = null;
                if (haveWriteLock) {
                    this.lock.writeLock().unlock();
                } else {
                    this.lock.readLock().unlock();
                }
                return object;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (haveWriteLock) {
                    this.lock.writeLock().unlock();
                } else {
                    this.lock.readLock().unlock();
                }
                throw throwable;
            }
        }
        Object object = this.sourceBean;
        Object var9_10 = null;
        if (haveWriteLock) {
            this.lock.writeLock().unlock();
        } else {
            this.lock.readLock().unlock();
        }
        return object;
    }
}

