/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems.test;

import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.management.subsystems.test.TestBean;
import org.alfresco.repo.management.subsystems.test.TestService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.BaseSpringTest;
import org.apache.cxf.endpoint.ServerRegistryImpl;
import org.springframework.context.ConfigurableApplicationContext;

public class SubsystemsTest
extends BaseSpringTest {
    protected String[] getConfigLocations() {
        return new String[]{ApplicationContextHelper.CONFIG_LOCATIONS[0], "classpath:subsystem-test-context.xml"};
    }

    public void testSubsystems() throws Exception {
        ApplicationContextFactory subsystem = (ApplicationContextFactory)this.getApplicationContext().getBean("testsubsystem");
        ConfigurableApplicationContext childContext = (ConfigurableApplicationContext)subsystem.getApplicationContext();
        SubsystemsTest.assertTrue((String)"Subsystem not started", (boolean)childContext.isActive());
        TestService testService = (TestService)childContext.getBean("testService");
        SubsystemsTest.assertEquals((String)"Subsystem Default1", (String)testService.getSimpleProp1());
        SubsystemsTest.assertEquals((boolean)true, (boolean)testService.getSimpleProp2());
        SubsystemsTest.assertEquals((String)"Instance Override3", (String)testService.getSimpleProp3());
        SubsystemsTest.assertEquals((Object)"An extra bean I changed", (Object)childContext.getBean("anotherBean"));
        TestBean[] testBeans = testService.getTestBeans();
        SubsystemsTest.assertNotNull((String)"Composite property not set", (Object)testBeans);
        SubsystemsTest.assertEquals((int)3, (int)testBeans.length);
        SubsystemsTest.assertEquals((String)"inst1", (String)testBeans[0].getId());
        SubsystemsTest.assertEquals((boolean)false, (boolean)testBeans[0].isBoolProperty());
        SubsystemsTest.assertEquals((long)123456789123456789L, (long)testBeans[0].getLongProperty());
        SubsystemsTest.assertEquals((String)"Global Default", (String)testBeans[0].getAnotherStringProperty());
        SubsystemsTest.assertEquals((String)"inst2", (String)testBeans[1].getId());
        SubsystemsTest.assertEquals((boolean)true, (boolean)testBeans[1].isBoolProperty());
        SubsystemsTest.assertEquals((long)123456789123456789L, (long)testBeans[1].getLongProperty());
        SubsystemsTest.assertEquals((String)"Global Default", (String)testBeans[1].getAnotherStringProperty());
        SubsystemsTest.assertEquals((String)"inst3", (String)testBeans[2].getId());
        SubsystemsTest.assertEquals((boolean)false, (boolean)testBeans[2].isBoolProperty());
        SubsystemsTest.assertEquals((long)123456789123456789L, (long)testBeans[2].getLongProperty());
        SubsystemsTest.assertEquals((String)"Global Instance Default", (String)testBeans[2].getAnotherStringProperty());
    }

    public void testALF6058() throws Exception {
        ServerRegistryImpl serverRegistry = (ServerRegistryImpl)this.getApplicationContext().getBean(ServerRegistryImpl.class);
        ApplicationContextFactory subsystem = (ApplicationContextFactory)this.getApplicationContext().getBean("testsubsystem");
        int beforeStop = serverRegistry.getServers().size();
        subsystem.stop();
        SubsystemsTest.assertEquals((int)beforeStop, (int)serverRegistry.getServers().size());
        subsystem.start();
    }
}

