/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfoImpl
implements FileInfo {
    private static final long serialVersionUID = 1915018521764853537L;
    private NodeRef nodeRef;
    private NodeRef linkNodeRef;
    private boolean isFolder;
    private boolean isLink;
    private boolean isHidden;
    private Map<QName, Serializable> properties;
    private QName typeQName;

    FileInfoImpl(NodeRef nodeRef, QName typeQName, boolean isFolder, boolean isHidden, Map<QName, Serializable> properties) {
        this.nodeRef = nodeRef;
        this.typeQName = typeQName;
        this.isFolder = isFolder;
        this.properties = properties;
        this.isHidden = isHidden;
        if (properties.containsKey(ContentModel.PROP_LINK_DESTINATION)) {
            this.isLink = true;
            this.linkNodeRef = (NodeRef)properties.get(ContentModel.PROP_LINK_DESTINATION);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileInfoImpl)) {
            return false;
        }
        FileInfoImpl that = (FileInfoImpl)obj;
        return this.getNodeRef().equals((Object)that.getNodeRef());
    }

    void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public int hashCode() {
        return this.getNodeRef().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("FileInfo").append("[name=").append(this.getName()).append(", isFolder=").append(this.isFolder).append(", nodeRef=").append(this.nodeRef);
        if (this.isLink()) {
            sb.append(", linkref=");
            sb.append(this.linkNodeRef);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public boolean isFolder() {
        return this.isFolder;
    }

    @Override
    public boolean isLink() {
        return this.isLink;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public NodeRef getLinkNodeRef() {
        return this.linkNodeRef;
    }

    @Override
    public String getName() {
        return (String)((Object)this.properties.get(ContentModel.PROP_NAME));
    }

    @Override
    public Date getCreatedDate() {
        return (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.properties.get(ContentModel.PROP_CREATED));
    }

    @Override
    public Date getModifiedDate() {
        return (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.properties.get(ContentModel.PROP_MODIFIED));
    }

    @Override
    public ContentData getContentData() {
        return (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.properties.get(ContentModel.PROP_CONTENT));
    }

    @Override
    public Map<QName, Serializable> getProperties() {
        return this.properties;
    }

    @Override
    public QName getType() {
        return this.typeQName;
    }
}

