/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.model.filefolder.FileInfoImpl;
import org.alfresco.repo.model.filefolder.HiddenFileFilter;
import org.alfresco.repo.model.filefolder.HiddenFileInfo;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileFilterMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenAspect {
    private static Log logger = LogFactory.getLog(HiddenAspect.class);
    private List<HiddenFileInfo> filters = new ArrayList<HiddenFileInfo>(10);
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private SearchService searchService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setPatterns(List<HiddenFileFilter> filters) {
        for (HiddenFileFilter filter : filters) {
            this.filters.add(new HiddenFileInfoImpl(filter.getFilter(), filter.getVisibility(), filter.getHiddenAttribute()));
        }
    }

    public List<HiddenFileInfo> getPatterns() {
        return this.filters;
    }

    public FileFilterMode.Client[] getClients() {
        return FileFilterMode.Client.values();
    }

    private ResultSet searchForName(StoreRef storeRef, String name) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(storeRef);
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_NAME.toString()) + ":\"" + name + "\"");
        sp.addLocale(new Locale("en"));
        return this.searchService.query(sp);
    }

    public void checkHidden(StoreRef storeRef) {
        for (HiddenFileInfo filter : this.filters) {
            String pattern = filter.getFilter();
            ResultSet rs = this.searchForName(storeRef, pattern);
            for (NodeRef nodeRef : rs.getNodeRefs()) {
                if (this.hasHiddenAspect(nodeRef)) continue;
                this.hideNode(nodeRef, filter.getVisibilityMask());
            }
        }
    }

    private Integer getClientIndex(FileFilterMode.Client client) {
        return client.ordinal();
    }

    private void addIndexControlAspect(NodeRef nodeRef) {
        HashMap<QName, Boolean> props = new HashMap<QName, Boolean>(2);
        props.put(ContentModel.PROP_IS_INDEXED, Boolean.FALSE);
        props.put(ContentModel.PROP_IS_CONTENT_INDEXED, Boolean.FALSE);
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL, props);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applied index control marker: " + nodeRef));
        }
    }

    private void removeIndexControlAspect(NodeRef nodeRef) {
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed index control marker: " + nodeRef));
        }
    }

    private void addHiddenAspect(NodeRef nodeRef, int visibilityMask) {
        HashMap<QName, Integer> props = new HashMap<QName, Integer>(1);
        props.put(ContentModel.PROP_VISIBILITY_MASK, visibilityMask);
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_HIDDEN, props);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applied hidden marker: " + nodeRef));
        }
    }

    private void removeHiddenAspect(NodeRef nodeRef) {
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_HIDDEN);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed hidden marker: " + nodeRef));
        }
    }

    private Visibility getVisibility(Integer mask, FileFilterMode.Client client) {
        if (mask == null || mask == 0) {
            return Visibility.NotVisible;
        }
        mask = mask >> this.getClientIndex(client) * 2 & 3;
        return Visibility.getVisibility(mask);
    }

    private HiddenFileInfo isHidden(String path) {
        HiddenFileInfo matched = null;
        for (HiddenFileInfo filter : this.filters) {
            if (!filter.isHidden(path)) continue;
            matched = filter;
            break;
        }
        return matched;
    }

    private boolean hasHiddenAspect(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN);
    }

    public int getClientVisibilityMask(FileFilterMode.Client client, Visibility visibility) {
        return visibility.getMask() << this.getClientIndex(client) * 2;
    }

    public HiddenFileInfo onHiddenPath(NodeRef nodeRef) {
        Path.ChildAssocElement elem;
        QName qname;
        HiddenFileInfo ret = null;
        Path path = this.nodeService.getPath(nodeRef);
        Iterator it = path.iterator();
        while (it.hasNext() && ((qname = (elem = (Path.ChildAssocElement)it.next()).getRef().getQName()) == null || (ret = this.isHidden(qname.getLocalName())) == null)) {
        }
        return ret;
    }

    public void hideNode(NodeRef nodeRef) {
        this.addHiddenAspect(nodeRef, 0);
        this.addIndexControlAspect(nodeRef);
    }

    public void hideNode(NodeRef nodeRef, int clientVisibilityMask) {
        this.addHiddenAspect(nodeRef, clientVisibilityMask);
        this.addIndexControlAspect(nodeRef);
    }

    public void checkHidden(FileInfoImpl fileInfo, boolean cascade) {
        NodeRef nodeRef = fileInfo.getNodeRef();
        HiddenFileInfo hiddenFileInfo = this.checkHidden(nodeRef, cascade);
        if (hiddenFileInfo != null) {
            fileInfo.setHidden(true);
        }
    }

    public void hideNode(FileInfoImpl fileInfo, int visibilityMask) {
        this.hideNode(fileInfo.getNodeRef(), visibilityMask);
        fileInfo.setHidden(true);
    }

    private void applyHidden(NodeRef nodeRef, int visibilityMask) {
        PagingRequest pagingRequest = new PagingRequest(0, Integer.MAX_VALUE, null);
        PagingResults<FileInfo> results = this.fileFolderService.list(nodeRef, true, true, null, null, pagingRequest);
        List files = results.getPage();
        for (FileInfo file : files) {
            if (!this.hasHiddenAspect(file.getNodeRef())) {
                this.hideNode(file.getNodeRef(), visibilityMask);
            }
            if (!file.isFolder()) continue;
            this.applyHidden(file.getNodeRef(), visibilityMask);
        }
    }

    private void removeHidden(NodeRef nodeRef) {
        PagingRequest pagingRequest = new PagingRequest(0, Integer.MAX_VALUE, null);
        PagingResults<FileInfo> results = this.fileFolderService.list(nodeRef, true, true, null, null, pagingRequest);
        List files = results.getPage();
        for (FileInfo file : files) {
            String name = (String)((Object)this.nodeService.getProperty(file.getNodeRef(), ContentModel.PROP_NAME));
            if (this.isHidden(name) != null) continue;
            this.removeHiddenAspect(file.getNodeRef());
            this.removeIndexControlAspect(file.getNodeRef());
            if (!file.isFolder()) continue;
            this.removeHidden(file.getNodeRef());
        }
    }

    public HiddenFileInfo checkHidden(NodeRef nodeRef, boolean cascade) {
        HiddenFileInfo filter = this.onHiddenPath(nodeRef);
        if (filter != null) {
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN)) {
                int visibilityMask = filter.getVisibilityMask();
                this.addHiddenAspect(nodeRef, visibilityMask);
                if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL)) {
                    this.addIndexControlAspect(nodeRef);
                }
                if (cascade) {
                    this.applyHidden(nodeRef, visibilityMask);
                }
            }
        } else {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN)) {
                this.removeHiddenAspect(nodeRef);
            }
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL)) {
                this.removeIndexControlAspect(nodeRef);
            }
            if (cascade) {
                this.removeHidden(nodeRef);
            }
        }
        return filter;
    }

    public Visibility getVisibility(FileFilterMode.Client client, NodeRef nodeRef) {
        Visibility ret = Visibility.Visible;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN)) {
            Integer visibilityMask = (Integer)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VISIBILITY_MASK);
            ret = visibilityMask != null ? (visibilityMask == 0 ? Visibility.NotVisible : (client == null ? Visibility.NotVisible : this.getVisibility((int)visibilityMask, client))) : (client == FileFilterMode.Client.cifs ? Visibility.HiddenAttribute : (client == FileFilterMode.Client.webdav || client == FileFilterMode.Client.nfs || client == FileFilterMode.Client.imap ? Visibility.Visible : Visibility.NotVisible));
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HiddenFileInfoImpl
    implements HiddenFileInfo {
        private Pattern filter;
        private Set<FileFilterMode.Client> clientVisibility = new HashSet<FileFilterMode.Client>(10);
        private Set<FileFilterMode.Client> hiddenAttribute = new HashSet<FileFilterMode.Client>(10);
        private int visibilityMask;

        public HiddenFileInfoImpl(String regexp, String visibility, String hiddenAttribute) {
            this.filter = Pattern.compile(regexp);
            this.setVisibility(visibility);
            this.setHiddenAttribute(hiddenAttribute);
            this.calculateVisibilityMask();
        }

        private void setVisibility(String visibility) {
            if (visibility != null && !visibility.equals("")) {
                for (String clientStr : visibility.split(",")) {
                    FileFilterMode.Client client = FileFilterMode.Client.getClient((String)clientStr);
                    this.clientVisibility.add(client);
                }
            }
        }

        private void setHiddenAttribute(String hiddenAttribute) {
            if (hiddenAttribute != null && !hiddenAttribute.equals("")) {
                for (String clientStr : hiddenAttribute.split(",")) {
                    FileFilterMode.Client client = FileFilterMode.Client.getClient((String)clientStr);
                    this.hiddenAttribute.add(client);
                }
            }
        }

        private void calculateVisibilityMask() {
            this.visibilityMask = 0;
            for (FileFilterMode.Client client : HiddenAspect.this.getClients()) {
                if (this.clientVisibility.contains(client)) {
                    this.visibilityMask |= HiddenAspect.this.getClientVisibilityMask(client, Visibility.Visible);
                    continue;
                }
                if (this.hiddenAttribute.contains(client)) {
                    this.visibilityMask |= HiddenAspect.this.getClientVisibilityMask(client, Visibility.HiddenAttribute);
                    continue;
                }
                this.visibilityMask |= HiddenAspect.this.getClientVisibilityMask(client, Visibility.NotVisible);
            }
        }

        @Override
        public String getFilter() {
            return this.filter.pattern();
        }

        public Set<FileFilterMode.Client> getVisibility() {
            return this.clientVisibility;
        }

        public Set<FileFilterMode.Client> getHiddenAttribute() {
            return this.hiddenAttribute;
        }

        @Override
        public int getVisibilityMask() {
            return this.visibilityMask;
        }

        @Override
        public boolean isHidden(String path) {
            return this.filter.matcher(path).matches();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Visibility {
        NotVisible,
        Visible,
        HiddenAttribute;


        public int getMask() {
            if (this == Visible) {
                return 2;
            }
            if (this == HiddenAttribute) {
                return 1;
            }
            if (this == NotVisible) {
                return 0;
            }
            throw new IllegalArgumentException();
        }

        public static Visibility getVisibility(int mask) {
            if (mask == 2) {
                return Visible;
            }
            if (mask == 1) {
                return HiddenAttribute;
            }
            if (mask == 0) {
                return NotVisible;
            }
            throw new IllegalArgumentException();
        }
    }
}

