/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder.loader;

import org.alfresco.repo.model.filefolder.loader.AbstractLoaderThread;
import org.alfresco.repo.model.filefolder.loader.LoaderServerProxy;
import org.alfresco.repo.model.filefolder.loader.LoaderSession;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class LoaderTotalsThread
extends AbstractLoaderThread {
    public LoaderTotalsThread(LoaderSession session, String loaderName, long testPeriod, long testTotal, long testLoadDepth, boolean verbose) {
        super(session, loaderName, testPeriod, testTotal, testLoadDepth, verbose);
    }

    protected String doLoading(LoaderServerProxy serverProxy, NodeRef workingRootNodeRef) throws Exception {
        return this.getTotalsMessage();
    }

    public String getSummary() {
        return super.getSummary() + this.getTotalsMessage();
    }

    private String getTotalsMessage() {
        LoaderServerProxy serverProxy = this.session.getRemoteServers().get(0);
        StringBuilder sb = new StringBuilder();
        int totalNodeCount = serverProxy.loaderRemote.getNodeCount(serverProxy.ticket);
        sb.append(String.format("Total=%d", totalNodeCount));
        for (NodeRef nodeRef : this.session.getWorkingRootNodeRefs()) {
            StoreRef storeRef = nodeRef.getStoreRef();
            int storeNodeCount = serverProxy.loaderRemote.getNodeCount(serverProxy.ticket, storeRef);
            sb.append(", ").append(storeRef.getIdentifier()).append("=").append(storeNodeCount);
        }
        return sb.toString();
    }
}

