/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeArchiveServiceImpl
implements NodeArchiveService {
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org", (String)"NodeArchive");
    private static final long LOCK_TTL = 60000L;
    private static final String MSG_BUSY = "node.archive.msg.busy";
    private static Log logger = LogFactory.getLog(NodeArchiveServiceImpl.class);
    private NodeService nodeService;
    private PermissionService permissionService;
    private TransactionService transactionService;
    private JobLockService jobLockService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public NodeRef getStoreArchiveNode(StoreRef originalStoreRef) {
        return this.nodeService.getStoreArchiveNode(originalStoreRef);
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    @Override
    public NodeRef getArchivedNode(NodeRef originalNodeRef) {
        StoreRef orginalStoreRef = originalNodeRef.getStoreRef();
        NodeRef archiveRootNodeRef = this.nodeService.getStoreArchiveNode(orginalStoreRef);
        NodeRef archivedNodeRef = new NodeRef(archiveRootNodeRef.getStoreRef(), originalNodeRef.getId());
        return archivedNodeRef;
    }

    private List<NodeRef> getArchivedNodes(StoreRef originalStoreRef) {
        final NodeRef archiveParentNodeRef = this.nodeService.getStoreArchiveNode(originalStoreRef);
        AuthenticationUtil.RunAsWork<List<ChildAssociationRef>> runAsWork = new AuthenticationUtil.RunAsWork<List<ChildAssociationRef>>(){

            public List<ChildAssociationRef> doWork() throws Exception {
                String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                if (currentUser == null) {
                    throw new AccessDeniedException("No authenticated user; cannot get archived nodes.");
                }
                return NodeArchiveServiceImpl.this.nodeService.getChildAssocs(archiveParentNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)NodeArchiveService.QNAME_ARCHIVED_ITEM);
            }
        };
        List archivedAssocs = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)AuthenticationUtil.getSystemUserName());
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(archivedAssocs.size());
        for (ChildAssociationRef childAssociationRef : archivedAssocs) {
            NodeRef nodeRef = childAssociationRef.getChildRef();
            if (this.permissionService.hasPermission(nodeRef, "Delete") != AccessStatus.ALLOWED) continue;
            nodeRefs.add(nodeRef);
        }
        return nodeRefs;
    }

    private BatchProcessWorkProvider<NodeRef> getArchivedNodesWorkProvider(final StoreRef originalStoreRef, final String lockToken) {
        return new BatchProcessWorkProvider<NodeRef>(){
            private VmShutdownListener vmShutdownLister = new VmShutdownListener("getArchivedNodesWorkProvider");
            private List<NodeRef> nodeRefs;
            private boolean done;

            private synchronized List<NodeRef> getNodeRefs() {
                if (this.nodeRefs == null) {
                    this.nodeRefs = NodeArchiveServiceImpl.this.getArchivedNodes(originalStoreRef);
                }
                return this.nodeRefs;
            }

            @Override
            public synchronized int getTotalEstimatedWorkSize() {
                return 0;
            }

            @Override
            public synchronized Collection<NodeRef> getNextWork() {
                if (this.vmShutdownLister.isVmShuttingDown()) {
                    return Collections.emptyList();
                }
                try {
                    NodeArchiveServiceImpl.this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L);
                }
                catch (LockAcquisitionException e) {
                    return Collections.emptyList();
                }
                if (this.done) {
                    return Collections.emptyList();
                }
                this.done = true;
                return this.getNodeRefs();
            }
        };
    }

    @Override
    public RestoreNodeReport restoreArchivedNode(final NodeRef archivedNodeRef, final NodeRef destinationNodeRef, final QName assocTypeQName, final QName assocQName) {
        RestoreNodeReport report = new RestoreNodeReport(archivedNodeRef);
        report.setTargetParentNodeRef(destinationNodeRef);
        try {
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> restoreCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Exception {
                    return NodeArchiveServiceImpl.this.nodeService.restoreNode(archivedNodeRef, destinationNodeRef, assocTypeQName, assocQName);
                }
            };
            NodeRef newNodeRef = txnHelper.doInTransaction(restoreCallback, false, true);
            report.setRestoredNodeRef(newNodeRef);
            report.setStatus(RestoreNodeReport.RestoreStatus.SUCCESS);
        }
        catch (InvalidNodeRefException e) {
            report.setCause(e);
            NodeRef invalidNodeRef = e.getNodeRef();
            if (archivedNodeRef.equals((Object)invalidNodeRef)) {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_ARCHIVE_NODE);
            } else if (EqualsHelper.nullSafeEquals((Object)destinationNodeRef, (Object)invalidNodeRef)) {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT);
            } else if (destinationNodeRef == null) {
                ChildAssociationRef originalParentAssocRef = (ChildAssociationRef)this.nodeService.getProperty(archivedNodeRef, ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
                NodeRef originalParentNodeRef = originalParentAssocRef.getParentRef();
                if (EqualsHelper.nullSafeEquals((Object)originalParentNodeRef, (Object)invalidNodeRef)) {
                    report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT);
                } else {
                    report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
                }
            } else {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
            }
        }
        catch (AccessDeniedException e) {
            report.setCause((Throwable)((Object)e));
            report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_PERMISSION);
        }
        catch (Throwable e) {
            report.setCause(e);
            report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
            logger.error((Object)"An unhandled exception stopped the restore", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempted node restore: " + report));
        }
        return report;
    }

    @Override
    public RestoreNodeReport restoreArchivedNode(NodeRef archivedNodeRef) {
        return this.restoreArchivedNode(archivedNodeRef, null, null, null);
    }

    @Override
    public List<RestoreNodeReport> restoreArchivedNodes(List<NodeRef> archivedNodeRefs) {
        return this.restoreArchivedNodes(archivedNodeRefs, null, null, null);
    }

    @Override
    public List<RestoreNodeReport> restoreArchivedNodes(List<NodeRef> archivedNodeRefs, NodeRef destinationNodeRef, QName assocTypeQName, QName assocQName) {
        ArrayList<RestoreNodeReport> results = new ArrayList<RestoreNodeReport>(archivedNodeRefs.size());
        for (NodeRef nodeRef : archivedNodeRefs) {
            RestoreNodeReport result = this.restoreArchivedNode(nodeRef, destinationNodeRef, assocTypeQName, assocQName);
            results.add(result);
        }
        return results;
    }

    @Override
    public List<RestoreNodeReport> restoreAllArchivedNodes(StoreRef originalStoreRef) {
        final String user = AuthenticationUtil.getFullyAuthenticatedUser();
        if (user == null) {
            throw new IllegalStateException("Cannot restore as there is no authenticated user.");
        }
        final List<RestoreNodeReport> results = Collections.synchronizedList(new ArrayList(1000));
        BatchProcessor.BatchProcessWorkerAdaptor<NodeRef> worker = new BatchProcessor.BatchProcessWorkerAdaptor<NodeRef>(){

            @Override
            public void beforeProcess() throws Throwable {
                AuthenticationUtil.pushAuthentication();
            }

            @Override
            public void process(NodeRef entry) throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)user);
                if (NodeArchiveServiceImpl.this.nodeService.exists(entry)) {
                    RestoreNodeReport report = NodeArchiveServiceImpl.this.restoreArchivedNode(entry);
                    results.add(report);
                }
            }

            @Override
            public void afterProcess() throws Throwable {
                AuthenticationUtil.popAuthentication();
            }
        };
        this.doBulkOperation(user, originalStoreRef, (BatchProcessor.BatchProcessWorker<NodeRef>)worker);
        return results;
    }

    @Override
    public List<RestoreNodeReport> restoreAllArchivedNodes(StoreRef originalStoreRef, final NodeRef destinationNodeRef, final QName assocTypeQName, final QName assocQName) {
        final String user = AuthenticationUtil.getFullyAuthenticatedUser();
        if (user == null) {
            throw new IllegalStateException("Cannot restore as there is no authenticated user.");
        }
        final List<RestoreNodeReport> results = Collections.synchronizedList(new ArrayList(1000));
        BatchProcessor.BatchProcessWorkerAdaptor<NodeRef> worker = new BatchProcessor.BatchProcessWorkerAdaptor<NodeRef>(){

            @Override
            public void beforeProcess() throws Throwable {
                AuthenticationUtil.pushAuthentication();
            }

            @Override
            public void process(NodeRef nodeRef) throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)user);
                if (NodeArchiveServiceImpl.this.nodeService.exists(nodeRef)) {
                    RestoreNodeReport report = NodeArchiveServiceImpl.this.restoreArchivedNode(nodeRef, destinationNodeRef, assocTypeQName, assocQName);
                    results.add(report);
                }
            }

            @Override
            public void afterProcess() throws Throwable {
                AuthenticationUtil.popAuthentication();
            }
        };
        this.doBulkOperation(user, originalStoreRef, (BatchProcessor.BatchProcessWorker<NodeRef>)worker);
        return results;
    }

    @Override
    public void purgeArchivedNode(final NodeRef archivedNodeRef) {
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                try {
                    NodeArchiveServiceImpl.this.nodeService.deleteNode(archivedNodeRef);
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                    // empty catch block
                }
                return null;
            }
        };
        txnHelper.doInTransaction(deleteCallback, false, true);
    }

    @Override
    public void purgeArchivedNodes(List<NodeRef> archivedNodes) {
        for (NodeRef archivedNodeRef : archivedNodes) {
            this.purgeArchivedNode(archivedNodeRef);
        }
    }

    @Override
    public void purgeAllArchivedNodes(StoreRef originalStoreRef) {
        final String user = AuthenticationUtil.getFullyAuthenticatedUser();
        if (user == null) {
            throw new IllegalStateException("Cannot purge as there is no authenticated user.");
        }
        BatchProcessor.BatchProcessWorkerAdaptor<NodeRef> worker = new BatchProcessor.BatchProcessWorkerAdaptor<NodeRef>(){

            @Override
            public void beforeProcess() throws Throwable {
                AuthenticationUtil.pushAuthentication();
            }

            @Override
            public void process(NodeRef nodeRef) throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)user);
                if (NodeArchiveServiceImpl.this.nodeService.exists(nodeRef)) {
                    NodeArchiveServiceImpl.this.nodeService.deleteNode(nodeRef);
                }
            }

            @Override
            public void afterProcess() throws Throwable {
                AuthenticationUtil.popAuthentication();
            }
        };
        this.doBulkOperation(user, originalStoreRef, (BatchProcessor.BatchProcessWorker<NodeRef>)worker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doBulkOperation(String user, StoreRef originalStoreRef, BatchProcessor.BatchProcessWorker<NodeRef> worker) {
        String lockToken = null;
        try {
            try {
                lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
                BatchProcessor<NodeRef> batchProcessor = new BatchProcessor<NodeRef>("ArchiveBulkPurgeOrRestore", this.transactionService.getRetryingTransactionHelper(), this.getArchivedNodesWorkProvider(originalStoreRef, lockToken), 2, 20, null, null, 1000);
                batchProcessor.process(worker, true);
            }
            catch (LockAcquisitionException e) {
                throw new AlfrescoRuntimeException(MSG_BUSY);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (lockToken == null) throw throwable;
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                throw throwable;
            }
            catch (LockAcquisitionException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (LockAcquisitionException e) {}
        if (lockToken == null) return;
        this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
        return;
    }
}

